/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive.function.client;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.web.reactive.function.client.ClientHttpConnectorFactory;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientSsl;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.web.reactive.function.client.WebClient;

class AutoConfiguredWebClientSsl
implements WebClientSsl {
    private final ClientHttpConnectorFactory<?> clientHttpConnectorFactory;
    private final SslBundles sslBundles;

    AutoConfiguredWebClientSsl(ClientHttpConnectorFactory<?> clientHttpConnectorFactory, SslBundles sslBundles) {
        this.clientHttpConnectorFactory = clientHttpConnectorFactory;
        this.sslBundles = sslBundles;
    }

    @Override
    public Consumer<WebClient.Builder> fromBundle(String bundleName) {
        return this.fromBundle(this.sslBundles.getBundle(bundleName));
    }

    @Override
    public Consumer<WebClient.Builder> fromBundle(SslBundle bundle) {
        return builder -> {
            Object connector = this.clientHttpConnectorFactory.createClientHttpConnector(bundle);
            builder.clientConnector(connector);
        };
    }
}

