/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolver;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryAdapterFactory
implements RepositoryFactory {
    private final RepositoryService repositoryService;
    private final Validator validator;
    private final ExternalPropertiesResolver resolver;

    @Autowired
    public RepositoryAdapterFactory(RepositoryService repositoryService, Validator validator, ExternalPropertiesResolver resolver) {
        this.repositoryService = repositoryService;
        this.validator = validator;
        this.resolver = resolver;
    }

    public Repository create() {
        return this.create((WorkDir)null);
    }

    public Repository create(File temporaryWorkDir) {
        return this.create(new WorkDir((LocalFile)LocalFile.valueOf((File)temporaryWorkDir)));
    }

    public Repository create(WorkDir workDir) {
        return new RepositoryAdapter(this.repositoryService, this.validator, this.resolver, workDir);
    }
}

