/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Objects;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.Lazy;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.StringUtils;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final DeclaredQuery query;
    private final Lazy<DeclaredQuery> countQuery;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;
    private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();
    private final QueryRewriter queryRewriter;
    private final QuerySortRewriter querySortRewriter;
    private final Lazy<ParameterBinder> countParameterBinder;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, QueryRewriter queryRewriter, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em);
        Assert.hasText((String)queryString, (String)"Query string must not be null or empty");
        Assert.notNull((Object)evaluationContextProvider, (String)"ExpressionEvaluationContextProvider must not be null");
        Assert.notNull((Object)parser, (String)"Parser must not be null");
        Assert.notNull((Object)queryRewriter, (String)"QueryRewriter must not be null");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser, method.isNativeQuery());
        this.countQuery = Lazy.of(() -> {
            if (StringUtils.hasText((String)countQueryString)) {
                return new ExpressionBasedStringQuery(countQueryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser, method.isNativeQuery());
            }
            return this.query.deriveCountQuery(method.getCountQueryProjection());
        });
        this.countParameterBinder = Lazy.of(() -> this.createBinder((DeclaredQuery)this.countQuery.get()));
        this.parser = parser;
        this.queryRewriter = queryRewriter;
        JpaParameters parameters = method.getParameters();
        this.querySortRewriter = parameters.hasPageableParameter() || parameters.hasSortParameter() ? new CachingQuerySortRewriter() : NoOpQuerySortRewriter.INSTANCE;
        Assert.isTrue((method.isNativeQuery() || !this.query.usesJdbcStyleParameters() ? 1 : 0) != 0, (String)"JDBC style parameters (?) are not supported for JPA queries");
    }

    @Override
    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        Sort sort = accessor.getSort();
        String sortedQueryString = this.querySortRewriter.getSorted(this.query, sort);
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Query query = this.createJpaQuery(sortedQueryString, sort, accessor.getPageable(), processor.getReturnedType());
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(sortedQueryString, query);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, metadata, accessor);
    }

    @Override
    protected ParameterBinder createBinder() {
        return this.createBinder(this.query);
    }

    protected ParameterBinder createBinder(DeclaredQuery query) {
        return ParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), query, this.parser, this.evaluationContextProvider);
    }

    @Override
    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        String queryString = ((DeclaredQuery)this.countQuery.get()).getQueryString();
        EntityManager em = this.getEntityManager();
        Query query = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class);
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(queryString, query);
        ((ParameterBinder)this.countParameterBinder.get()).bind(metadata.withQuery(query), accessor, QueryParameterSetter.ErrorHandling.LENIENT);
        return query;
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public DeclaredQuery getCountQuery() {
        return (DeclaredQuery)this.countQuery.get();
    }

    protected Query createJpaQuery(String queryString, Sort sort, @Nullable Pageable pageable, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(this.potentiallyRewriteQuery(queryString, sort, pageable));
        }
        Class<?> typeToRead = this.getTypeToRead(returnedType);
        return typeToRead == null ? em.createQuery(this.potentiallyRewriteQuery(queryString, sort, pageable)) : em.createQuery(this.potentiallyRewriteQuery(queryString, sort, pageable), typeToRead);
    }

    protected String potentiallyRewriteQuery(String originalQuery, Sort sort, @Nullable Pageable pageable) {
        return pageable != null && pageable.isPaged() ? this.queryRewriter.rewrite(originalQuery, pageable) : this.queryRewriter.rewrite(originalQuery, sort);
    }

    String applySorting(CachableQuery cachableQuery) {
        return QueryEnhancerFactory.forQuery(cachableQuery.getDeclaredQuery()).applySorting(cachableQuery.getSort(), cachableQuery.getAlias());
    }

    static class CachableQuery {
        private final DeclaredQuery declaredQuery;
        private final String queryString;
        private final Sort sort;

        CachableQuery(DeclaredQuery query, Sort sort) {
            this.declaredQuery = query;
            this.queryString = query.getQueryString();
            this.sort = sort;
        }

        DeclaredQuery getDeclaredQuery() {
            return this.declaredQuery;
        }

        Sort getSort() {
            return this.sort;
        }

        @Nullable
        String getAlias() {
            return this.declaredQuery.getAlias();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachableQuery that = (CachableQuery)o;
            if (!Objects.equals(this.queryString, that.queryString)) {
                return false;
            }
            return Objects.equals(this.sort, that.sort);
        }

        public int hashCode() {
            int result = this.queryString != null ? this.queryString.hashCode() : 0;
            result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
            return result;
        }
    }

    class CachingQuerySortRewriter
    implements QuerySortRewriter {
        private final ConcurrentLruCache<CachableQuery, String> queryCache = new ConcurrentLruCache(16, abstractStringBasedJpaQuery::applySorting);

        CachingQuerySortRewriter() {
        }

        @Override
        public String getSorted(DeclaredQuery query, Sort sort) {
            if (sort.isUnsorted()) {
                return query.getQueryString();
            }
            return (String)this.queryCache.get((Object)new CachableQuery(query, sort));
        }
    }

    static enum NoOpQuerySortRewriter implements QuerySortRewriter
    {
        INSTANCE;


        @Override
        public String getSorted(DeclaredQuery query, Sort sort) {
            if (sort.isSorted()) {
                throw new UnsupportedOperationException("NoOpQueryCache does not support sorting");
            }
            return query.getQueryString();
        }
    }

    static interface QuerySortRewriter {
        public String getSorted(DeclaredQuery var1, Sort var2);
    }
}

