/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.scaladsl;

import com.typesafe.sslconfig.pekko.PekkoSSLConfig;
import com.typesafe.sslconfig.pekko.PekkoSSLConfig$;
import com.typesafe.sslconfig.pekko.util.PekkoLoggerFactory;
import com.typesafe.sslconfig.ssl.ClientAuth;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.stream.TLSClientAuth;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}3q!\u0003\u0006\u0011\u0002\u0007\u0005Q\u0003C\u0003\u001d\u0001\u0011\u0005Q\u0004C\u0003\"\u0001\u0019E!\u0005C\u0003*\u0001\u0011\u0005!\u0006\u0003\u00047\u0001\u0001&Ia\u000e\u0005\u0006}\u0001!\t!\b\u0005\u0006\u0013\u0002!\tA\u0013\u0005\u0006%\u0002!\ta\u0015\u0005\u0006-\u0002!\ta\u0016\u0002\u001a\t\u00164\u0017-\u001e7u'Nc5i\u001c8uKb$8I]3bi&|gN\u0003\u0002\f\u0019\u0005A1oY1mC\u0012\u001cHN\u0003\u0002\u000e\u001d\u0005!\u0001\u000e\u001e;q\u0015\ty\u0001#A\u0003qK.\\wN\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001\u001f!\t9r$\u0003\u0002!1\t!QK\\5u\u0003\u0019\u0019\u0018p\u001d;f[V\t1\u0005\u0005\u0002%O5\tQE\u0003\u0002'\u001d\u0005)\u0011m\u0019;pe&\u0011\u0001&\n\u0002\f\u0003\u000e$xN]*zgR,W.A\u0005tg2\u001cuN\u001c4jOV\t1\u0006\u0005\u0002-i5\tQF\u0003\u0002\u0010])\u0011q\u0006M\u0001\ngNd7m\u001c8gS\u001eT!!\r\u001a\u0002\u0011QL\b/Z:bM\u0016T\u0011aM\u0001\u0004G>l\u0017BA\u001b.\u00059\u0001Vm[6p'Nc5i\u001c8gS\u001e\f1\u0001\\8h+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u000f\u0003\u0015)g/\u001a8u\u0013\ti$H\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002CY\fG.\u001b3bi\u0016\fe\u000eZ,be:\f%m\\;u\u0019>|7/Z*fiRLgnZ:)\r\u0015\u00015\t\u0012$H!\t9\u0012)\u0003\u0002C1\tQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\nQ)\u0001\u0012QK.\\wnU*M\u0007>tg-[4!kN\fw-\u001a\u0011jg\u0002\"W\r\u001d:fG\u0006$X\rZ\u0001\u0006g&t7-Z\u0011\u0002\u0011\u00061\u0011\u0007\r\u00183]A\nqd\u0019:fCR,G)\u001a4bk2$8\t\\5f]RDE\u000f\u001e9t\u0007>tG/\u001a=u)\u0005Y\u0005C\u0001'N\u001b\u0005Q\u0011B\u0001(\u000b\u0005YAE\u000f\u001e9t\u0007>tg.Z2uS>t7i\u001c8uKb$\bF\u0002\u0004A\u0007B3u)I\u0001R\u0003!*8/\u001a\u0011D_:tWm\u0019;j_:\u001cuN\u001c;fqRt\u0003\u000e\u001e;q'\u0016\u0014h/\u001a:!S:\u001cH/Z1e\u0003a\u0019'/Z1uKN+'O^3s\u0011R$\bo]\"p]R,\u0007\u0010\u001e\u000b\u0003\u0017RCQ!K\u0004A\u0002-Bca\u0002!D!\u001a;\u0015\u0001G2sK\u0006$Xm\u00117jK:$\b\n\u001e;qg\u000e{g\u000e^3yiR\u00111\n\u0017\u0005\u0006S!\u0001\ra\u000b\u0015\u0007\u0011\u0001\u001b%LR$\"\u0003m\u000bA'^:fA\r{gN\\3di&|gnQ8oi\u0016DHO\f5uiB\u001cE.[3oi\"\u001a8\u000f\\\"p]R,\u0007\u0010^\u0015!S:\u001cH/Z1eQ\u0019\u0001\u0001iQ/G\u000f\u0006\na,\u0001\u001evg\u0016\u00043i\u001c8oK\u000e$\u0018n\u001c8D_:$X\r\u001f;/QR$\bo]*feZ,'\u000fI1oI\u0002BG\u000f\u001e9t\u00072LWM\u001c;!I&\u0014Xm\u0019;ms\u0002")
public interface DefaultSSLContextCreation {
    public ActorSystem system();

    public static /* synthetic */ PekkoSSLConfig sslConfig$(DefaultSSLContextCreation $this) {
        return $this.sslConfig();
    }

    default public PekkoSSLConfig sslConfig() {
        return (PekkoSSLConfig)PekkoSSLConfig$.MODULE$.apply(this.system());
    }

    private LoggingAdapter log() {
        return this.system().log();
    }

    public static /* synthetic */ void validateAndWarnAboutLooseSettings$(DefaultSSLContextCreation $this) {
        $this.validateAndWarnAboutLooseSettings();
    }

    default public void validateAndWarnAboutLooseSettings() {
    }

    public static /* synthetic */ HttpsConnectionContext createDefaultClientHttpsContext$(DefaultSSLContextCreation $this) {
        return $this.createDefaultClientHttpsContext();
    }

    default public HttpsConnectionContext createDefaultClientHttpsContext() {
        return this.createClientHttpsContext((PekkoSSLConfig)PekkoSSLConfig$.MODULE$.apply(this.system()));
    }

    public static /* synthetic */ HttpsConnectionContext createServerHttpsContext$(DefaultSSLContextCreation $this, PekkoSSLConfig sslConfig) {
        return $this.createServerHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createServerHttpsContext(PekkoSSLConfig sslConfig) {
        this.log().warning("Automatic server-side configuration is not supported yet, will attempt to use client-side settings. Instead it is recommended to construct the Servers HttpsConnectionContext manually (via SSLContext).");
        return this.createClientHttpsContext(sslConfig);
    }

    public static /* synthetic */ HttpsConnectionContext createClientHttpsContext$(DefaultSSLContextCreation $this, PekkoSSLConfig sslConfig) {
        return $this.createClientHttpsContext(sslConfig);
    }

    default public HttpsConnectionContext createClientHttpsContext(PekkoSSLConfig sslConfig) {
        None$ none$;
        SSLContext sSLContext;
        SSLConfigSettings config = sslConfig.config();
        LoggingAdapter log = Logging$.MODULE$.apply(this.system(), this.getClass(), LogSource$.MODULE$.fromClass());
        PekkoLoggerFactory mkLogger = new PekkoLoggerFactory(this.system());
        if (sslConfig.config().default()) {
            log.debug("buildSSLContext: ssl-config.default is true, using default SSLContext");
            sslConfig.validateDefaultTrustManager(config);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = sslConfig.buildKeyManagerFactory(config);
            TrustManagerFactoryWrapper trustManagerFactory = sslConfig.buildTrustManagerFactory(config);
            sSLContext = new ConfigSSLContextBuilder((LoggerFactory)mkLogger, config, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = sslConfig.configureProtocols(defaultProtocols, config);
        defaultParams.setProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = sslConfig.configureCipherSuites(defaultCiphers, config);
        defaultParams.setCipherSuites(cipherSuites);
        ClientAuth clientAuth = config.sslParametersConfig().clientAuth();
        if (ClientAuth.Default$.MODULE$.equals(clientAuth)) {
            none$ = None$.MODULE$;
        } else if (ClientAuth.Want$.MODULE$.equals(clientAuth)) {
            none$ = new Some((Object)TLSClientAuth.Want$.MODULE$);
        } else if (ClientAuth.Need$.MODULE$.equals(clientAuth)) {
            none$ = new Some((Object)TLSClientAuth.Need$.MODULE$);
        } else if (ClientAuth.None$.MODULE$.equals(clientAuth)) {
            none$ = new Some((Object)TLSClientAuth.None$.MODULE$);
        } else {
            throw new MatchError((Object)clientAuth);
        }
        None$ clientAuth2 = none$;
        if (!sslConfig.config().loose().disableHostnameVerification()) {
            defaultParams.setEndpointIdentificationAlgorithm("https");
        }
        return new HttpsConnectionContext(sslContext, (Option<PekkoSSLConfig>)new Some((Object)sslConfig), (Option<Seq<String>>)new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])cipherSuites).toList()), (Option<Seq<String>>)new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])defaultProtocols).toList()), (Option<TLSClientAuth>)clientAuth2, (Option<SSLParameters>)new Some((Object)defaultParams));
    }

    public static void $init$(DefaultSSLContextCreation $this) {
    }
}

