/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.model.domain.AbstractIdentifiableType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

public class MappedSuperclassTypeImpl<J>
extends AbstractIdentifiableType<J>
implements MappedSuperclassDomainType<J> {
    public MappedSuperclassTypeImpl(JavaType<J> javaType, MappedSuperclass mappedSuperclass, IdentifiableDomainType<? super J> superType, JpaMetamodelImplementor jpaMetamodel) {
        super(javaType.getJavaType().getTypeName(), javaType, superType, mappedSuperclass.getDeclaredIdentifierMapper() != null || superType != null && superType.hasIdClass(), mappedSuperclass.hasIdentifierProperty(), mappedSuperclass.isVersioned(), jpaMetamodel);
    }

    @Override
    public String getPathName() {
        return this.getTypeName();
    }

    @Override
    public MappedSuperclassDomainType<J> getSqmPathType() {
        return this;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        PersistentAttribute<J, ?> attribute = this.findAttribute(name);
        if (attribute != null) {
            return (SqmPathSource)((Object)attribute);
        }
        if ("id".equalsIgnoreCase(name) && this.hasIdClass()) {
            return this.getIdentifierDescriptor();
        }
        return null;
    }

    @Override
    public PersistentAttribute<? super J, ?> findAttribute(String name) {
        SingularPersistentAttribute idAttribute;
        PersistentAttribute attribute = super.findAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (("id".equalsIgnoreCase(name) || "{id}".equals(name)) && (idAttribute = this.findIdAttribute()) != null) {
            return idAttribute;
        }
        return null;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.MAPPED_SUPERCLASS;
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        if (!this.getBindableJavaType().isAssignableFrom(subType)) {
            throw new IllegalArgumentException(String.format("MappedSuperclass type [%s] cannot be treated as requested sub-type [%s]", this.getTypeName(), subType.getName()));
        }
        return new SubGraphImpl(this, true, this.jpaMetamodel());
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return this.makeSubGraph(this.getBindableJavaType());
    }

    @Override
    protected boolean isIdMappingRequired() {
        return false;
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("MappedSuperclassType cannot be used to create an SqmPath - that would be an SqmFrom which are created directly");
    }
}

