/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ExecutorLifecycleDelegate;
import org.springframework.scheduling.concurrent.ReschedulingRunnable;
import org.springframework.scheduling.support.DelegatingErrorHandlingRunnable;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class SimpleAsyncTaskScheduler
extends SimpleAsyncTaskExecutor
implements TaskScheduler,
ApplicationContextAware,
SmartLifecycle,
ApplicationListener<ContextClosedEvent> {
    private static final TimeUnit NANO = TimeUnit.NANOSECONDS;
    private final ScheduledExecutorService scheduledExecutor = this.createScheduledExecutor();
    private final ExecutorLifecycleDelegate lifecycleDelegate = new ExecutorLifecycleDelegate(this.scheduledExecutor);
    private Clock clock = Clock.systemDefaultZone();
    private int phase = Integer.MAX_VALUE;
    @Nullable
    private Executor targetTaskExecutor;
    @Nullable
    private ApplicationContext applicationContext;

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"Clock must not be null");
        this.clock = clock;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    public void setTargetTaskExecutor(Executor targetTaskExecutor) {
        this.targetTaskExecutor = targetTaskExecutor == this ? null : targetTaskExecutor;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private ScheduledExecutorService createScheduledExecutor() {
        return new ScheduledThreadPoolExecutor(1, x$0 -> this.newThread(x$0)){

            @Override
            protected void beforeExecute(Thread thread, Runnable task) {
                SimpleAsyncTaskScheduler.this.lifecycleDelegate.beforeExecute(thread);
            }

            @Override
            protected void afterExecute(Runnable task, Throwable ex) {
                SimpleAsyncTaskScheduler.this.lifecycleDelegate.afterExecute();
            }
        };
    }

    protected void doExecute(Runnable task) {
        if (this.targetTaskExecutor != null) {
            this.targetTaskExecutor.execute(task);
        } else {
            super.doExecute(task);
        }
    }

    private Runnable taskOnSchedulerThread(Runnable task) {
        return new DelegatingErrorHandlingRunnable(task, TaskUtils.getDefaultErrorHandler(true));
    }

    private Runnable scheduledTask(Runnable task) {
        return () -> this.execute(new DelegatingErrorHandlingRunnable(task, this::shutdownAwareErrorHandler));
    }

    private void shutdownAwareErrorHandler(Throwable ex) {
        if (this.scheduledExecutor.isTerminated()) {
            LogFactory.getLog(this.getClass()).debug((Object)"Ignoring scheduled task exception after shutdown", ex);
        } else {
            TaskUtils.getDefaultErrorHandler(true).handleError(ex);
        }
    }

    @Override
    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        try {
            Runnable delegate = this.scheduledTask(task);
            ErrorHandler errorHandler = TaskUtils.getDefaultErrorHandler(true);
            return new ReschedulingRunnable(delegate, trigger, this.clock, this.scheduledExecutor, errorHandler).schedule();
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException((Executor)this.scheduledExecutor, (Object)task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        Duration delay = Duration.between(this.clock.instant(), startTime);
        try {
            return this.scheduledExecutor.schedule(this.scheduledTask(task), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException((Executor)this.scheduledExecutor, (Object)task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return this.scheduledExecutor.scheduleAtFixedRate(this.scheduledTask(task), NANO.convert(initialDelay), NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException((Executor)this.scheduledExecutor, (Object)task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        try {
            return this.scheduledExecutor.scheduleAtFixedRate(this.scheduledTask(task), 0L, NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException((Executor)this.scheduledExecutor, (Object)task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return this.scheduledExecutor.scheduleWithFixedDelay(this.taskOnSchedulerThread(task), NANO.convert(initialDelay), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException((Executor)this.scheduledExecutor, (Object)task, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        try {
            return this.scheduledExecutor.scheduleWithFixedDelay(this.taskOnSchedulerThread(task), 0L, NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException((Executor)this.scheduledExecutor, (Object)task, ex);
        }
    }

    @Override
    public void start() {
        this.lifecycleDelegate.start();
    }

    @Override
    public void stop() {
        this.lifecycleDelegate.stop();
    }

    @Override
    public void stop(Runnable callback) {
        this.lifecycleDelegate.stop(callback);
    }

    @Override
    public boolean isRunning() {
        return this.lifecycleDelegate.isRunning();
    }

    @Override
    public void onApplicationEvent(ContextClosedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            this.scheduledExecutor.shutdown();
        }
    }

    public void close() {
        for (Runnable remainingTask : this.scheduledExecutor.shutdownNow()) {
            if (!(remainingTask instanceof Future)) continue;
            Future future = (Future)((Object)remainingTask);
            future.cancel(true);
        }
        super.close();
    }
}

