/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.service.impl;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.model.XldUserProfile;
import com.xebialabs.deployit.security.model.XldUserProfile$;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.service.UserProfileService;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.io.Serializable;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\u0007\u000e\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003K\u0001\u0011\u00051\nC\u0003U\u0001\u0011\u0005S\u000bC\u0003U\u0001\u0011\u0005c\u000eC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0003}\u0001\u0011%Q\u0010C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016\t1Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u000f\u001f\u0005!\u0011.\u001c9m\u0015\t\u0001\u0012#A\u0004tKJ4\u0018nY3\u000b\u0005I\u0019\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005Q)\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0012\u000e\u0003=I!\u0001J\b\u0003%U\u001bXM\u001d)s_\u001aLG.Z*feZL7-Z\u0001\u0019q2$Wk]3s!J|g-\u001b7f%\u0016\u0004xn]5u_JL\bCA\u0014+\u001b\u0005A#BA\u0015\u0012\u0003)\u0011X\r]8tSR|'/_\u0005\u0003W!\u0012\u0001\u0004\u00177e+N,'\u000f\u0015:pM&dWMU3q_NLGo\u001c:zQ\t\tQ\u0006\u0005\u0002/s5\tqF\u0003\u00021c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001a\u0014a\u00024bGR|'/\u001f\u0006\u0003iU\nQAY3b]NT!AN\u001c\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e0\u0005%\tU\u000f^8xSJ,G-A\u0006s_2,7+\u001a:wS\u000e,\u0007CA\u001f?\u001b\u0005\t\u0012BA \u0012\u0005-\u0011v\u000e\\3TKJ4\u0018nY3)\u0005\ti\u0013A\u00047jG\u0016t7/Z*feZL7-\u001a\t\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003!\u0015S!AR\u000b\u0002\u000f1L7-\u001a8tK&\u0011\u0001\n\u0012\u0002\u000f\u0019&\u001cWM\\:f'\u0016\u0014h/[2fQ\t\u0019Q&\u0001\u0004=S:LGO\u0010\u000b\u0005\u0019:\u0003&\u000b\u0005\u0002N\u00015\tQ\u0002C\u0003&\t\u0001\u0007a\u0005\u000b\u0002O[!)1\b\u0002a\u0001y!\u0012\u0001+\f\u0005\u0006\u0003\u0012\u0001\rA\u0011\u0015\u0003%6\nqAZ5oI>sW\rF\u0002W9&\u0004\"a\u0016.\u000e\u0003aS!!W\t\u0002\u000b5|G-\u001a7\n\u0005mC&A\u0004-mIV\u001bXM\u001d)s_\u001aLG.\u001a\u0005\u0006;\u0016\u0001\rAX\u0001\tkN,'O\\1nKB\u0011qL\u001a\b\u0003A\u0012\u0004\"!Y\u000f\u000e\u0003\tT!aY\r\u0002\rq\u0012xn\u001c;?\u0013\t)W$\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3\u001e\u0011\u0015QW\u00011\u0001l\u0003=aw.\u00193De\u0016$WM\u001c;jC2\u001c\bC\u0001\u000fm\u0013\tiWDA\u0004C_>dW-\u00198\u0015\u0005Y{\u0007\"B/\u0007\u0001\u0004q\u0016AD2sK\u0006$Xm\u0014:Va\u0012\fG/\u001a\u000b\u0004eV4\bC\u0001\u000ft\u0013\t!XD\u0001\u0003V]&$\b\"B/\b\u0001\u0004q\u0006bB<\b!\u0003\u0005\ra[\u0001\u0011C:\fG.\u001f;jGN,e.\u00192mK\u0012\f\u0011d\u0019:fCR,wJ]+qI\u0006$X-V:feB\u0013xNZ5mKR\u0011!O\u001f\u0005\u0006w\"\u0001\rAV\u0001\baJ|g-\u001b7f\u0003u\u0011XM^8lK2{w-\u001b8BY2|w/\u001a3BG\u000e|'\u000fZ5oOR{Gc\u0001,\u007f\u007f\")10\u0003a\u0001-\"1a)\u0003a\u0001\u0003\u0003\u0001B!a\u0001\u0002\u00065\tQ)C\u0002\u0002\b\u0015\u0013q\u0001T5dK:\u001cX-A\rd_VtG/V:fe^KG\u000f\u001b'pO&t\u0017\t\u001c7po\u0016$GCAA\u0007!\ra\u0012qB\u0005\u0004\u0003#i\"aA%oi\u0006\u0001R\u000f\u001d3bi\u0016d\u0015m\u001d;BGRLg/\u001a\u000b\u0007\u0003\u001b\t9\"!\u0007\t\u000bu[\u0001\u0019\u00010\t\u000f\u0005m1\u00021\u0001\u0002\u001e\u0005!A-\u0019;f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tA!\u001e;jY*\u0011\u0011qE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005\u0005\"\u0001\u0002#bi\u0016D3\u0001AA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bk\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005e\u00121\u0007\u0002\b'\u0016\u0014h/[2f\u0001")
public class UserProfileServiceImpl
implements UserProfileService {
    @Autowired
    private final XldUserProfileRepository xldUserProfileRepository;
    @Autowired
    private final RoleService roleService;
    @Autowired
    private final LicenseService licenseService;

    @Override
    public boolean createOrUpdate$default$2() {
        return UserProfileService.createOrUpdate$default$2$(this);
    }

    @Override
    public XldUserProfile findOne(String username, boolean loadCredentials) {
        Option<XldUserProfile> option = this.xldUserProfileRepository.findOne(username, this.xldUserProfileRepository.findOne$default$2());
        if (option instanceof Some) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Predef$.MODULE$.identity((Object)BoxedUnit.UNIT);
        } else if (None$.MODULE$.equals(option)) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.roleService.getRolesFor(SecurityContextHolder.getContext().getAuthentication()));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    throw new NotFoundException("No user profile found for user: " + username, new Object[0]);
                }
                throw new MatchError((Object)try_);
            }
            this.xldUserProfileRepository.createProfile(username, loadCredentials);
        } else {
            throw new MatchError(option);
        }
        return (XldUserProfile)this.xldUserProfileRepository.findOne(username, loadCredentials).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No user profile found for user: " + username, new Object[0]);
        });
    }

    @Override
    public XldUserProfile findOne(String username) {
        return this.findOne(username, false);
    }

    @Override
    public void createOrUpdate(String username, boolean analyticsEnabled) {
        Option<XldUserProfile> option = this.xldUserProfileRepository.findOne(username, this.xldUserProfileRepository.findOne$default$2());
        if (option instanceof Some) {
            this.xldUserProfileRepository.updateProfile(username, analyticsEnabled);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.xldUserProfileRepository.createProfile(username, analyticsEnabled);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public void createOrUpdateUserProfile(XldUserProfile profile) {
        XldUserProfile updatedProfile = this.revokeLoginAllowedAccordingTo(profile, this.licenseService.getLicense());
        Option<XldUserProfile> option = this.xldUserProfileRepository.findOne(updatedProfile.username(), this.xldUserProfileRepository.findOne$default$2());
        if (option instanceof Some) {
            this.xldUserProfileRepository.updateUserProfile(updatedProfile);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.xldUserProfileRepository.createUserProfile(updatedProfile);
            return;
        }
        throw new MatchError(option);
    }

    private XldUserProfile revokeLoginAllowedAccordingTo(XldUserProfile profile, License license) {
        int maxNumberOfUsers;
        if (!profile.loginAllowed()) {
            return profile;
        }
        int n = maxNumberOfUsers = license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS) != null ? Integer.parseInt(license.getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS)) : Integer.MIN_VALUE;
        if (BoxesRunTime.boxToInteger((int)maxNumberOfUsers) != null && maxNumberOfUsers <= this.countUserWithLoginAllowed()) {
            return XldUserProfile$.MODULE$.apply(profile.username(), profile.analyticsEnabled(), profile.fullName(), profile.email(), false, profile.lastActive(), profile.isInternal());
        }
        return profile;
    }

    @Override
    public int countUserWithLoginAllowed() {
        return this.xldUserProfileRepository.countUserWithLoginAllowed();
    }

    @Override
    public int updateLastActive(String username, Date date) {
        return this.xldUserProfileRepository.updateLastActive(username, date);
    }

    public UserProfileServiceImpl(@Autowired XldUserProfileRepository xldUserProfileRepository, @Autowired RoleService roleService, @Autowired LicenseService licenseService) {
        this.xldUserProfileRepository = xldUserProfileRepository;
        this.roleService = roleService;
        this.licenseService = licenseService;
    }
}

