/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import org.hibernate.dialect.Dialect;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.id.insert.BasicSelectingDelegate;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.id.insert.InsertReturningDelegate;

public class IdentityGenerator
implements PostInsertIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
StandardGenerator {
    @Override
    public boolean referenceColumnsInSql(Dialect dialect) {
        return dialect.getIdentityColumnSupport().hasIdentityInsertKeyword();
    }

    @Override
    public String[] getReferencedColumnValues(Dialect dialect) {
        return new String[]{dialect.getIdentityColumnSupport().getIdentityInsertString()};
    }

    @Override
    public InsertGeneratedIdentifierDelegate getGeneratedIdentifierDelegate(PostInsertIdentityPersister persister) {
        Dialect dialect = persister.getFactory().getJdbcServices().getDialect();
        if (persister.getFactory().getSessionFactoryOptions().isGetGeneratedKeysEnabled()) {
            return dialect.getIdentityColumnSupport().buildGetGeneratedKeysDelegate(persister, dialect);
        }
        if (dialect.getIdentityColumnSupport().supportsInsertSelectIdentity()) {
            return new InsertReturningDelegate(persister, dialect);
        }
        return new BasicSelectingDelegate(persister, dialect);
    }
}

