/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.Internal;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.Preparable;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderSupport;
import org.hibernate.loader.ast.internal.SingleIdLoadPlan;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class SingleIdEntityLoaderStandardImpl<T>
extends SingleIdEntityLoaderSupport<T>
implements Preparable {
    private EnumMap<LockMode, SingleIdLoadPlan> selectByLockMode = new EnumMap(LockMode.class);
    private EnumMap<CascadingFetchProfile, SingleIdLoadPlan> selectByInternalCascadeProfile;
    private AtomicInteger nonReusablePlansGenerated = new AtomicInteger();

    public AtomicInteger getNonReusablePlansGenerated() {
        return this.nonReusablePlansGenerated;
    }

    public SingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
    }

    @Override
    public void prepare() {
        LockOptions lockOptions = LockOptions.NONE;
        LoadQueryInfluencers queryInfluencers = new LoadQueryInfluencers(this.sessionFactory);
        SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, queryInfluencers, this.sessionFactory);
        if (this.determineIfReusable(lockOptions, queryInfluencers)) {
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
        }
    }

    @Override
    public T load(Object key, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SingleIdLoadPlan<T> loadPlan = this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return loadPlan.load(key, readOnly, true, session);
    }

    @Override
    public T load(Object key, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        SingleIdLoadPlan<T> loadPlan = this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return loadPlan.load(key, entityInstance, readOnly, false, session);
    }

    @Internal
    public SingleIdLoadPlan<T> resolveLoadPlan(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        if (this.getLoadable().isAffectedByEnabledFilters(loadQueryInfluencers)) {
            this.nonReusablePlansGenerated.incrementAndGet();
            return this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
        }
        CascadingFetchProfile enabledCascadingFetchProfile = loadQueryInfluencers.getEnabledCascadingFetchProfile();
        if (enabledCascadingFetchProfile != null && LockMode.WRITE.greaterThan(lockOptions.getLockMode())) {
            if (this.selectByInternalCascadeProfile == null) {
                this.selectByInternalCascadeProfile = new EnumMap(CascadingFetchProfile.class);
            } else {
                SingleIdLoadPlan existing = this.selectByInternalCascadeProfile.get((Object)enabledCascadingFetchProfile);
                if (existing != null) {
                    return existing;
                }
            }
            SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
            this.selectByInternalCascadeProfile.put(enabledCascadingFetchProfile, plan);
            return plan;
        }
        boolean reusable = this.determineIfReusable(lockOptions, loadQueryInfluencers);
        if (reusable) {
            SingleIdLoadPlan existing = this.selectByLockMode.get((Object)lockOptions.getLockMode());
            if (existing != null) {
                return existing;
            }
            SingleIdLoadPlan<T> plan = this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
            this.selectByLockMode.put(lockOptions.getLockMode(), plan);
            return plan;
        }
        this.nonReusablePlansGenerated.incrementAndGet();
        return this.createLoadPlan(lockOptions, loadQueryInfluencers, sessionFactory);
    }

    private boolean determineIfReusable(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) {
        if (this.getLoadable().isAffectedByEntityGraph(loadQueryInfluencers)) {
            return false;
        }
        if (this.getLoadable().isAffectedByEnabledFetchProfiles(loadQueryInfluencers)) {
            return false;
        }
        return lockOptions.getTimeOut() == -1;
    }

    private SingleIdLoadPlan<T> createLoadPlan(LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getIdentifierMapping(), null, 1, queryInfluencers, lockOptions, jdbcParametersBuilder::add, sessionFactory);
        JdbcParametersList jdbcParameters = jdbcParametersBuilder.build();
        return new SingleIdLoadPlan((org.hibernate.persister.entity.Loadable)this.getLoadable(), this.getLoadable().getIdentifierMapping(), sqlAst, jdbcParameters, lockOptions, sessionFactory);
    }
}

