/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.IOException;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.TagWriterImpl;

public class GeneratedMarshallerBase {
    private static final Log log = Log.LogFactory.getLog(GeneratedMarshallerBase.class);

    protected final <T> T readMessage(BaseMarshallerDelegate<T> marshallerDelegate, ProtobufTagMarshaller.ReadContext ctx) throws IOException {
        return marshallerDelegate.unmarshall(ctx, null);
    }

    protected final <T> void writeMessage(BaseMarshallerDelegate<T> marshallerDelegate, ProtobufTagMarshaller.WriteContext ctx, T message) throws IOException {
        if (message == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        marshallerDelegate.marshall(ctx, null, message);
        ctx.getWriter().flush();
    }

    protected final <T> void writeNestedMessage(BaseMarshallerDelegate<T> marshallerDelegate, ProtobufTagMarshaller.WriteContext ctx, int fieldNumber, T message) throws IOException {
        int maxNestedMessageDepth = ctx.getSerializationContext().getConfiguration().maxNestedMessageDepth();
        if (ctx.depth() >= maxNestedMessageDepth) {
            throw log.maxNestedMessageDepth(maxNestedMessageDepth, message.getClass());
        }
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        TagWriterImpl nested = TagWriterImpl.newNestedInstance(ctx, baos);
        this.writeMessage(marshallerDelegate, nested, message);
        ctx.getWriter().writeBytes(fieldNumber, baos.getByteBuffer());
    }
}

