/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum AddressField {
    ID("id"),
    NAME("name"),
    ROUTING_TYPES("routingTypes"),
    PRODUCER_ID("producerId"),
    QUEUE_COUNT("queueCount");

    private static final Map<String, AddressField> lookup;
    private final String name;

    public String getName() {
        return this.name;
    }

    private AddressField(String name) {
        this.name = name;
    }

    public static AddressField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, AddressField>(String.CASE_INSENSITIVE_ORDER);
        for (AddressField e : AddressField.values()) {
            lookup.put(e.name, e);
        }
    }
}

