/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;

public class ActiveMQChannelHandler
extends ChannelDuplexHandler {
    private final ChannelGroup group;
    private final BufferHandler handler;
    private final BaseConnectionLifeCycleListener<?> listener;
    protected volatile boolean active;
    private final Executor listenerExecutor;

    protected ActiveMQChannelHandler(ChannelGroup group, BufferHandler handler, BaseConnectionLifeCycleListener<?> listener, Executor listenerExecutor) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
        this.listenerExecutor = listenerExecutor;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.group.add((Object)ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.listener.connectionReadyForWrites(ActiveMQChannelHandler.channelId(ctx.channel()), ctx.channel().isWritable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        try {
            this.handler.bufferReceived(ActiveMQChannelHandler.channelId(ctx.channel()), (ActiveMQBuffer)new ChannelBufferWrapper(buffer));
        }
        finally {
            buffer.release();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        this.handler.endOfBatch(ActiveMQChannelHandler.channelId(ctx.channel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ActiveMQChannelHandler activeMQChannelHandler = this;
        synchronized (activeMQChannelHandler) {
            if (this.active) {
                this.listenerExecutor.execute(() -> this.listener.connectionDestroyed(ActiveMQChannelHandler.channelId(ctx.channel())));
                this.active = false;
            }
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.active) {
            return;
        }
        ActiveMQException me = new ActiveMQException(cause.getMessage());
        me.initCause(cause);
        BaseConnectionLifeCycleListener<?> baseConnectionLifeCycleListener = this.listener;
        synchronized (baseConnectionLifeCycleListener) {
            try {
                this.listenerExecutor.execute(() -> this.listener.connectionException(ActiveMQChannelHandler.channelId(ctx.channel()), me));
                this.active = false;
            }
            catch (Exception ex) {
                ActiveMQClientLogger.LOGGER.errorCallingLifeCycleListener(ex);
            }
        }
    }

    protected static Object channelId(Channel channel) {
        return channel.id();
    }
}

