/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.service.impl;

import ai.digital.deploy.task.status.util.DeploymentStatusUtils$;
import ai.digital.deploy.tasker.common.TaskType;
import ai.digital.deploy.webhook.WebhookServer;
import com.xebialabs.deployit.core.events.dto.ApplicationDeploymentPackageState;
import com.xebialabs.deployit.core.events.dto.DeploymentPackageState;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.core.service.ApplicationAndEnvironmentFilter;
import com.xebialabs.deployit.core.service.ApplicationStatusService;
import com.xebialabs.deployit.core.service.impl.DeploymentDetails;
import com.xebialabs.deployit.core.util.IdExtensions$;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.DeployedApplicationsRepository;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.client.PermissionService;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.dependency.RepositoryServiceAware;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.sugar.TempDirectorySugar;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.UUID;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tmg\u0001B\u0010!\u00015B\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\"A\u0001\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!9\bA!A!\u0002\u0013A\bBCA\u0001\u0001\t\u0015\r\u0011\"\u0011\u0002\u0004!Q\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0002\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002D!I\u0011Q\u000b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003/\u0002\u0001\u0015!\u0003\u0002D!I\u0011\u0011\f\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002D!9\u0011Q\f\u0001\u0005B\u0005}\u0003\"CAf\u0001E\u0005I\u0011AAg\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!a:\u0001\t\u0013\tI\u000fC\u0004\u0003*\u0001!IAa\u000b\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B7\u0001\u0011%!q\u000e\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011i\t\u0001C\u0005\u0005\u001fCqAa%\u0001\t\u0013\u0011)\nC\u0004\u0003\u001a\u0002!IAa'\t\u000f\t}\u0005\u0001\"\u0003\u0003\"\"9!Q\u0016\u0001\u0005\n\t=\u0006b\u0002B^\u0001\u0011%!Q\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0005q\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$Xo]*feZL7-Z%na2T!!\t\u0012\u0002\t%l\u0007\u000f\u001c\u0006\u0003G\u0011\nqa]3sm&\u001cWM\u0003\u0002&M\u0005!1m\u001c:f\u0015\t9\u0003&\u0001\u0005eKBdw._5u\u0015\tI#&A\u0005yK\nL\u0017\r\\1cg*\t1&A\u0002d_6\u001c\u0001aE\u0004\u0001]QBtH\u0011&\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001#\u0013\t9$E\u0001\rBaBd\u0017nY1uS>t7\u000b^1ukN\u001cVM\u001d<jG\u0016\u0004\"!O\u001f\u000e\u0003iR!a\u000f\u001f\u0002\u0015\u0011,\u0007/\u001a8eK:\u001c\u0017P\u0003\u0002$M%\u0011aH\u000f\u0002\u0017%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017i^1sKB\u0011Q\u0007Q\u0005\u0003\u0003\n\u0012q$\u00119qY&\u001c\u0017\r^5p]\u0006sG-\u00128wSJ|g.\\3oi\u001aKG\u000e^3s!\t\u0019\u0005*D\u0001E\u0015\t)e)A\u0003tk\u001e\f'O\u0003\u0002HQ\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\u0005%#%A\u0005+f[B$\u0015N]3di>\u0014\u0018pU;hCJ\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u000bMdg\r\u000e6\u000b\u0003=\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003#2\u0013q\u0001T8hO&tw-\u0001\u0010eKBdw._3e\u0003B\u0004H.[2bi&|gn\u001d*fa>\u001c\u0018\u000e^8ssB\u0011AkV\u0007\u0002+*\u0011aKJ\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001-V\u0005y!U\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogJ+\u0007o\\:ji>\u0014\u00180\u0001\u0007dSJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\\=6\tAL\u0003\u0002^+\u0006\u00191/\u001d7\n\u0005}c&\u0001D\"j%\u0016\u0004xn]5u_JL\u0018AB3oO&tW\rE\u0002cK\u001el\u0011a\u0019\u0006\u0003I\u001a\naa\u001d9sS:<\u0017B\u00014d\u0005-\u0011U-\u00198Xe\u0006\u0004\b/\u001a:\u0011\u0005!dW\"A5\u000b\u0005)\\\u0017A\u0002;bg.,'O\u0003\u0002aM%\u0011Q.\u001b\u0002\u0014)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]\u001eLg.Z\u0001\u0012a\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003\u0019\u0019G.[3oi*\u0011AOJ\u0001\tg\u0016\u001cWO]5us&\u0011a/\u001d\u0002\u0012!\u0016\u0014X.[:tS>t7+\u001a:wS\u000e,\u0017A\u0005:fa>\u001c\u0018\u000e^8ssJ+7o\\;sG\u0016\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0007\u0005\u0004\u0018N\u0003\u0002~I\u0005!!/Z:u\u0013\ty(P\u0001\nSKB|7/\u001b;pef\u0014Vm]8ve\u000e,\u0017!\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dKV\u0011\u0011Q\u0001\t\u0004)\u0006\u001d\u0011bAA\u0005+\n\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002%I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005E\u0011QCA\f\u00033\tY\"!\b\u0002 A\u0019\u00111\u0003\u0001\u000e\u0003\u0001BQA\u0015\u0005A\u0002MCQ!\u0017\u0005A\u0002iCQ\u0001\u0019\u0005A\u0002\u0005DQA\u001c\u0005A\u0002=DQa\u001e\u0005A\u0002aDq!!\u0001\t\u0001\u0004\t)\u0001K\u0002\t\u0003G\u0001B!!\n\u0002<5\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0006b]:|G/\u0019;j_:TA!!\f\u00020\u00059a-Y2u_JL(\u0002BA\u0019\u0003g\tQAY3b]NTA!!\u000e\u00028\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002:\u0005\u0019qN]4\n\t\u0005u\u0012q\u0005\u0002\n\u0003V$xn^5sK\u0012\fA\u0003Z3gCVdGo\u0014:eKJLgn\u001a$jK2$WCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001\\1oO*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005\u001d#AB*ue&tw-A\u000beK\u001a\fW\u000f\u001c;Pe\u0012,'/\u001b8h\r&,G\u000e\u001a\u0011\u00021\u0011,g-Y;mi>\u0013H-\u001a:j]\u001e$\u0015N]3di&|g.A\reK\u001a\fW\u000f\u001c;Pe\u0012,'/\u001b8h\t&\u0014Xm\u0019;j_:\u0004\u0013\u0001D5oi\u0016\u0014h.\u00197S_>$\u0018!D5oi\u0016\u0014h.\u00197S_>$\b%\u0001\u000bhKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$Xo\u001d\u000b\u000f\u0003C\ni(!&\u0002\u001a\u0006\r\u00161WAd!\u0019\t\u0019'!\u001b\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nY%\u0001\u0003vi&d\u0017\u0002BA6\u0003K\u0012A\u0001T5tiB!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014a\u00013u_*\u0019\u0011q\u000f\u0013\u0002\r\u00154XM\u001c;t\u0013\u0011\tY(!\u001d\u0003C\u0005\u0003\b\u000f\\5dCRLwN\u001c#fa2|\u00170\\3oiB\u000b7m[1hKN#\u0018\r^3\t\u000f\u0005}t\u00021\u0001\u0002\u0002\u0006yA-\u001a9m_f,G-\u00119q\u001d\u0006lW\r\u0005\u0003\u0002\u0004\u0006Ee\u0002BAC\u0003\u001b\u00032!a\"1\u001b\t\tIIC\u0002\u0002\f2\na\u0001\u0010:p_Rt\u0014bAAHa\u00051\u0001K]3eK\u001aLA!!\u0015\u0002\u0014*\u0019\u0011q\u0012\u0019\t\u000f\u0005]u\u00021\u0001\u0002\u0002\u0006!\u0001/\u0019;i\u0011%\tYj\u0004I\u0001\u0002\u0004\ti*A\u0005fq\u0006\u001cG\u000fU1uQB\u0019q&a(\n\u0007\u0005\u0005\u0006GA\u0004C_>dW-\u00198\t\u000f\u0005\u0015v\u00021\u0001\u0002(\u0006)qN\u001d3feB!\u0011\u0011VAX\u001b\t\tYK\u0003\u0003\u0002t\u00055&BA>l\u0013\u0011\t\t,a+\u0003\u0011=\u0013H-\u001a:j]\u001eDq!!.\u0010\u0001\u0004\t9,A\u0004g_2$WM]:\u0011\r\u0005e\u00161YAA\u001d\u0011\tY,a0\u000f\t\u0005\u001d\u0015QX\u0005\u0002c%\u0019\u0011\u0011\u0019\u0019\u0002\u000fA\f7m[1hK&!\u00111NAc\u0015\r\t\t\r\r\u0005\b\u0003\u0013|\u0001\u0019AAA\u0003)9XM\u00195p_.\u0014VMZ\u0001\u001fO\u0016$\u0018\t\u001d9mS\u000e\fG/[8o'R\fG/^:%I\u00164\u0017-\u001e7uIM*\"!a4+\t\u0005u\u0015\u0011[\u0016\u0003\u0003'\u0004B!!6\u0002^6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0006\u0019\n\t\u0005}\u0017q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F4fi\u001aKG\u000e^3sC\ndWMR8mI\u0016\u00148/\u0006\u0002\u0002fB1\u00111MA5\u0003\u0003\u000bAdZ3u\t\u0016\u0004Hn\\=fI\u0006\u0003\b\u000f\\5dCRLwN\\*uCR,7\u000f\u0006\u0007\u0002l\u0006}(\u0011\u0001B\u0002\u0005\u000b\u00119\u0001\u0005\u0005\u0002\u0004\u00065\u0018\u0011_A|\u0013\u0011\ty/a%\u0003\u00075\u000b\u0007\u000fE\u00040\u0003g\f\t)!!\n\u0007\u0005U\bG\u0001\u0004UkBdWM\r\t\t\u0003\u0007\u000bi/!=\u0002zB!\u00111CA~\u0013\r\ti\u0010\t\u0002\u0012\t\u0016\u0004Hn\\=nK:$H)\u001a;bS2\u001c\bbBA@%\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003/\u0013\u0002\u0019AAA\u0011\u001d\tYJ\u0005a\u0001\u0003;Cq!!.\u0013\u0001\u0004\t9\fC\u0004\u0003\nI\u0001\rAa\u0003\u0002\u001b],'\r[8pWN+'O^3s!\u0015y#Q\u0002B\t\u0013\r\u0011y\u0001\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tM!QE\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u00059q/\u001a2i_>\\'\u0002\u0002B\u000e\u0005;\ta\u0001Z3qY>L(\u0002\u0002B\u0010\u0005C\tq\u0001Z5hSR\fGN\u0003\u0002\u0003$\u0005\u0011\u0011-[\u0005\u0005\u0005O\u0011)BA\u0007XK\nDwn\\6TKJ4XM]\u0001\rgF,\u0018m\u001d5SKN,H\u000e\u001e\u000b\u0007\u0005[\u0011yC!\u000e\u0011\r\u0005e\u00161YA7\u0011\u001d\u0011\td\u0005a\u0001\u0005g\tA\u0001Z1uCB1\u0011\u0011XAb\u0003WDqAa\u000e\u0014\u0001\u0004\t\t)\u0001\u0005pe\u0012,'/\u001b8h\u0003)\u0011X\rZ;dK\u0016sgo]\u000b\u0003\u0005{\u0001\u0012b\fB \u0003o\f90a>\n\u0007\t\u0005\u0003GA\u0005Gk:\u001cG/[8oe\u0005QS.\u00199EKBdw._3e\u0003B\u0004H.[2bi&|gn\u001d+p\t\u0016\u0004Hn\\=nK:$H)\u001a;bS2\u001cH\u0003BAv\u0005\u000fBqA!\u0013\u0016\u0001\u0004\u0011Y%\u0001\u000beKBdw._3e\u0003B\u0004H.[2bi&|gn\u001d\t\u0007\u0005\u001b\u00129Fa\u0017\u000e\u0005\t=#\u0002\u0002B)\u0005'\nq!\\;uC\ndWMC\u0002\u0003VA\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IFa\u0014\u0003\r\t+hMZ3s!\u0011\u0011iF!\u001b\u000e\u0005\t}#\u0002\u0002B1\u0005G\n1!\u001e3n\u0015\rY(Q\r\u0006\u0004\u0005O2\u0013A\u00029mk\u001eLg.\u0003\u0003\u0003l\t}#a\u0005#fa2|\u00170\u001a3BaBd\u0017nY1uS>t\u0017!\u00074jYR,'OQ=EKBdw._7f]R\f\u0005\u000f\u001d(b[\u0016$b!!(\u0003r\t\u0005\u0005b\u0002B:-\u0001\u0007!QO\u0001\u0005i\u0006\u001c8\u000e\u0005\u0003\u0003x\tuTB\u0001B=\u0015\u0011\u0011Y(!,\u0002\u0013\u0015DXmY;uS>t\u0017\u0002\u0002B@\u0005s\u0012Q\u0002V1tW^KG\u000f\u001b\"m_\u000e\\\u0007bBA@-\u0001\u0007\u0011\u0011Q\u0001\u0013M&dG/\u001a:CsB\u000bG\u000f\u001b$jYR,'\u000f\u0006\u0005\u0002\u001e\n\u001d%\u0011\u0012BF\u0011\u001d\u0011\u0019h\u0006a\u0001\u0005kBq!a&\u0018\u0001\u0004\t\t\tC\u0004\u0002\u001c^\u0001\r!!(\u0002'\u0019LG\u000e^3s\u0005f\u0004VM]7jgNLwN\\:\u0015\t\u0005u%\u0011\u0013\u0005\b\u0005gB\u0002\u0019\u0001B;\u00039I7o\u0015;bi\u0016$UMZ5oK\u0012$B!!(\u0003\u0018\"9!1O\rA\u0002\tU\u0014AE5t)\u0006\u001c8\u000eV=qK&s7\r\\;eK\u0012$B!!(\u0003\u001e\"9!1\u000f\u000eA\u0002\tU\u0014!\u00064jYR,'OQ=XK\nDwn\\6GS2$XM\u001d\u000b\t\u0003;\u0013\u0019Ka*\u0003,\"9!QU\u000eA\u0002\u0005\u0005\u0015!D1qa2L7-\u0019;j_:LE\rC\u0004\u0003*n\u0001\r!!!\u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%e\u0011\u001d\u0011Ia\u0007a\u0001\u0005#\tQbZ3u)\u0006\u001c8n\u0015;bi\u0016\u001cH\u0003DAv\u0005c\u0013\u0019L!.\u00038\ne\u0006bBA@9\u0001\u0007\u0011\u0011\u0011\u0005\b\u0003/c\u0002\u0019AAA\u0011\u001d\tY\n\ba\u0001\u0003;Cq!!.\u001d\u0001\u0004\t9\fC\u0004\u0003\nq\u0001\rAa\u0003\u0002\u001b!\f7\u000fU3s[&\u001c8/[8o)\u0011\tiJa0\t\u000f\t\u0005W\u00041\u0001\u00028\u0006Q2/Z2ve\u0016$G)\u001b:fGR|'/\u001f*fM\u0016\u0014XM\\2fg\u0006!b-\u001b7uKJ\u0014\u0015PR8mI\u0016\u0014h)\u001b7uKJ$b!!(\u0003H\n-\u0007b\u0002Be=\u0001\u0007\u0011\u0011Q\u0001\u000bM>dG-\u001a:QCRD\u0007bBA[=\u0001\u0007\u0011q\u0017\u0015\u0004\u0001\t=\u0007\u0003\u0002Bi\u0005/l!Aa5\u000b\t\tU\u00171G\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002Bm\u0005'\u0014qaU3sm&\u001cW\r")
public class ApplicationStatusServiceImpl
implements ApplicationStatusService,
RepositoryServiceAware,
ApplicationAndEnvironmentFilter,
TempDirectorySugar,
Logging {
    private final DeployedApplicationsRepository deployedApplicationsRepository;
    private final CiRepository ciRepository;
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final PermissionService permissionService;
    private final RepositoryResource repositoryResource;
    private final RepositoryService repositoryService;
    private final String defaultOrderingField;
    private final String defaultOrderingDirection;
    private final String internalRoot;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public File createTempDirectory() {
        return TempDirectorySugar.createTempDirectory$((TempDirectorySugar)this);
    }

    public <T> T withTempDirectory(Function1<Path, T> function) {
        return (T)TempDirectorySugar.withTempDirectory$((TempDirectorySugar)this, function);
    }

    @Override
    public boolean matchAppEnvToDeploymentRegexp(WebhookServer webhookServer, String applicationId, String environmentId) {
        return ApplicationAndEnvironmentFilter.matchAppEnvToDeploymentRegexp$(this, webhookServer, applicationId, environmentId);
    }

    public <CI extends ConfigurationItem> SearchParameters typedSearchParameters(ClassTag<CI> evidence$1) {
        return RepositoryServiceAware.typedSearchParameters$((RepositoryServiceAware)this, evidence$1);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ApplicationStatusServiceImpl applicationStatusServiceImpl = this;
        synchronized (applicationStatusServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    private String defaultOrderingField() {
        return this.defaultOrderingField;
    }

    private String defaultOrderingDirection() {
        return this.defaultOrderingDirection;
    }

    private String internalRoot() {
        return this.internalRoot;
    }

    @Override
    public java.util.List<ApplicationDeploymentPackageState> getApplicationStatus(String deployedAppName, String path, boolean exactPath, com.xebialabs.deployit.engine.api.dto.Ordering order, List<String> folders, String webhookRef) {
        java.util.List list;
        block6: {
            Tuple2 tuple2;
            Tuple2 tuple22 = tuple2 = order == null ? new Tuple2((Object)this.defaultOrderingField(), (Object)this.defaultOrderingDirection()) : new Tuple2((Object)order.field(), (Object)order.direction().toString());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String orderingField = (String)tuple2._1();
            String direction = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)orderingField, (Object)direction);
            String orderingField2 = (String)tuple23._1();
            String direction2 = (String)tuple23._2();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                Option option = Option$.MODULE$.apply((Object)webhookRef);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String ref = (String)some.value();
                    return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.repositoryService().listEntities(this.typedSearchParameters(ClassTag$.MODULE$.apply(WebhookServer.class)))).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.enabled()))).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ApplicationStatusServiceImpl.$anonfun$getApplicationStatus$3(ref, x$3))).orElse((Function0 & Serializable)() -> {
                        throw new IllegalArgumentException("Webhook server with reference " + ref + " not found");
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            });
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    this.logger().warn((Function0 & Serializable)() -> "Exception occurred while fetching webhook server to match deployments and tasks: " + exception.getMessage());
                    return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava();
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Option value = (Option)success.value();
            Option webhookServerMaybe = value;
            Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>> deployedAppStates = this.getDeployedApplicationStates(deployedAppName, path, exactPath, folders, (Option<WebhookServer>)webhookServerMaybe);
            Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>> taskStates = this.getTaskStates(deployedAppName, path, exactPath, folders, (Option<WebhookServer>)webhookServerMaybe);
            List<ApplicationDeploymentPackageState> applicationStates = this.squashResult((List<Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>>>)new .colon.colon(deployedAppStates, (List)new .colon.colon(taskStates, (List)Nil$.MODULE$)), orderingField2);
            String string = direction2;
            switch (string == null ? 0 : string.hashCode()) {
                case 2094737: {
                    if (!"DESC".equals(string)) break;
                    list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)applicationStates.reverse()).asJava();
                    break block6;
                }
            }
            list = CollectionConverters$.MODULE$.SeqHasAsJava(applicationStates).asJava();
        }
        java.util.List applicationStatesData = list;
        return applicationStatesData;
    }

    public boolean getApplicationStatus$default$3() {
        return false;
    }

    @Override
    public java.util.List<String> getFilterableFolders() {
        SearchParameters criteria = new SearchParameters().setType(Type.valueOf(Directory.class)).setAncestor(this.internalRoot());
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{new .colon.colon((Object)this.internalRoot(), (List)Nil$.MODULE$), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(this.ciRepository.listEntities(criteria)).asScala().map((Function1 & Serializable)x$4 -> x$4.getId())}))).asJava();
    }

    private Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>> getDeployedApplicationStates(String deployedAppName, String path, boolean exactPath, List<String> folders, Option<WebhookServer> webhookServer) {
        java.util.List paths = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.deployedApplicationsRepository.find(deployedAppName, path, exactPath).map((Function1 & Serializable)x$5 -> x$5.getId())).asJava();
        Buffer deployedApplications = (Buffer)this.withTempDirectory((Function1 & Serializable)tempDir -> {
            WorkDir workDir = new WorkDir(LocalFile.from((File)tempDir.toFile()));
            return CollectionConverters$.MODULE$.ListHasAsScala($this.ciRepository.read(paths, workDir, 2, true, false, true)).asScala();
        });
        Buffer filteredDeployedApplications = (Buffer)deployedApplications.filter((Function1 & Serializable)deployedApp -> BoxesRunTime.boxToBoolean((boolean)ApplicationStatusServiceImpl.$anonfun$getDeployedApplicationStates$3(this, folders, webhookServer, deployedApp)));
        return this.mapDeployedApplicationsToDeploymentDetails((Buffer<DeployedApplication>)filteredDeployedApplications);
    }

    private List<ApplicationDeploymentPackageState> squashResult(List<Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>>> data, String ordering) {
        return (List)((IterableOnceOps)((IterableOps)data.flatten(Predef$.MODULE$.$conforms())).groupMapReduce((Function1 & Serializable)x$6 -> (Tuple2)x$6._1(), (Function1 & Serializable)x$7 -> (Map)x$7._2(), this.reduceEnvs()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Map details = (Map)tuple2._2();
                if (tuple22 != null) {
                    String appName = (String)tuple22._1();
                    String appUid = (String)tuple22._2();
                    return (scala.collection.immutable.Iterable)details.map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            DeploymentDetails detail = (DeploymentDetails)tuple2._2();
                            if (tuple22 != null) {
                                String envName = (String)tuple22._1();
                                String envUid = (String)tuple22._2();
                                return new ApplicationDeploymentPackageState(appName, appUid, detail.applicationPath(), new DeploymentPackageState(envName, envUid, "", detail.version(), detail.state(), detail.deploymentType(), detail.user(), detail.time()));
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
            throw new MatchError((Object)tuple2);
        })).toList().sortBy((Function1 & Serializable)s -> {
            String string = ordering;
            switch (string == null ? 0 : string.hashCode()) {
                case -1922814509: {
                    if (!"lastChangeTime".equals(string)) break;
                    return Long.toString(s.state().lastChangeTime().getMillis());
                }
                case -1429847026: {
                    if (!"destination".equals(string)) break;
                    return s.state().destination();
                }
                case -1247425541: {
                    if (!"applicationName".equals(string)) break;
                    return s.applicationName();
                }
                case -670508126: {
                    if (!"versionTag".equals(string)) break;
                    return s.state().versionTag();
                }
                case 3599307: {
                    if (!"user".equals(string)) break;
                    return s.state().user();
                }
                case 1753583383: {
                    if (!"deploymentStatus".equals(string)) break;
                    return s.state().deploymentStatus();
                }
            }
            return s.applicationName();
        }, (Ordering)Ordering.String$.MODULE$);
    }

    private Function2<Map<Tuple2<String, String>, DeploymentDetails>, Map<Tuple2<String, String>, DeploymentDetails>, Map<Tuple2<String, String>, DeploymentDetails>> reduceEnvs() {
        return (Function2 & Serializable)(done, ongoing) -> ((IterableOps)new .colon.colon(done, (List)new .colon.colon(ongoing, (List)Nil$.MODULE$)).flatten(Predef$.MODULE$.$conforms())).groupMapReduce((Function1 & Serializable)x$8 -> (Tuple2)x$8._1(), (Function1 & Serializable)x$9 -> (DeploymentDetails)x$9._2(), (Function2 & Serializable)(x$10, o) -> o);
    }

    private Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>> mapDeployedApplicationsToDeploymentDetails(Buffer<DeployedApplication> deployedApplications) {
        return (Map)((IterableOps)deployedApplications.map((Function1 & Serializable)app -> {
            ConfigurationItem application = $this.repositoryResource.read(IdExtensions$.MODULE$.idString(app.getVersion().getId()).getParent());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)app.getName(), (Object)application.get$referenceId())), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)app.getEnvironment().getName(), (Object)app.getEnvironment().get$referenceId())), (Object)new DeploymentDetails(app.getVersion().getVersion(), TaskExecutionState.DONE.toString(), "", app.get$ciAttributes().getLastModifiedBy(), app.get$ciAttributes().getLastModifiedAt(), DeploymentStatusUtils$.MODULE$.getApplicationPathFromVersionId(app.getVersion().getId()))));
        })).groupBy((Function1 & Serializable)x$11 -> (Tuple2)x$11._1()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 appName = (Tuple2)tuple2._1();
                Buffer values = (Buffer)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appName), (Object)((IterableOnceOps)values.map((Function1 & Serializable)x$12 -> (Tuple2)x$12._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean filterByDeploymentAppName(TaskWithBlock task, String deployedAppName) {
        Option option = Option$.MODULE$.apply((Object)deployedAppName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            return DeploymentStatusUtils$.MODULE$.extractMetadata("application", (SerializableTask)task).contains(value);
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    private boolean filterByPathFilter(TaskWithBlock task, String path, boolean exactPath) {
        Option option = Option$.MODULE$.apply((Object)path);
        if (option instanceof Some) {
            boolean bl;
            Some some = (Some)option;
            String value = (String)some.value();
            try {
                String applicationPath = com.xebialabs.deployit.repository.sql.base.package$.MODULE$.idToPath(DeploymentStatusUtils$.MODULE$.getApplicationIdFromVersionId(DeploymentStatusUtils$.MODULE$.extractMetadata("version_id", (SerializableTask)task)));
                String filterPath = com.xebialabs.deployit.repository.sql.base.package$.MODULE$.idToPath(value);
                bl = exactPath ? applicationPath.equals(filterPath) : applicationPath.startsWith(filterPath);
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Exception occurred while filtering by path ", (Function0 & Serializable)() -> e);
                bl = false;
            }
            return bl;
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    private boolean filterByPermissions(TaskWithBlock task) {
        String envDirRef = DeploymentStatusUtils$.MODULE$.extractMetadata("environment_directory_ref", (SerializableTask)task);
        String appDirRef = DeploymentStatusUtils$.MODULE$.extractMetadata("application_directory_ref", (SerializableTask)task);
        return this.hasPermission((List<String>)new .colon.colon((Object)envDirRef, (List)new .colon.colon((Object)appDirRef, (List)Nil$.MODULE$)));
    }

    private boolean isStateDefined(TaskWithBlock task) {
        return Option$.MODULE$.apply((Object)task.getState()).isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isTaskTypeIncluded(TaskWithBlock task) {
        TaskType taskType = TaskType.valueOf((String)DeploymentStatusUtils$.MODULE$.extractMetadata("taskType", (SerializableTask)task));
        TaskType taskType2 = TaskType.CONTROL;
        if (taskType == null) {
            if (taskType2 == null) return false;
        } else if (taskType.equals(taskType2)) return false;
        TaskType taskType3 = TaskType.valueOf((String)DeploymentStatusUtils$.MODULE$.extractMetadata("taskType", (SerializableTask)task));
        TaskType taskType4 = TaskType.DEFAULT;
        if (taskType3 == null) {
            if (taskType4 == null) return false;
        } else if (taskType3.equals(taskType4)) return false;
        TaskType taskType5 = TaskType.valueOf((String)DeploymentStatusUtils$.MODULE$.extractMetadata("taskType", (SerializableTask)task));
        TaskType taskType6 = TaskType.INSPECTION;
        if (taskType5 == null) {
            if (taskType6 == null) return false;
            return true;
        } else if (taskType5.equals(taskType6)) return false;
        return true;
    }

    private boolean filterByWebhookFilter(String applicationId, String environmentId, WebhookServer webhookServer) {
        return this.matchAppEnvToDeploymentRegexp(webhookServer, applicationId, environmentId);
    }

    private Map<Tuple2<String, String>, Map<Tuple2<String, String>, DeploymentDetails>> getTaskStates(String deployedAppName, String path, boolean exactPath, List<String> folders, Option<WebhookServer> webhookServer) {
        Vector allTasks = CollectionConverters$.MODULE$.ListHasAsScala(((TaskExecutionEngine)this.engine.get()).getAllIncompleteTasks(FetchMode.SUMMARY)).asScala().toVector();
        return (Map)((IterableOps)((StrictOptimizedIterableOps)allTasks.filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)ApplicationStatusServiceImpl.$anonfun$getTaskStates$1(this, deployedAppName, path, exactPath, folders, webhookServer, task)))).map((Function1 & Serializable)task -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DeploymentStatusUtils$.MODULE$.extractMetadata("application", (SerializableTask)task), (Object)DeploymentStatusUtils$.MODULE$.extractMetadata("application_reference_id", (SerializableTask)task))), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)DeploymentStatusUtils$.MODULE$.extractMetadata("environment", (SerializableTask)task), (Object)DeploymentStatusUtils$.MODULE$.extractMetadata("environment_reference_id", (SerializableTask)task))), (Object)new DeploymentDetails(DeploymentStatusUtils$.MODULE$.extractMetadata("version", (SerializableTask)task), task.getState().toString(), DeploymentStatusUtils$.MODULE$.extractMetadata("taskType", (SerializableTask)task), task.getOwner(), (DateTime)Option$.MODULE$.apply((Object)task.getStartDate()).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)task.getScheduledDate())).getOrElse((Function0 & Serializable)() -> DateTime.now()), DeploymentStatusUtils$.MODULE$.getApplicationPathFromTaskId(task.getId())))))).groupBy((Function1 & Serializable)x$13 -> (Tuple2)x$13._1()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 appKey = (Tuple2)tuple2._1();
                Vector values = (Vector)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appKey), (Object)((IterableOnceOps)values.map((Function1 & Serializable)x$14 -> (Tuple2)x$14._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean hasPermission(List<String> securedDirectoryReferences) {
        return PermissionHelper.isCurrentUserAdmin() || this.permissionService.checkPermission(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)securedDirectoryReferences.map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)PlatformPermissions.READ, (List)Nil$.MODULE$)).asJava(), Permissions.getAuthentication());
    }

    private boolean filterByFolderFilter(String folderPath, List<String> folders) {
        Some some;
        List value;
        Option option = Option$.MODULE$.apply(folders);
        if (option instanceof Some && (value = (List)(some = (Some)option).value()).nonEmpty()) {
            return folders.exists((Function1 & Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)folderPath.contains(folder)));
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getApplicationStatus$3(String ref$1, WebhookServer x$3) {
        String string = x$3.getWebhookReference();
        String string2 = ref$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getDeployedApplicationStates$3(ApplicationStatusServiceImpl $this, List folders$1, Option webhookServer$1, DeployedApplication deployedApp) {
        return $this.filterByFolderFilter(com.xebialabs.deployit.repository.sql.base.package$.MODULE$.idToPath(DeploymentStatusUtils$.MODULE$.getApplicationDirectoryFromVersionId(deployedApp.getVersion().getId())), (List<String>)folders$1) && webhookServer$1.forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)$this.filterByWebhookFilter(deployedApp.getVersion().getApplication().getId(), deployedApp.getEnvironment().getId(), s)));
    }

    public static final /* synthetic */ boolean $anonfun$getTaskStates$1(ApplicationStatusServiceImpl $this, String deployedAppName$1, String path$1, boolean exactPath$1, List folders$2, Option webhookServer$2, TaskWithBlock task) {
        return $this.isStateDefined(task) && $this.isTaskTypeIncluded(task) && $this.filterByDeploymentAppName(task, deployedAppName$1) && $this.filterByPathFilter(task, path$1, exactPath$1) && $this.filterByFolderFilter(com.xebialabs.deployit.repository.sql.base.package$.MODULE$.idToPath(DeploymentStatusUtils$.MODULE$.getApplicationDirectoryFromVersionId(DeploymentStatusUtils$.MODULE$.extractMetadata("version_id", (SerializableTask)task))), (List<String>)folders$2) && webhookServer$2.forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)$this.filterByWebhookFilter(DeploymentStatusUtils$.MODULE$.getApplicationIdFromVersionId(DeploymentStatusUtils$.MODULE$.extractMetadata("version_id", (SerializableTask)task)), DeploymentStatusUtils$.MODULE$.extractMetadata("environment_id", (SerializableTask)task), s))) && $this.filterByPermissions(task);
    }

    @Autowired
    public ApplicationStatusServiceImpl(DeployedApplicationsRepository deployedApplicationsRepository, CiRepository ciRepository, BeanWrapper<TaskExecutionEngine> engine, PermissionService permissionService, RepositoryResource repositoryResource, RepositoryService repositoryService) {
        this.deployedApplicationsRepository = deployedApplicationsRepository;
        this.ciRepository = ciRepository;
        this.engine = engine;
        this.permissionService = permissionService;
        this.repositoryResource = repositoryResource;
        this.repositoryService = repositoryService;
        RepositoryServiceAware.$init$((RepositoryServiceAware)this);
        ApplicationAndEnvironmentFilter.$init$(this);
        TempDirectorySugar.$init$((TempDirectorySugar)this);
        Logging.$init$((Logging)this);
        this.defaultOrderingField = "applicationName";
        this.defaultOrderingDirection = "ASC";
        this.internalRoot = "Applications";
    }
}

