/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ImmutableIntMap$;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055rA\u0002\r\u001a\u0011\u0003Y\u0012E\u0002\u0004$3!\u00051\u0004\n\u0005\u0006W\u0005!\t!\f\u0005\b]\u0005\u0011\r\u0011\"\u00020\u0011\u001d\t9#\u0001Q\u0001\u000eA2QaI\r\u00037EB\u0001BM\u0003\u0003\u0006\u0004%ia\r\u0005\tu\u0015\u0011\t\u0011)A\u0007i!A1(\u0002BC\u0002\u0013\u0015A\b\u0003\u0005>\u000b\t\u0005\t\u0015!\u00048\u0011\u0015YS\u0001\"\u0003?\u0011\u0015YS\u0001\"\u0004B\u0011\u00191U\u0001)C\u0007\u000f\")\u0011*\u0002C\u0003\u0015\")A*\u0002C\u0003\u001b\")!+\u0002C\u0003'\")\u0011,\u0002C\u00035\"1Q,\u0002Q\u0005\u000eyCaAY\u0003!\n\u001b\u0019\u0007\"\u00025\u0006\t\u000bI\u0007\"B6\u0006\t\u000ba\u0007\"B=\u0006\t\u000bR\bbBA\u0004\u000b\u0011\u0015\u0013\u0011\u0002\u0005\b\u0003\u0017)AQIA\u0007\u0003=IU.\\;uC\ndW-\u00138u\u001b\u0006\u0004(B\u0001\u000e\u001c\u0003\u0011)H/\u001b7\u000b\u0005qi\u0012!\u00029fW.|'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u0004\"AI\u0001\u000e\u0003e\u0011q\"S7nkR\f'\r\\3J]Rl\u0015\r]\n\u0003\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\u0005\nQ!Z7qif,\u0012\u0001\r\t\u0003E\u0015\u0019\"!B\u0013\u0002\u0007-48/F\u00015!\r1SgN\u0005\u0003m\u001d\u0012Q!\u0011:sCf\u0004\"A\n\u001d\n\u0005e:#aA%oi\u0006!1N^:!\u0003\u0011\u0019\u0018N_3\u0016\u0003]\nQa]5{K\u0002\"2\u0001M A\u0011\u0015\u0011$\u00021\u00015\u0011\u0015Y$\u00021\u00018)\r\u0001$\t\u0012\u0005\u0006\u0007.\u0001\raN\u0001\u0004W\u0016L\b\"B#\f\u0001\u00049\u0014!\u0002<bYV,\u0017aC5oI\u0016Dhi\u001c:LKf$\"a\u000e%\t\u000b\rc\u0001\u0019A\u001c\u0002\u0007\u001d,G\u000f\u0006\u00028\u0017\")1)\u0004a\u0001o\u0005A1m\u001c8uC&t7\u000f\u0006\u0002O#B\u0011aeT\u0005\u0003!\u001e\u0012qAQ8pY\u0016\fg\u000eC\u0003D\u001d\u0001\u0007q'\u0001\bva\u0012\fG/Z%g\u0003\n\u001cXM\u001c;\u0015\u0007A\"V\u000bC\u0003D\u001f\u0001\u0007q\u0007\u0003\u0004F\u001f\u0011\u0005\rA\u0016\t\u0004M];\u0014B\u0001-(\u0005!a$-\u001f8b[\u0016t\u0014aB;qI\u0006$X\r\u001a\u000b\u0004amc\u0006\"B\"\u0011\u0001\u00049\u0004\"B#\u0011\u0001\u00049\u0014AB;qI\u0006$X\rF\u00021?\u0002DQ!R\tA\u0002]BQ!Y\tA\u0002]\n!B^1mk\u0016Le\u000eZ3y\u0003\u0019Ign]3siR!\u0001\u0007Z3g\u0011\u0015\u0019%\u00031\u00018\u0011\u0015)%\u00031\u00018\u0011\u00159'\u00031\u00018\u0003\u0015Ig\u000eZ3y\u0003\u0019\u0011X-\\8wKR\u0011\u0001G\u001b\u0005\u0006\u0007N\u0001\raN\u0001\rW\u0016L8/\u0013;fe\u0006$xN]\u000b\u0002[B\u0019aN^\u001c\u000f\u0005=$hB\u00019t\u001b\u0005\t(B\u0001:-\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002vO\u00059\u0001/Y2lC\u001e,\u0017BA<y\u0005!IE/\u001a:bi>\u0014(BA;(\u0003!!xn\u0015;sS:<G#A>\u0011\u0007q\f\tA\u0004\u0002~}B\u0011\u0001oJ\u0005\u0003\u007f\u001e\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u000b\u0011aa\u0015;sS:<'BA@(\u0003!A\u0017m\u001d5D_\u0012,G#A\u001c\u0002\r\u0015\fX/\u00197t)\rq\u0015q\u0002\u0005\b\u0003#9\u0002\u0019AA\n\u0003\ry'M\u001b\t\u0004M\u0005U\u0011bAA\fO\t\u0019\u0011I\\=)\u0007\u0015\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tcG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0013\u0003?\u00111\"\u00138uKJt\u0017\r\\!qS\u00061Q-\u001c9us\u0002B3!AA\u000eQ\r\u0001\u00111\u0004")
@InternalApi
public final class ImmutableIntMap {
    private final int[] kvs;
    private final int size;

    public static ImmutableIntMap empty() {
        return ImmutableIntMap$.MODULE$.empty();
    }

    private final int[] kvs() {
        return this.kvs;
    }

    public final int size() {
        return this.size;
    }

    private final int indexForKey(int key) {
        return this.find$1(0, this.size() - 1, key);
    }

    public final int get(int key) {
        return this.find$2(0, this.size() - 1, key);
    }

    public final boolean contains(int key) {
        return this.indexForKey(key) >= 0;
    }

    public final ImmutableIntMap updateIfAbsent(int key, Function0<Object> value) {
        if (this.size() > 0) {
            int i = this.indexForKey(key);
            if (i >= 0) {
                return this;
            }
            return this.insert(key, value.apply$mcI$sp(), i);
        }
        return new ImmutableIntMap(key, value.apply$mcI$sp());
    }

    public final ImmutableIntMap updated(int key, int value) {
        if (this.size() > 0) {
            int i = this.indexForKey(key);
            if (i >= 0) {
                int valueIndex = i + 1;
                if (this.kvs()[valueIndex] != value) {
                    return this.update(value, valueIndex);
                }
                return this;
            }
            return this.insert(key, value, i);
        }
        return new ImmutableIntMap(key, value);
    }

    private final ImmutableIntMap update(int value, int valueIndex) {
        int[] newKvs = (int[])this.kvs().clone();
        newKvs[valueIndex] = value;
        return new ImmutableIntMap(newKvs, this.size());
    }

    private final ImmutableIntMap insert(int key, int value, int index) {
        int at = ~index;
        int[] newKvs = new int[this.kvs().length + 2];
        System.arraycopy(this.kvs(), 0, newKvs, 0, at);
        newKvs[at] = key;
        newKvs[at + 1] = value;
        System.arraycopy(this.kvs(), at, newKvs, at + 2, this.kvs().length - at);
        return new ImmutableIntMap(newKvs, this.size() + 1);
    }

    public final ImmutableIntMap remove(int key) {
        int i = this.indexForKey(key);
        if (i >= 0) {
            if (this.size() > 1) {
                int newSz = this.kvs().length - 2;
                int[] newKvs = new int[newSz];
                System.arraycopy(this.kvs(), 0, newKvs, 0, i);
                System.arraycopy(this.kvs(), i + 2, newKvs, i, newSz - i);
                return new ImmutableIntMap(newKvs, this.size() - 1);
            }
            return ImmutableIntMap$.MODULE$.empty();
        }
        return this;
    }

    public final Iterator<Object> keysIterator() {
        if (this.size() < 1) {
            return package$.MODULE$.Iterator().empty();
        }
        return package$.MODULE$.Iterator().range(0, this.kvs().length - 1, 2).map((Function1)(JFunction1.mcII.sp & Serializable)i -> this.kvs()[i]);
    }

    public final String toString() {
        if (this.size() < 1) {
            return "ImmutableIntMap()";
        }
        return package$.MODULE$.Iterator().range(0, this.kvs().length - 1, 2).map((Function1 & Serializable)i -> ImmutableIntMap.$anonfun$toString$1(this, BoxesRunTime.unboxToInt((Object)i))).mkString("ImmutableIntMap(", ", ", ")");
    }

    public final int hashCode() {
        return Arrays.hashCode(this.kvs());
    }

    public final boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ImmutableIntMap) {
            ImmutableIntMap immutableIntMap = (ImmutableIntMap)object;
            return Arrays.equals(this.kvs(), immutableIntMap.kvs());
        }
        return false;
    }

    private final int find$1(int lo, int hi, int key$1) {
        while (lo <= hi) {
            int lohi = lo + hi;
            int idx = lohi & 0xFFFFFFFE;
            int k = this.kvs()[idx];
            if (k == key$1) {
                return idx;
            }
            if (k < key$1) {
                lo = (lohi >>> 1) + 1;
                continue;
            }
            hi = (lohi >>> 1) - 1;
        }
        return ~(lo << 1);
    }

    private final int find$2(int lo, int hi, int key$2) {
        while (lo <= hi) {
            int lohi = lo + hi;
            int k = this.kvs()[lohi & 0xFFFFFFFE];
            if (k == key$2) {
                return this.kvs()[lohi | 1];
            }
            if (k < key$2) {
                lo = (lohi >>> 1) + 1;
                continue;
            }
            hi = (lohi >>> 1) - 1;
        }
        return Integer.MIN_VALUE;
    }

    public static final /* synthetic */ String $anonfun$toString$1(ImmutableIntMap $this, int i) {
        return new StringBuilder(4).append($this.kvs()[i]).append(" -> ").append($this.kvs()[i + 1]).toString();
    }

    public ImmutableIntMap(int[] kvs, int size) {
        this.kvs = kvs;
        this.size = size;
    }

    private ImmutableIntMap(int key, int value) {
        this(new int[2], 1);
        this.kvs()[0] = key;
        this.kvs()[1] = value;
    }
}

