/*
 * Decompiled with CFR 0.152.
 */
package io.altoo.serialization.kryo.scala;

import io.altoo.serialization.kryo.scala.Transformer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005u2AAB\u0004\u0001%!)A\u0004\u0001C\u0001;!)q\u0004\u0001C!A!)q\u0004\u0001C!S!)\u0001\b\u0001C!s!)\u0001\b\u0001C!w\t\t\",\u001b9Lef|7i\\7qe\u0016\u001c8o\u001c:\u000b\u0005!I\u0011!B:dC2\f'B\u0001\u0006\f\u0003\u0011Y'/_8\u000b\u00051i\u0011!D:fe&\fG.\u001b>bi&|gN\u0003\u0002\u000f\u001f\u0005)\u0011\r\u001c;p_*\t\u0001#\u0001\u0002j_\u000e\u00011c\u0001\u0001\u00141A\u0011ACF\u0007\u0002+)\t\u0001\"\u0003\u0002\u0018+\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003\u001dI!aG\u0004\u0003\u0017Q\u0013\u0018M\\:g_JlWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"!\u0007\u0001\u0002\u0011Q|')\u001b8bef$\"!I\u0014\u0011\u0007Q\u0011C%\u0003\u0002$+\t)\u0011I\u001d:bsB\u0011A#J\u0005\u0003MU\u0011AAQ=uK\")\u0001F\u0001a\u0001C\u0005I\u0011N\u001c9vi\n+hM\u001a\u000b\u0004U5r\u0003C\u0001\u000b,\u0013\taSC\u0001\u0003V]&$\b\"\u0002\u0015\u0004\u0001\u0004\t\u0003\"B\u0018\u0004\u0001\u0004\u0001\u0014AC8viB,HOQ;gMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0004]&|'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oI\u0012!BQ=uK\n+hMZ3s\u0003)1'o\\7CS:\f'/\u001f\u000b\u0003CiBQ\u0001\u000b\u0003A\u0002\u0005\"\"!\t\u001f\t\u000b!*\u0001\u0019\u0001\u0019")
public class ZipKryoCompressor
implements Transformer {
    @Override
    public byte[] toBinary(byte[] inputBuff) {
        Deflater deflater = new Deflater(1);
        int inputSize = inputBuff.length;
        ArrayBuilder.ofByte outputBuff = new ArrayBuilder.ofByte();
        outputBuff.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(inputSize & 0xFF))));
        outputBuff.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(inputSize >> 8 & 0xFF))));
        outputBuff.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(inputSize >> 16 & 0xFF))));
        outputBuff.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(inputSize >> 24 & 0xFF))));
        deflater.setInput(inputBuff);
        deflater.finish();
        byte[] buff = new byte[4096];
        while (!deflater.finished()) {
            int n = deflater.deflate(buff);
            outputBuff.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(buff), n)));
        }
        deflater.end();
        return outputBuff.result();
    }

    @Override
    public void toBinary(byte[] inputBuff, ByteBuffer outputBuff) {
        Deflater deflater = new Deflater(1);
        int inputSize = inputBuff.length;
        outputBuff.order(ByteOrder.LITTLE_ENDIAN).putInt(inputSize);
        deflater.setInput(inputBuff);
        deflater.finish();
        deflater.deflate(outputBuff);
        deflater.end();
    }

    @Override
    public byte[] fromBinary(byte[] inputBuff) {
        return this.fromBinary(ByteBuffer.wrap(inputBuff));
    }

    @Override
    public byte[] fromBinary(ByteBuffer inputBuff) {
        Inflater inflater = new Inflater();
        byte[] outputBuff = new byte[inputBuff.order(ByteOrder.LITTLE_ENDIAN).getInt()];
        inflater.setInput(inputBuff);
        inflater.inflate(ByteBuffer.wrap(outputBuff));
        inflater.end();
        return outputBuff;
    }

    public ZipKryoCompressor() {
        Transformer.$init$(this);
    }
}

