/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.StackType;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Server side STOPM protocol, STOMP clients can connect to it")
public class STOMP
extends Protocol
implements Runnable {
    @Property(name="bind_addr", description="The bind address which should be used by the server socket. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", defaultValueIPv4="0.0.0.0", defaultValueIPv6="::", writable=false)
    protected InetAddress bind_addr;
    @Property(description="If set, then endpoint will be set to this address")
    protected String endpoint_addr;
    @Property(description="Port on which the STOMP protocol listens for requests", writable=false)
    protected int port = 8787;
    @Property(description="If set to false, then a destination of /a/b match /a/b/c, a/b/d, a/b/c/d etc")
    protected boolean exact_destination_match = true;
    @Property(description="If true, information such as a list of endpoints, or views, will be sent to all clients (via the INFO command). This allows for example intelligent clients to connect to a different server should a connection be closed.")
    protected boolean send_info = true;
    @Property(description="Forward received messages which don't have a StompHeader to clients")
    protected boolean forward_non_client_generated_msgs = false;
    protected ServerSocket srv_sock;
    @ManagedAttribute
    protected String endpoint;
    protected Thread acceptor;
    protected final List<Connection> connections = new LinkedList<Connection>();
    protected final Map<Address, String> endpoints = new HashMap<Address, String>();
    protected View view;
    protected final ConcurrentMap<String, Set<Connection>> subscriptions = Util.createConcurrentMap(20);
    public static final byte NULL_BYTE = 0;

    @ManagedAttribute(description="Number of client connections")
    public int getNumConnections() {
        return this.connections.size();
    }

    @ManagedAttribute(description="Number of subscriptions")
    public int getNumSubscriptions() {
        return this.subscriptions.size();
    }

    @ManagedAttribute(description="Print subscriptions")
    public String getSubscriptions() {
        return this.subscriptions.keySet().toString();
    }

    @ManagedAttribute
    public String getEndpoints() {
        return this.endpoints.toString();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.srv_sock = Util.createServerSocket(this.getSocketFactory(), "jgroups.stomp.srv_sock", this.bind_addr, this.port, this.port + 50, 0);
        if (this.log.isDebugEnabled()) {
            this.log.debug("server socket listening on " + String.valueOf(this.srv_sock.getLocalSocketAddress()));
        }
        if (this.acceptor == null) {
            this.acceptor = this.getThreadFactory().newThread(this, "STOMP acceptor");
            this.acceptor.setDaemon(true);
            this.acceptor.start();
        }
        this.endpoint = this.endpoint_addr != null ? this.endpoint_addr : this.getAddress(Util.getIpStackType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("closing server socket " + String.valueOf(this.srv_sock.getLocalSocketAddress()));
        }
        if (this.acceptor != null && this.acceptor.isAlive()) {
            try {
                this.getSocketFactory().close(this.srv_sock);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.forEach(Connection::stop);
            this.connections.clear();
        }
        this.acceptor = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.acceptor != null && this.srv_sock != null) {
            try {
                Socket client_sock = this.srv_sock.accept();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("accepted connection from " + String.valueOf(client_sock.getInetAddress()) + ":" + client_sock.getPort());
                }
                Connection conn = new Connection(client_sock);
                Thread thread = this.getThreadFactory().newThread(conn, "STOMP client connection");
                thread.setDaemon(true);
                List<Connection> list = this.connections;
                synchronized (list) {
                    this.connections.add(conn);
                }
                thread.start();
                conn.sendInfo();
            }
            catch (IOException io_ex) {
                // empty catch block
                break;
            }
        }
        this.acceptor = null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        StompHeader hdr = (StompHeader)msg.getHeader(this.id);
        if (hdr == null) {
            if (this.forward_non_client_generated_msgs) {
                HashMap<String, String> hdrs = new HashMap<String, String>();
                hdrs.put("sender", msg.getSrc().toString());
                this.sendToClients(hdrs, msg.getArray(), msg.getOffset(), msg.getLength());
            }
            return this.up_prot.up(msg);
        }
        switch (hdr.type.ordinal()) {
            case 0: {
                this.sendToClients(hdr.headers, msg.getArray(), msg.getOffset(), msg.getLength());
                break;
            }
            case 1: {
                String tmp_endpoint = hdr.headers.get("endpoint");
                if (tmp_endpoint != null) {
                    boolean update_clients;
                    Object old_endpoint = null;
                    Object object = this.endpoints;
                    synchronized (object) {
                        this.endpoints.put(msg.getSrc(), tmp_endpoint);
                    }
                    boolean bl = update_clients = !Objects.equals(old_endpoint, tmp_endpoint);
                    if (update_clients && this.send_info) {
                        object = this.connections;
                        synchronized (object) {
                            for (Connection conn : this.connections) {
                                conn.writeResponse(ServerVerb.INFO, "endpoints", this.getAllEndpoints());
                            }
                        }
                    }
                }
                return null;
            }
            default: {
                throw new IllegalArgumentException("type " + String.valueOf((Object)hdr.type) + " is not known");
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            StompHeader hdr = (StompHeader)msg.getHeader(this.id);
            if (hdr == null && !this.forward_non_client_generated_msgs) continue;
            try {
                it.remove();
                this.up(msg);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedPassingUpMessage"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    public static Frame readFrame(DataInputStream in) throws IOException {
        String verb = Util.readLine(in);
        if (verb == null) {
            throw new EOFException("reading verb");
        }
        if (verb.isEmpty()) {
            return null;
        }
        verb = verb.trim();
        HashMap<String, String> headers = new HashMap<String, String>();
        byte[] body = null;
        while (true) {
            String header;
            if ((header = Util.readLine(in)) == null) {
                throw new EOFException("reading header");
            }
            if (header.isEmpty()) break;
            int index = header.indexOf(58);
            if (index == -1) continue;
            headers.put(header.substring(0, index).trim(), header.substring(index + 1).trim());
        }
        if (headers.containsKey("content-length")) {
            int length = Integer.parseInt((String)headers.get("content-length"));
            body = new byte[length];
            in.read(body, 0, body.length);
        } else {
            ByteBuffer buf = ByteBuffer.allocate(500);
            boolean terminate = false;
            while (true) {
                int c;
                if ((c = in.read()) == -1 || c == 0) {
                    terminate = true;
                }
                if (buf.remaining() == 0 || terminate) {
                    if (body == null) {
                        body = new byte[buf.position()];
                        System.arraycopy(buf.array(), buf.arrayOffset(), body, 0, buf.position());
                    } else {
                        byte[] tmp = new byte[body.length + buf.position()];
                        System.arraycopy(body, 0, tmp, 0, body.length);
                        try {
                            System.arraycopy(buf.array(), buf.arrayOffset(), tmp, body.length, buf.position());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        body = tmp;
                    }
                    buf.rewind();
                }
                if (terminate) break;
                buf.put((byte)c);
            }
        }
        return new Frame(verb, headers, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleView(View view) {
        this.broadcastEndpoint();
        List<Address> mbrs = view.getMembers();
        this.view = view;
        Object object = this.endpoints;
        synchronized (object) {
            this.endpoints.keySet().retainAll(mbrs);
        }
        object = this.connections;
        synchronized (object) {
            this.connections.forEach(Connection::sendInfo);
        }
    }

    private String getAddress(StackType ip_version) {
        InetSocketAddress saddr = (InetSocketAddress)this.srv_sock.getLocalSocketAddress();
        InetAddress tmp = saddr.getAddress();
        if (!tmp.isAnyLocalAddress()) {
            return tmp.getHostAddress() + ":" + this.srv_sock.getLocalPort();
        }
        for (Util.AddressScope scope : Util.AddressScope.values()) {
            try {
                InetAddress addr = Util.getAddress(scope, ip_version);
                if (addr == null) continue;
                return addr.getHostAddress() + ":" + this.srv_sock.getLocalPort();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAllEndpoints() {
        Map<Address, String> map = this.endpoints;
        synchronized (map) {
            return Util.printListWithDelimiter(this.endpoints.values(), ",");
        }
    }

    protected void broadcastEndpoint() {
        if (this.endpoint != null) {
            Message msg = new EmptyMessage().putHeader(this.id, StompHeader.createHeader(StompHeader.Type.ENDPOINT, "endpoint", this.endpoint));
            this.down_prot.down(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToClients(Map<String, String> headers, byte[] buffer, int offset, int length) {
        String destination;
        int len = 50 + length + (ServerVerb.MESSAGE.name().length() + 2);
        if (headers != null) {
            for (Map.Entry<String, String> entry2 : headers.entrySet()) {
                len += entry2.getKey().length() + 2;
                len += entry2.getValue().length() + 2;
                len += 5;
            }
        }
        ByteBuffer buf = ByteBuffer.allocate(len += buffer != null ? 20 : 0);
        StringBuilder sb = new StringBuilder(ServerVerb.MESSAGE.name()).append("\n");
        if (headers != null) {
            for (Map.Entry<String, String> entry3 : headers.entrySet()) {
                sb.append(entry3.getKey()).append(": ").append(entry3.getValue()).append("\n");
            }
        }
        if (buffer != null) {
            sb.append("content-length: ").append(length).append("\n");
        }
        sb.append("\n");
        byte[] tmp = sb.toString().getBytes();
        if (buffer != null) {
            buf.put(tmp, 0, tmp.length);
            buf.put(buffer, offset, length);
        }
        buf.put((byte)0);
        HashSet<Connection> target_connections = new HashSet<Connection>();
        String string = destination = headers != null ? headers.get("destination") : null;
        if (destination == null) {
            List<Connection> list = this.connections;
            synchronized (list) {
                target_connections.addAll(this.connections);
            }
        } else if (!this.exact_destination_match) {
            this.subscriptions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(destination)).forEach(entry -> target_connections.addAll((Collection)entry.getValue()));
        } else {
            Set conns = (Set)this.subscriptions.get(destination);
            if (conns != null) {
                target_connections.addAll(conns);
            }
        }
        for (Connection conn : target_connections) {
            conn.writeResponse(buf.array(), buf.arrayOffset(), buf.position());
        }
    }

    public class Connection
    implements Runnable {
        protected final Socket sock;
        protected final DataInputStream in;
        protected final DataOutputStream out;
        protected final UUID session_id = UUID.randomUUID();

        public Connection(Socket sock) throws IOException {
            this.sock = sock;
            this.in = new DataInputStream(sock.getInputStream());
            this.out = new DataOutputStream(sock.getOutputStream());
        }

        public void stop() {
            if (STOMP.this.log.isTraceEnabled()) {
                STOMP.this.log.trace("closing connection to " + String.valueOf(this.sock.getRemoteSocketAddress()));
            }
            Util.close((Closeable)this.in);
            Util.close((Closeable)this.out);
            Util.close((Closeable)this.sock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove() {
            List<Connection> list = STOMP.this.connections;
            synchronized (list) {
                STOMP.this.connections.remove(this);
            }
            for (Set conns : STOMP.this.subscriptions.values()) {
                conns.remove(this);
            }
            STOMP.this.subscriptions.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
        }

        @Override
        public void run() {
            while (!this.sock.isClosed()) {
                try {
                    Frame frame = STOMP.readFrame(this.in);
                    if (frame == null) continue;
                    if (STOMP.this.log.isTraceEnabled()) {
                        STOMP.this.log.trace(frame);
                    }
                    this.handleFrame(frame);
                }
                catch (IOException ex) {
                    this.stop();
                    this.remove();
                }
                catch (Throwable t) {
                    STOMP.this.log.error(Util.getMessage("FailureReadingFrame"), t);
                }
            }
        }

        protected void handleFrame(Frame frame) {
            Map<String, String> headers = frame.getHeaders();
            ClientVerb verb = ClientVerb.valueOf(frame.getVerb());
            switch (verb.ordinal()) {
                case 0: {
                    this.writeResponse(ServerVerb.CONNECTED, "session-id", this.session_id.toString(), "password-check", "none");
                    break;
                }
                case 1: {
                    if (!headers.containsKey("sender")) {
                        headers.put("sender", this.session_id.toString());
                    }
                    BytesMessage msg = new BytesMessage(null, frame.getBody());
                    StompHeader hdr = StompHeader.createHeader(StompHeader.Type.MESSAGE, headers);
                    msg.putHeader(STOMP.this.id, hdr);
                    STOMP.this.down_prot.down(msg);
                    String receipt = headers.get("receipt");
                    if (receipt == null) break;
                    this.writeResponse(ServerVerb.RECEIPT, "receipt-id", receipt);
                    break;
                }
                case 2: {
                    Set tmp;
                    String destination = headers.get("destination");
                    if (destination == null) break;
                    Set<Connection> conns = (HashSet<Connection>)STOMP.this.subscriptions.get(destination);
                    if (conns == null && (tmp = (Set)STOMP.this.subscriptions.putIfAbsent(destination, conns = new HashSet<Connection>())) != null) {
                        conns = tmp;
                    }
                    conns.add(this);
                    break;
                }
                case 3: {
                    Set conns;
                    String destination = headers.get("destination");
                    if (destination == null || (conns = (Set)STOMP.this.subscriptions.get(destination)) == null || !conns.remove(this) || !conns.isEmpty()) break;
                    STOMP.this.subscriptions.remove(destination);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    STOMP.this.log.error("Verb " + frame.getVerb() + " is not handled");
                }
            }
        }

        public void sendInfo() {
            if (STOMP.this.send_info) {
                this.writeResponse(ServerVerb.INFO, "local_addr", STOMP.this.local_addr != null ? STOMP.this.local_addr.toString() : "n/a", "view", STOMP.this.view.toString(), "endpoints", STOMP.this.getAllEndpoints());
            }
        }

        private void writeResponse(ServerVerb response, String ... keys_and_values) {
            String tmp = response.name();
            try {
                this.out.write(tmp.getBytes());
                this.out.write(10);
                for (int i = 0; i < keys_and_values.length; ++i) {
                    String key = keys_and_values[i];
                    String val = keys_and_values[++i];
                    this.out.write((key + ": " + val + "\n").getBytes());
                }
                this.out.write("\n".getBytes());
                this.out.write(0);
                this.out.flush();
            }
            catch (IOException ex) {
                STOMP.this.log.error(Util.getMessage("FailedWritingResponse") + String.valueOf((Object)response) + ": " + String.valueOf(ex));
            }
        }

        private void writeResponse(byte[] response, int offset, int length) {
            try {
                this.out.write(response, offset, length);
                this.out.flush();
            }
            catch (IOException ex) {
                STOMP.this.log.error(Util.getMessage("FailedWritingResponse") + String.valueOf(ex));
            }
        }
    }

    public static class StompHeader
    extends Header {
        protected Type type;
        protected final Map<String, String> headers = new HashMap<String, String>();

        public StompHeader() {
        }

        @Override
        public Supplier<? extends Header> create() {
            return StompHeader::new;
        }

        @Override
        public short getMagicId() {
            return 71;
        }

        private StompHeader(Type type) {
            this.type = type;
        }

        public static StompHeader createHeader(Type type, String ... headers) {
            StompHeader retval = new StompHeader(type);
            if (headers != null) {
                for (int i = 0; i < headers.length; ++i) {
                    String key = headers[i];
                    String value = headers[++i];
                    retval.headers.put(key, value);
                }
            }
            return retval;
        }

        public static StompHeader createHeader(Type type, Map<String, String> headers) {
            StompHeader retval = new StompHeader(type);
            if (headers != null) {
                retval.headers.putAll(headers);
            }
            return retval;
        }

        @Override
        public int serializedSize() {
            int retval = 8;
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                retval += entry.getKey().length() + 2;
                retval += entry.getValue().length() + 2;
            }
            return retval;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeInt(this.type.ordinal());
            out.writeInt(this.headers.size());
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.type = Type.values()[in.readInt()];
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                this.headers.put(key, value);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.type.toString());
            sb.append("headers: ").append(this.headers);
            return sb.toString();
        }

        public static enum Type {
            MESSAGE,
            ENDPOINT;

        }
    }

    public static enum ServerVerb {
        MESSAGE,
        RECEIPT,
        ERROR,
        CONNECTED,
        INFO;

    }

    public static class Frame {
        final String verb;
        final Map<String, String> headers;
        final byte[] body;

        public Frame(String verb, Map<String, String> headers, byte[] body) {
            this.verb = verb;
            this.headers = headers;
            this.body = body;
        }

        public byte[] getBody() {
            return this.body;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getVerb() {
            return this.verb;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.verb).append("\n");
            if (this.headers != null && !this.headers.isEmpty()) {
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
            }
            if (this.body != null && this.body.length > 0) {
                sb.append("body: ");
                if (this.body.length < 50) {
                    sb.append(new String(this.body)).append(" (").append(this.body.length).append(" bytes)");
                } else {
                    sb.append(this.body.length).append(" bytes");
                }
            }
            return sb.toString();
        }
    }

    public static enum ClientVerb {
        CONNECT,
        SEND,
        SUBSCRIBE,
        UNSUBSCRIBE,
        BEGIN,
        COMMIT,
        ABORT,
        ACK,
        DISCONNECT;

    }
}

