/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class InMemoryTimeLimiterRegistry
extends AbstractRegistry<TimeLimiter, TimeLimiterConfig>
implements TimeLimiterRegistry {
    public InMemoryTimeLimiterRegistry() {
        this(TimeLimiterConfig.ofDefaults(), Collections.emptyMap());
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, Map<String, String> tags) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, RegistryEventConsumer<TimeLimiter> registryEventConsumer) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, RegistryEventConsumer<TimeLimiter> registryEventConsumer, Map<String, String> tags) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(Map<String, TimeLimiterConfig> configs, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers, Map<String, String> tags) {
        this(configs.getOrDefault("default", TimeLimiterConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, Map<String, String> tags) {
        super((Object)defaultConfig, tags);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, RegistryEventConsumer<TimeLimiter> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, RegistryEventConsumer<TimeLimiter> registryEventConsumer, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    public InMemoryTimeLimiterRegistry(TimeLimiterConfig defaultConfig, List<RegistryEventConsumer<TimeLimiter>> registryEventConsumers, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumers, tags);
    }

    @Override
    public Set<TimeLimiter> getAllTimeLimiters() {
        return new HashSet<TimeLimiter>(this.entryMap.values());
    }

    @Override
    public TimeLimiter timeLimiter(String name) {
        return this.timeLimiter(name, (TimeLimiterConfig)this.getDefaultConfig(), Collections.emptyMap());
    }

    @Override
    public TimeLimiter timeLimiter(String name, Map<String, String> tags) {
        return this.timeLimiter(name, (TimeLimiterConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public TimeLimiter timeLimiter(String name, TimeLimiterConfig config) {
        return this.timeLimiter(name, config, Collections.emptyMap());
    }

    @Override
    public TimeLimiter timeLimiter(String name, TimeLimiterConfig timeLimiterConfig, Map<String, String> tags) {
        return (TimeLimiter)this.computeIfAbsent(name, () -> TimeLimiter.of(name, Objects.requireNonNull(timeLimiterConfig, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public TimeLimiter timeLimiter(String name, Supplier<TimeLimiterConfig> timeLimiterConfigSupplier) {
        return this.timeLimiter(name, timeLimiterConfigSupplier, Collections.emptyMap());
    }

    @Override
    public TimeLimiter timeLimiter(String name, Supplier<TimeLimiterConfig> timeLimiterConfigSupplier, Map<String, String> tags) {
        return (TimeLimiter)this.computeIfAbsent(name, () -> TimeLimiter.of(name, Objects.requireNonNull((TimeLimiterConfig)Objects.requireNonNull(timeLimiterConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public TimeLimiter timeLimiter(String name, String configName) {
        return this.timeLimiter(name, configName, Collections.emptyMap());
    }

    @Override
    public TimeLimiter timeLimiter(String name, String configName, Map<String, String> tags) {
        TimeLimiterConfig config = (TimeLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName));
        return this.timeLimiter(name, config, tags);
    }
}

