/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import io.reactivex.rxjava3.core.Flowable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.notifications.cachelistener.EventWrapper;
import org.infinispan.notifications.cachelistener.QueueingSegmentListener;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.impl.SegmentPublisherSupplier;
import org.infinispan.util.logging.Log;
import org.reactivestreams.Publisher;

abstract class BaseQueueingSegmentListener<K, V, E extends Event<K, V>>
implements QueueingSegmentListener<K, V, E> {
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected final AtomicReferenceArray<ConcurrentMap<K, Object>> notifiedKeys;
    protected final KeyPartitioner keyPartitioner;

    protected BaseQueueingSegmentListener(int numSegments, KeyPartitioner keyPartitioner) {
        this.notifiedKeys = new AtomicReferenceArray(numSegments);
        this.keyPartitioner = keyPartitioner;
        for (int i = 0; i < numSegments; ++i) {
            this.notifiedKeys.set(i, new ConcurrentHashMap());
        }
    }

    int segmentFromEventWrapper(EventWrapper<K, V, E> eventWrapper) {
        return SegmentSpecificCommand.extractSegment(eventWrapper.getCommand(), eventWrapper.getKey(), this.keyPartitioner);
    }

    @Override
    public Publisher<CacheEntry<K, V>> apply(SegmentPublisherSupplier.Notification<CacheEntry<K, V>> cacheEntryNotification) throws Throwable {
        if (cacheEntryNotification.isSegmentComplete()) {
            return this.segmentComplete(cacheEntryNotification.completedSegment());
        }
        int segment = cacheEntryNotification.valueSegment();
        CacheEntry<K, V> cacheEntry = cacheEntryNotification.value();
        K key = cacheEntry.getKey();
        Object value = this.notifiedKeys.get(segment).put(key, NOTIFIED);
        if (value == null) {
            return Flowable.just(cacheEntry);
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Processing key %s as a concurrent update occurred with value %s", key, value);
        }
        return value != QueueingSegmentListener.REMOVED ? Flowable.just((Object)((CacheEntry)value)) : Flowable.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Flowable<CacheEntry<K, V>> segmentComplete(int segment) {
        ConcurrentMap map;
        ConcurrentMap concurrentMap = map = this.notifiedKeys.get(segment);
        synchronized (concurrentMap) {
            this.notifiedKeys.set(segment, null);
        }
        return Flowable.fromIterable(map.entrySet()).filter(e -> map.remove(e.getKey()) != null).map(RxJavaInterop.entryToValueFunction()).filter(v -> v != NOTIFIED && v != REMOVED).map(v -> (CacheEntry)v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addEvent(K key, int segment, Object value) {
        ConcurrentMap<Object, Object> map = this.notifiedKeys.get(segment);
        if (map == null) {
            return false;
        }
        ConcurrentMap<Object, Object> concurrentMap = map;
        synchronized (concurrentMap) {
            if (this.notifiedKeys.get(segment) == map) {
                return map.compute(key, (k, v) -> v == NOTIFIED ? v : value) == value;
            }
        }
        return false;
    }

    protected abstract Log getLog();
}

