/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.ArrayList;

public class ListStack<T>
extends ArrayList<T> {
    protected int pointer = 0;

    public ListStack() {
    }

    public ListStack(ArrayList<T> list) {
        super(list);
    }

    @Override
    public ListStack<T> clone() {
        ListStack<T> newstack = new ListStack<T>(this);
        newstack.pointer = this.pointer;
        return newstack;
    }

    public T push(T item) {
        this.add(item);
        ++this.pointer;
        return item;
    }

    public T pop() {
        --this.pointer;
        Object o = this.get(this.pointer);
        this.remove(this.pointer);
        return (T)o;
    }

    public T pop(int count) {
        T o = null;
        for (int i = count; i > 0; --i) {
            o = this.pop();
        }
        return o;
    }

    public void remove() {
        --this.pointer;
        this.remove(this.pointer);
    }

    public void removeMultiple(int count) {
        while (count > 0) {
            --this.pointer;
            this.remove(this.pointer);
            --count;
        }
    }

    public boolean empty() {
        return this.pointer == 0;
    }

    public int getPointer() {
        return this.pointer;
    }

    public T getByOffset(int offset) {
        return (T)this.get(this.pointer + offset);
    }

    public void insertByOffset(int offset, T item) {
        this.add(this.pointer + offset, item);
        ++this.pointer;
    }

    @Override
    public void clear() {
        super.clear();
        this.pointer = 0;
    }
}

