/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization.jackson;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.impl.SubTypeValidator;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.jackson.Compression;
import org.apache.pekko.serialization.jackson.Compression$Off$;
import org.apache.pekko.serialization.jackson.JacksonMigration;
import org.apache.pekko.serialization.jackson.JacksonObjectMapperProvider$;
import org.apache.pekko.serialization.jackson.JacksonSerializer$;
import org.apache.pekko.serialization.jackson.JacksonSerializer$LZ4Meta$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0011%vAB3g\u0011\u0003Q\u0007O\u0002\u0004sM\"\u0005!n\u001d\u0005\u0006u\u0006!\t\u0001 \u0004\u0005{\u0006\u0001a\u0010\u0003\u0004{\u0007\u0011\u0005\u0011Q\u0004\u0005\b\u0003G\u0019A\u0011BA\u0013\u0011%\tie\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002R\r\u0001\u000b\u0011BA\u001c\u0011%\t\u0019f\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002V\r\u0001\u000b\u0011BA\u001c\u0011\u001d\t9f\u0001C\u0001\u00033Bq!!\u001a\u0004\t\u0003\t9\u0007C\u0004\u0002\f\u000e!I!!$\t\u0013\u0005%\u0016A1A\u0005\u0002\u0005-\u0006\u0002CA^\u0003\u0001\u0006I!!,\t\u000f\u0005u\u0016\u0001\"\u0001\u0002@\u001a1\u0011\u0011[\u0001C\u0003'D!\"!<\u0011\u0005+\u0007I\u0011AAx\u0011)\t9\u0010\u0005B\tB\u0003%\u0011\u0011\u001f\u0005\u000b\u0003s\u0004\"Q3A\u0005\u0002\u0005=\bBCA~!\tE\t\u0015!\u0003\u0002r\"1!\u0010\u0005C\u0001\u0003{DqA!\u0002\u0011\t\u0003\u00119\u0001C\u0004\u0003 A!\tA!\t\t\u0013\t\u0015\u0002#!A\u0005\u0002\t\u001d\u0002\"\u0003B\u0017!E\u0005I\u0011\u0001B\u0018\u0011%\u0011\t\u0005EI\u0001\n\u0003\u0011y\u0003C\u0005\u0003DA\t\t\u0011\"\u0011\u0003F!I!\u0011\u000b\t\u0002\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0005'\u0002\u0012\u0011!C\u0001\u0005+B\u0011Ba\u0017\u0011\u0003\u0003%\tE!\u0018\t\u0013\t-\u0004#!A\u0005\u0002\t5\u0004\"\u0003B9!\u0005\u0005I\u0011\tB:\u0011%\u00119\bEA\u0001\n\u0003\u0012I\bC\u0005\u0003|A\t\t\u0011\"\u0011\u0003~!I!q\u0010\t\u0002\u0002\u0013\u0005#\u0011Q\u0004\b\u0005\u000b\u000b\u0001\u0012\u0001BD\r\u001d\t\t.\u0001E\u0001\u0005\u0013CaA_\u0013\u0005\u0002\tU\u0005\"\u0003BLK\t\u0007I\u0011AAx\u0011!\u0011I*\nQ\u0001\n\u0005E\bb\u0002BNK\u0011\u0005!Q\u0014\u0005\b\u0005C+C\u0011\u0001BR\u0011\u001d\u0011\t+\nC\u0001\u0005cC\u0011Ba'&\u0003\u0003%\tI!.\t\u0013\tmV%!A\u0005\u0002\nu\u0006\"\u0003BhK\u0005\u0005I\u0011\u0002Bi\u0011\u001d\u0011I.\u0001C\u0001\u000574qA\u001d4\u0002\u0002)\u0014i\u000f\u0003\u0006\u0003xB\u0012)\u0019!C\u0001\u0005sD!ba\u00021\u0005\u0003\u0005\u000b\u0011\u0002B~\u0011)\u0019I\u0001\rBC\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0007\u0017\u0001$\u0011!Q\u0001\n\u0005]\u0002BCB\u0007a\t\u0015\r\u0011\"\u0001\u0004\u0010!Q1\u0011\u0004\u0019\u0003\u0002\u0003\u0006Ia!\u0005\t\ri\u0004D\u0011AB\u000e\u0011%\u0019)\u0003\rb\u0001\n\u0013\u00199\u0003\u0003\u0005\u00046A\u0002\u000b\u0011BB\u0015\u0011%\u00199\u0004\rb\u0001\n\u0013\u0019I\u0004\u0003\u0005\u0004LA\u0002\u000b\u0011BB\u001e\u0011%\u0019i\u0005\rb\u0001\n\u0013\u0019y\u0005\u0003\u0005\u0004RA\u0002\u000b\u0011BA.\u0011%\u0019\u0019\u0006\rb\u0001\n\u001b\u0019)\u0006\u0003\u0005\u0004\\A\u0002\u000bQBB,\u0011%\u0019i\u0006\rb\u0001\n\u0013\u0019y\u0006\u0003\u0005\u0004pA\u0002\u000b\u0011BB1\u0011%\u0019\t\b\rb\u0001\n\u0013\u0019\u0019\b\u0003\u0005\u0004\u0002B\u0002\u000b\u0011BB;\u0011%\u0019\u0019\t\rb\u0001\n\u0013\u0019)\t\u0003\u0005\u0004\fB\u0002\u000b\u0011BBD\u0011%\u0019i\t\rb\u0001\n\u0013\u0019y\t\u0003\u0005\u0004\u001eB\u0002\u000b\u0011BBI\u0011%\u0019y\n\rb\u0001\n\u0013\u0019y\u0005\u0003\u0005\u0004\"B\u0002\u000b\u0011BA.\u0011%\u0019\u0019\u000b\rb\u0001\n\u0013\u0019)\u000b\u0003\u0005\u00044B\u0002\u000b\u0011BBT\u0011%I\u0007\u0007#b\u0001\n\u0013\u00199\f\u0003\u0006\u0004@BB)\u0019!C\u0005\u0007\u0003D\u0011ba41\u0001\u0004%Iaa\u0014\t\u0013\rE\u0007\u00071A\u0005\n\rM\u0007\u0002CBla\u0001\u0006K!a\u0017\t\u0015\re\u0007\u0007#b\u0001\n\u0013\u0019Y\u000e\u0003\u0006\u0004rBB)\u0019!C\u0005\u0007gD!ba?1\u0011\u000b\u0007I\u0011BB\u007f\u0011%!)\u0001\rb\u0001\n\u0003\ny\u000f\u0003\u0005\u0005\bA\u0002\u000b\u0011BAy\u0011\u001d!I\u0001\rC!\t\u0017Aq\u0001\"\u00051\t\u0003\"\u0019\u0002C\u0004\u0005\u0018A\"I\u0001\"\u0007\t\u000f\u00115\u0002\u0007\"\u0011\u00050!9AQ\u0007\u0019\u0005\n\u0011]\u0002b\u0002C'a\u0011%Aq\n\u0005\b\t'\u0002D\u0011\u0002C+\u0011\u001d!I\u0006\rC\u0005\t7Bq\u0001\"\u001b1\t\u0013!Y\u0007C\u0004\u0005zA\"I\u0001b\u001f\t\u000f\u0011%\u0005\u0007\"\u0003\u0005\f\"9Aq\u0012\u0019\u0005\n\u0011E\u0005b\u0002CJa\u0011%AQ\u0013\u0005\b\t7\u0003D\u0011\u0001CO\u0011\u001d!\t\u000b\rC\u0001\tG\u000b\u0011CS1dWN|gnU3sS\u0006d\u0017N_3s\u0015\t9\u0007.A\u0004kC\u000e\\7o\u001c8\u000b\u0005%T\u0017!D:fe&\fG.\u001b>bi&|gN\u0003\u0002lY\u0006)\u0001/Z6l_*\u0011QN\\\u0001\u0007CB\f7\r[3\u000b\u0003=\f1a\u001c:h!\t\t\u0018!D\u0001g\u0005EQ\u0015mY6t_:\u001cVM]5bY&TXM]\n\u0003\u0003Q\u0004\"!\u001e=\u000e\u0003YT\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003A\u00141cR1eO\u0016$8\t\\1tg\u0012+g.\u001f'jgR\u001c\"aA@\u0011\t\u0005\u0005\u0011\u0011D\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!\u0011.\u001c9m\u0015\u0011\tI!a\u0003\u0002\u0011)\u001cxN\u001c;za\u0016TA!!\u0004\u0002\u0010\u0005AA-\u0019;bE&tGMC\u0002h\u0003#QA!a\u0005\u0002\u0016\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003/\t1aY8n\u0013\u0011\tY\"a\u0001\u0003!M+(\rV=qKZ\u000bG.\u001b3bi>\u0014HCAA\u0010!\r\t\tcA\u0007\u0002\u0003\u0005AB-\u001a4bk2$hj\u001c#fg\u0016\u00148\t\\1tg:\u000bW.Z:\u0016\u0005\u0005\u001d\u0002CBA\u0015\u0003g\t9$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002,\t\u00191+\u001a;\u0011\t\u0005e\u0012q\t\b\u0005\u0003w\t\u0019\u0005E\u0002\u0002>Yl!!a\u0010\u000b\u0007\u0005\u000530\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000b2\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002J\u0005-#AB*ue&twMC\u0002\u0002FY\fA\u0002\u001d:fM&D8\u000b\u001d:j]\u001e,\"!a\u000e\u0002\u001bA\u0014XMZ5y'B\u0014\u0018N\\4!\u0003)\u0001(/\u001a4jq\u000e\u001b\u0004\u000bM\u0001\faJ,g-\u001b=DgA\u0003\u0004%\u0001\njg\u0006cGn\\<fI\u000ec\u0017m]:OC6,G\u0003BA.\u0003C\u00022!^A/\u0013\r\tyF\u001e\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019G\u0003a\u0001\u0003o\t\u0011b\u00197bgNt\u0015-\\3\u0002\u001d%\u001c\u0018\t\u001c7po\u0016$7\t\\1tgR!\u00111LA5\u0011\u001d\tYg\u0003a\u0001\u0003[\nQa\u00197buj\u0004D!a\u001c\u0002zA1\u0011\u0011HA9\u0003kJA!a\u001d\u0002L\t)1\t\\1tgB!\u0011qOA=\u0019\u0001!A\"a\u001f\u0002j\u0005\u0005\t\u0011!B\u0001\u0003{\u00121a\u0018\u00132#\u0011\ty(!\"\u0011\u0007U\f\t)C\u0002\u0002\u0004Z\u0014qAT8uQ&tw\rE\u0002v\u0003\u000fK1!!#w\u0005\r\te._\u0001\u0015SN\fE\u000e\\8xK\u0012\u001c\u0006O]5oO\u000ec\u0017m]:\u0015\t\u0005m\u0013q\u0012\u0005\b\u0003Wb\u0001\u0019AAIa\u0011\t\u0019*a&\u0011\r\u0005e\u0012\u0011OAK!\u0011\t9(a&\u0005\u0019\u0005e\u0015qRA\u0001\u0002\u0003\u0015\t!! \u0003\u0007}##\u0007K\u0002\r\u0003;\u0003B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G3\u0018AC1o]>$\u0018\r^5p]&!\u0011qUAQ\u0005\u001d!\u0018-\u001b7sK\u000e\fq\u0004Z5tC2dwn^3e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4t+\t\ti\u000b\u0005\u0004\u0002:\u0005=\u0016\u0011W\u0005\u0005\u0003k\tY\u0005\r\u0003\u00024\u0006]\u0006CBA\u001d\u0003c\n)\f\u0005\u0003\u0002x\u0005]FaCA]\u001d\u0005\u0005\t\u0011!B\u0001\u0003{\u00121a\u0018\u00134\u0003\u0001\"\u0017n]1mY><X\rZ*fe&\fG.\u001b>bi&|gNQ5oI&twm\u001d\u0011\u0002\u0013%\u001cxIW5qa\u0016$G\u0003BA.\u0003\u0003Dq!a1\u0010\u0001\u0004\t)-A\u0003csR,7\u000fE\u0003v\u0003\u000f\fY-C\u0002\u0002JZ\u0014Q!\u0011:sCf\u00042!^Ag\u0013\r\tyM\u001e\u0002\u0005\u0005f$XMA\u0004M5RjU\r^1\u0014\rA!\u0018Q[An!\r)\u0018q[\u0005\u0004\u000334(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003;\f9O\u0004\u0003\u0002`\u0006\rh\u0002BA\u001f\u0003CL\u0011a^\u0005\u0004\u0003K4\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003S\fYO\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002fZ\faa\u001c4gg\u0016$XCAAy!\r)\u00181_\u0005\u0004\u0003k4(aA%oi\u00069qN\u001a4tKR\u0004\u0013A\u00027f]\u001e$\b.A\u0004mK:<G\u000f\u001b\u0011\u0015\r\u0005}(\u0011\u0001B\u0002!\r\t\t\u0003\u0005\u0005\b\u0003[,\u0002\u0019AAy\u0011\u001d\tI0\u0006a\u0001\u0003c\fq\u0001];u\u0013:$x\u000e\u0006\u0003\u0003\n\t=\u0001cA;\u0003\f%\u0019!Q\u0002<\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005#1\u0002\u0019\u0001B\n\u0003\u0019\u0011WO\u001a4feB!!Q\u0003B\u000e\u001b\t\u00119B\u0003\u0003\u0003\u001a\u0005=\u0012a\u00018j_&!!Q\u0004B\f\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\naJ,\u0007/\u001a8e)>$B!!2\u0003$!9\u00111Y\fA\u0002\u0005\u0015\u0017\u0001B2paf$b!a@\u0003*\t-\u0002\"CAw1A\u0005\t\u0019AAy\u0011%\tI\u0010\u0007I\u0001\u0002\u0004\t\t0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE\"\u0006BAy\u0005gY#A!\u000e\u0011\t\t]\"QH\u0007\u0003\u0005sQAAa\u000f\u0002\"\u0006IQO\\2iK\u000e\\W\rZ\u0005\u0005\u0005\u007f\u0011IDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u000f\u0002BA!\u0013\u0003P5\u0011!1\n\u0006\u0005\u0005\u001b\ny#\u0001\u0003mC:<\u0017\u0002BA%\u0005\u0017\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0006\n]\u0003\"\u0003B-;\u0005\u0005\t\u0019AAy\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\f\t\u0007\u0005C\u00129'!\"\u000e\u0005\t\r$b\u0001B3m\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t%$1\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\\\t=\u0004\"\u0003B-?\u0005\u0005\t\u0019AAC\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t\u001d#Q\u000f\u0005\n\u00053\u0002\u0013\u0011!a\u0001\u0003c\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003c\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000f\na!Z9vC2\u001cH\u0003BA.\u0005\u0007C\u0011B!\u0017$\u0003\u0003\u0005\r!!\"\u0002\u000f1SF'T3uCB\u0019\u0011\u0011E\u0013\u0014\t\u0015\"(1\u0012\t\u0005\u0005\u001b\u0013\u0019*\u0004\u0002\u0003\u0010*!!\u0011SA\u0018\u0003\tIw.\u0003\u0003\u0002j\n=EC\u0001BD\u0003%a%\fN0N\u0003\u001eK5)\u0001\u0006M5RzV*Q$J\u0007\u0002\nQ!\u00199qYf$B!a@\u0003 \"9\u00111Y\u0015A\u0002\u0005\u0015\u0017aA4fiR!!Q\u0015BX!\u0019\u00119Ka+\u0002\u00006\u0011!\u0011\u0016\u0006\u0004\u0003[Q\u0017\u0002\u0002BW\u0005S\u0013\u0011b\u00149uS>tg+\u00197\t\u000f\tE!\u00061\u0001\u0003\u0014Q!!Q\u0015BZ\u0011\u001d\t\u0019m\u000ba\u0001\u0003\u000b$b!a@\u00038\ne\u0006bBAwY\u0001\u0007\u0011\u0011\u001f\u0005\b\u0003sd\u0003\u0019AAy\u0003\u001d)h.\u00199qYf$BAa0\u0003LB)QO!1\u0003F&\u0019!1\u0019<\u0003\r=\u0003H/[8o!\u001d)(qYAy\u0003cL1A!3w\u0005\u0019!V\u000f\u001d7fe!I!QZ\u0017\u0002\u0002\u0003\u0007\u0011q`\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001Bj!\u0011\u0011IE!6\n\t\t]'1\n\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b%\u001cHJ\u0017\u001b\u0015\t\u0005m#Q\u001c\u0005\b\u0003\u0007|\u0003\u0019AAcQ\r\t!\u0011\u001d\t\u0005\u0005G\u00149/\u0004\u0002\u0003f*\u0019\u00111\u00156\n\t\t%(Q\u001d\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eK\u0002\u0001\u0005C\u001c2\u0001\rBx!\u0011\u0011\tPa=\u000e\u0003!L1A!>i\u0005q\u0019VM]5bY&TXM],ji\"\u001cFO]5oO6\u000bg.\u001b4fgR\faa]=ti\u0016lWC\u0001B~!\u0011\u0011ipa\u0001\u000e\u0005\t}(bAB\u0001U\u0006)\u0011m\u0019;pe&!1Q\u0001B\u0000\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\n1BY5oI&twMT1nK\u0006a!-\u001b8eS:<g*Y7fA\u0005aqN\u00196fGRl\u0015\r\u001d9feV\u00111\u0011\u0003\t\u0005\u0007'\u0019)\"\u0004\u0002\u0002\f%!1qCA\u0006\u00051y%M[3di6\u000b\u0007\u000f]3s\u00035y'M[3di6\u000b\u0007\u000f]3sAQA1QDB\u0010\u0007C\u0019\u0019\u0003\u0005\u0002ra!9!q_\u001cA\u0002\tm\bbBB\u0005o\u0001\u0007\u0011q\u0007\u0005\b\u0007\u001b9\u0004\u0019AB\t\u0003\rawnZ\u000b\u0003\u0007S\u0001Baa\u000b\u000425\u00111Q\u0006\u0006\u0004\u0007_Q\u0017!B3wK:$\u0018\u0002BB\u001a\u0007[\u0011A#T1sW\u0016\u0014Hj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\nAaY8oMV\u001111\b\t\u0005\u0007{\u00199%\u0004\u0002\u0004@)!1\u0011IB\"\u0003\u0019\u0019wN\u001c4jO*!1QIA\u000b\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BB%\u0007\u007f\u0011aaQ8oM&<\u0017!B2p]\u001a\u0004\u0013AD5t\t\u0016\u0014WoZ#oC\ndW\rZ\u000b\u0003\u00037\nq\"[:EK\n,x-\u00128bE2,G\rI\u0001\u000b\u0005V4g-\u001a:TSj,WCAB,\u001f\t\u0019I&\b\u0002\u0011\u0001\u0005Y!)\u001e4gKJ\u001c\u0016N_3!\u0003Q\u0019w.\u001c9sKN\u001c\u0018n\u001c8BY\u001e|'/\u001b;i[V\u00111\u0011\r\t\u0005\u0007G\u001aIGD\u0002r\u0007KJ1aa\u001ag\u0003-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\n\t\r-4Q\u000e\u0002\t\u00032<wN]5u[*\u00191q\r4\u0002+\r|W\u000e\u001d:fgNLwN\\!mO>\u0014\u0018\u000e\u001e5nA\u0005QQ.[4sCRLwN\\:\u0016\u0005\rU\u0004\u0003CA\u001d\u0007o\n9da\u001f\n\t\re\u00141\n\u0002\u0004\u001b\u0006\u0004\bcA9\u0004~%\u00191q\u00104\u0003!)\u000b7m[:p]6KwM]1uS>t\u0017aC7jOJ\fG/[8og\u0002\n\u0001\u0002Z3os2K7\u000f^\u000b\u0003\u0007\u000f\u00032a!#\u0004\u001d\t\t\b!A\u0005eK:LH*[:uA\u0005\u0011\u0012\r\u001c7po\u0016$7\t\\1tgB\u0013XMZ5y+\t\u0019\t\n\u0005\u0004\u0004\u0014\u000ee%qI\u0007\u0003\u0007+SAaa&\u0003d\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u00077\u001b)J\u0001\u0004WK\u000e$xN]\u0001\u0014C2dwn^3e\u00072\f7o\u001d)sK\u001aL\u0007\u0010I\u0001\u000fif\u0004X-\u00138NC:Lg-Z:u\u0003=!\u0018\u0010]3J]6\u000bg.\u001b4fgR\u0004\u0013!H2p]\u001aLw-\u001e:fI\u0012+7/\u001a:jC2L'0\u0019;j_:$\u0016\u0010]3\u0016\u0005\r\u001d\u0006#B;\u0003B\u000e%\u0006\u0007BBV\u0007_\u0003b!!\u000f\u0002r\r5\u0006\u0003BA<\u0007_#1b!-L\u0003\u0003\u0005\tQ!\u0001\u00046\n\u0019q\fJ\u001b\u0002=\r|gNZ5hkJ,G\rR3tKJL\u0017\r\\5{CRLwN\u001c+za\u0016\u0004\u0013cAA@iV\u00111\u0011\u0018\t\u0005\u0005c\u001cY,C\u0002\u0004>\"\u0014QbU3sS\u0006d\u0017N_1uS>t\u0017a\u00053fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8UsB,WCABb!\u0015)(\u0011YBca\u0011\u00199ma3\u0011\r\u0005e\u0012\u0011OBe!\u0011\t9ha3\u0005\u0017\r5W*!A\u0001\u0002\u000b\u00051Q\u0017\u0002\u0004?\u00122\u0014AH:fe&\fG.\u001b>bi&|gNQ5oI&twm]\"iK\u000e\\W\rZ(l\u0003\t\u001aXM]5bY&T\u0018\r^5p]\nKg\u000eZ5oON\u001c\u0005.Z2lK\u0012|5n\u0018\u0013fcR!!\u0011BBk\u0011%\u0011IfTA\u0001\u0002\u0004\tY&A\u0010tKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:DQ\u0016\u001c7.\u001a3PW\u0002\n!\u0002\u001c>5\r\u0006\u001cGo\u001c:z+\t\u0019i\u000e\u0005\u0003\u0004`\u000e5XBABq\u0015\u0011\u0019\u0019o!:\u0002\u00071THG\u0003\u0003\u0004h\u000e%\u0018a\u00026q_VtGO\u001f\u0006\u0003\u0007W\f1A\\3u\u0013\u0011\u0019yo!9\u0003\u00151SFGR1di>\u0014\u00180A\u0007muR\u001au.\u001c9sKN\u001cxN]\u000b\u0003\u0007k\u0004Baa8\u0004x&!1\u0011`Bq\u00055a%\fN\"p[B\u0014Xm]:pe\u0006yAN\u001f\u001bEK\u000e|W\u000e\u001d:fgN|'/\u0006\u0002\u0004\u0000B!1q\u001cC\u0001\u0013\u0011!\u0019a!9\u0003'1SFgU1gK\u0012+7m\\7qe\u0016\u001c8o\u001c:\u0002\u0015%$WM\u001c;jM&,'/A\u0006jI\u0016tG/\u001b4jKJ\u0004\u0013\u0001C7b]&4Wm\u001d;\u0015\t\u0005]BQ\u0002\u0005\u0007\t\u001f1\u0006\u0019\u0001;\u0002\u0007=\u0014'.\u0001\u0005u_\nKg.\u0019:z)\u0011\t)\r\"\u0006\t\r\u0011=q\u000b1\u0001u\u0003Mawn\u001a+p\u0005&t\u0017M]=EkJ\fG/[8o))\u0011I\u0001b\u0007\u0005\u001e\u0011\u001dB\u0011\u0006\u0005\u0007\t\u001fA\u0006\u0019\u0001;\t\u000f\u0011}\u0001\f1\u0001\u0005\"\u0005I1\u000f^1siRKW.\u001a\t\u0004k\u0012\r\u0012b\u0001C\u0013m\n!Aj\u001c8h\u0011\u001d\t\u0019\r\u0017a\u0001\u0003\u000bDq\u0001b\u000bY\u0001\u0004\t)-\u0001\u0004sKN,H\u000e^\u0001\u000bMJ|WNQ5oCJLH#\u0002;\u00052\u0011M\u0002bBAb3\u0002\u0007\u0011Q\u0019\u0005\b\t\u0013I\u0006\u0019AA\u001c\u0003Uawn\u001a$s_6\u0014\u0015N\\1ss\u0012+(/\u0019;j_:$\"B!\u0003\u0005:\u0011mBq\bC!\u0011\u001d\t\u0019M\u0017a\u0001\u0003\u000bDq\u0001\"\u0010[\u0001\u0004\t)-A\beK\u000e|W\u000e\u001d:fgN\u0014\u0015\u0010^3t\u0011\u001d!yB\u0017a\u0001\tCAq!a\u001b[\u0001\u0004!\u0019\u0005\r\u0003\u0005F\u0011%\u0003CBA\u001d\u0003c\"9\u0005\u0005\u0003\u0002x\u0011%C\u0001\u0004C&\t\u0003\n\t\u0011!A\u0003\u0002\rU&aA0%o\u0005a\u0011n]\"bg\u0016|%M[3diR!\u00111\fC)\u0011\u001d\t\u0019g\u0017a\u0001\u0003o\tQc\u00195fG.\fE\u000e\\8xK\u0012\u001cE.Y:t\u001d\u0006lW\r\u0006\u0003\u0003\n\u0011]\u0003bBA29\u0002\u0007\u0011qG\u0001\u0012G\",7m[!mY><X\rZ\"mCN\u001cH\u0003\u0002B\u0005\t;Bq!a\u001b^\u0001\u0004!y\u0006\r\u0003\u0005b\u0011\u0015\u0004CBA\u001d\u0003c\"\u0019\u0007\u0005\u0003\u0002x\u0011\u0015D\u0001\u0004C4\t;\n\t\u0011!A\u0003\u0002\u0005u$aA0%q\u0005i\u0011n]%o\u00032dwn\u001e'jgR$B!a\u0017\u0005n!9\u00111\u000e0A\u0002\u0011=\u0004\u0007\u0002C9\tk\u0002b!!\u000f\u0002r\u0011M\u0004\u0003BA<\tk\"A\u0002b\u001e\u0005n\u0005\u0005\t\u0011!B\u0001\u0003{\u00121a\u0018\u0013:\u0003iI7OQ8v]\u0012$vNS1dWN|gnU3sS\u0006d\u0017N_3s)\u0011\tY\u0006\" \t\u000f\u0005-t\f1\u0001\u0005\u0000A\"A\u0011\u0011CC!\u0019\tI$!\u001d\u0005\u0004B!\u0011q\u000fCC\t1!9\t\" \u0002\u0002\u0003\u0005)\u0011AA?\u0005\u0011yF%\r\u0019\u0002+!\f7/\u00117m_^,Gm\u00117bgN\u0004&/\u001a4jqR!\u00111\fCG\u0011\u001d\t\u0019\u0007\u0019a\u0001\u0003o\t\u0011e\u00195fG.\fE\u000e\\8xK\u0012\u001cVM]5bY&T\u0018\r^5p]\nKg\u000eZ5oON$\"A!\u0003\u0002\u001bA\f'o]3NC:Lg-Z:u)\u0011!9\n\"'\u0011\u000fU\u00149-!=\u00028!9A\u0011\u00022A\u0002\u0005]\u0012\u0001C2p[B\u0014Xm]:\u0015\t\u0005\u0015Gq\u0014\u0005\b\u0003\u0007\u001c\u0007\u0019AAc\u0003)!WmY8naJ,7o\u001d\u000b\u0005\u0003\u000b$)\u000bC\u0004\u0002D\u0012\u0004\r!!2)\u0007A\u0012\t\u000f")
@InternalApi
public abstract class JacksonSerializer
extends SerializerWithStringManifest {
    private Serialization serialization;
    private Option<Class<?>> deserializationType;
    private LZ4Factory lz4Factory;
    private LZ4Compressor lz4Compressor;
    private LZ4SafeDecompressor lz4Decompressor;
    private final ExtendedActorSystem system;
    private final String bindingName;
    private final ObjectMapper objectMapper;
    private final MarkerLoggingAdapter log;
    private final Config conf;
    private final boolean isDebugEnabled;
    private final Compression.Algoritm compressionAlgorithm;
    private final Map<String, JacksonMigration> migrations;
    private final GadgetClassDenyList denyList;
    private final Vector<String> allowedClassPrefix;
    private final boolean typeInManifest;
    private Option<Class<?>> configuredDeserializationType;
    private boolean serializationBindingsCheckedOk;
    private final int identifier;
    private volatile byte bitmap$0;

    public static boolean isLZ4(byte[] bytes) {
        return JacksonSerializer$.MODULE$.isLZ4(bytes);
    }

    public static boolean isGZipped(byte[] bytes) {
        return JacksonSerializer$.MODULE$.isGZipped(bytes);
    }

    public static scala.collection.immutable.Set<Class<?>> disallowedSerializationBindings() {
        return JacksonSerializer$.MODULE$.disallowedSerializationBindings();
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public String bindingName() {
        return this.bindingName;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private Config conf() {
        return this.conf;
    }

    private boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    private final int BufferSize() {
        return 4096;
    }

    private Compression.Algoritm compressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    private Map<String, JacksonMigration> migrations() {
        return this.migrations;
    }

    private GadgetClassDenyList denyList() {
        return this.denyList;
    }

    private Vector<String> allowedClassPrefix() {
        return this.allowedClassPrefix;
    }

    private boolean typeInManifest() {
        return this.typeInManifest;
    }

    private Option<Class<?>> configuredDeserializationType() {
        return this.configuredDeserializationType;
    }

    private Serialization serialization$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serialization$lzycompute();
        }
        return this.serialization;
    }

    private Option<Class<?>> deserializationType$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deserializationType = this.typeInManifest() ? None$.MODULE$ : this.configuredDeserializationType().orElse((Function0 & Serializable)() -> {
                    Tuple2 tuple2;
                    SeqOps seqOps;
                    Seq bindings = (Seq)this.serialization().bindings().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JacksonSerializer.$anonfun$deserializationType$2(this, x$1)));
                    Seq seq = bindings;
                    if (Nil$.MODULE$.equals(seq)) {
                        throw new IllegalArgumentException(new StringBuilder(160).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").append(" a deserialization-type or have exactly one binding configured, but none were configured").toString());
                    }
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (tuple2 = (Tuple2)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) != null) {
                        Class clazz = (Class)tuple2._1();
                        return new Some(clazz.asSubclass(Object.class));
                    }
                    throw new IllegalArgumentException(new StringBuilder(176).append("Jackson serializer [").append(this.bindingName()).append("] with type-in-manifest disabled must either declare").append(" a deserialization-type or have exactly one binding configured, but multiple bindings").append(" were configured [").append(seq.mkString(", ")).append("]").toString());
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.configuredDeserializationType = null;
        return this.deserializationType;
    }

    private Option<Class<?>> deserializationType() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deserializationType$lzycompute();
        }
        return this.deserializationType;
    }

    private boolean serializationBindingsCheckedOk() {
        return this.serializationBindingsCheckedOk;
    }

    private void serializationBindingsCheckedOk_$eq(boolean x$1) {
        this.serializationBindingsCheckedOk = x$1;
    }

    private LZ4Factory lz4Factory$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lz4Factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lz4Factory;
    }

    private LZ4Factory lz4Factory() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.lz4Factory$lzycompute();
        }
        return this.lz4Factory;
    }

    private LZ4Compressor lz4Compressor$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.lz4Compressor = this.lz4Factory().fastCompressor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.lz4Compressor;
    }

    private LZ4Compressor lz4Compressor() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.lz4Compressor$lzycompute();
        }
        return this.lz4Compressor;
    }

    private LZ4SafeDecompressor lz4Decompressor$lzycompute() {
        JacksonSerializer jacksonSerializer = this;
        synchronized (jacksonSerializer) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.lz4Decompressor = this.lz4Factory().safeDecompressor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.lz4Decompressor;
    }

    private LZ4SafeDecompressor lz4Decompressor() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.lz4Decompressor$lzycompute();
        }
        return this.lz4Decompressor;
    }

    public int identifier() {
        return this.identifier;
    }

    public String manifest(Object obj) {
        this.checkAllowedSerializationBindings();
        Option<Class<?>> option = this.deserializationType();
        if (option instanceof Some) {
            Some some = (Some)option;
            Class clazz = (Class)some.value();
            Option option2 = this.migrations().get((Object)clazz.getName());
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JacksonMigration transformer = (JacksonMigration)some2.value();
                return new StringBuilder(1).append("#").append(transformer.currentVersion()).toString();
            }
            if (None$.MODULE$.equals(option2)) {
                return "";
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String className = obj.getClass().getName();
            this.checkAllowedClassName(className);
            this.checkAllowedClass(obj.getClass());
            Option option3 = this.migrations().get((Object)className);
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                JacksonMigration transformer = (JacksonMigration)some.value();
                return new StringBuilder(1).append(className).append("#").append(transformer.currentVersion()).toString();
            }
            if (None$.MODULE$.equals(option3)) {
                return className;
            }
            throw new MatchError((Object)option3);
        }
        throw new MatchError(option);
    }

    public byte[] toBinary(Object obj) {
        this.checkAllowedSerializationBindings();
        long startTime = this.isDebugEnabled() ? System.nanoTime() : 0L;
        byte[] bytes = this.objectMapper().writeValueAsBytes(obj);
        byte[] result = this.compress(bytes);
        this.logToBinaryDuration(obj, startTime, bytes, result);
        return result;
    }

    private void logToBinaryDuration(Object obj, long startTime, byte[] bytes, byte[] result) {
        if (this.isDebugEnabled()) {
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == result.length) {
                this.log().debug("Serialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length));
                return;
            }
            this.log().debug("Serialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)obj.getClass().getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)result.length), (Object)BoxesRunTime.boxToInteger((int)bytes.length));
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object fromBinary(byte[] bytes, String manifest) {
        this.checkAllowedSerializationBindings();
        startTime = this.isDebugEnabled() != false ? System.nanoTime() : 0L;
        var10_4 = this.parseManifest(manifest);
        if (var10_4 == null) {
            throw new MatchError(var10_4);
        }
        fromVersion = var10_4._1$mcI$sp();
        manifestClassName = (String)var10_4._2();
        var9_7 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
        fromVersion = var9_7._1$mcI$sp();
        manifestClassName = (String)var9_7._2();
        if (this.typeInManifest()) {
            this.checkAllowedClassName(manifestClassName);
        }
        migration = this.migrations().get(this.deserializationType().fold((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromBinary$1(java.lang.String ), ()Ljava/lang/String;)((String)manifestClassName), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fromBinary$2(java.lang.Class ), (Ljava/lang/Class;)Ljava/lang/String;)()));
        var17_11 = false;
        var18_12 = null;
        var19_13 = migration;
        if (!(var19_13 instanceof Some)) ** GOTO lbl-1000
        var17_11 = true;
        var18_12 = (Some)var19_13;
        transformer = (JacksonMigration)var18_12.value();
        if (fromVersion < transformer.currentVersion()) {
            v0 = transformer.transformClassName(fromVersion, manifestClassName);
        } else if (var17_11 && fromVersion == (transformer = (JacksonMigration)var18_12.value()).currentVersion()) {
            v0 = manifestClassName;
        } else if (var17_11 && fromVersion <= (transformer = (JacksonMigration)var18_12.value()).supportedForwardVersion()) {
            v0 = transformer.transformClassName(fromVersion, manifestClassName);
        } else {
            if (var17_11 && fromVersion > (transformer = (JacksonMigration)var18_12.value()).supportedForwardVersion()) {
                throw new IllegalStateException(new StringBuilder(61).append("Migration version ").append(transformer.supportedForwardVersion()).append(" is ").append("behind version ").append(fromVersion).append(" of deserialized type [").append(manifestClassName).append("]").toString());
            }
            v0 = className = manifestClassName;
        }
        if (this.typeInManifest() && className != manifestClassName) {
            this.checkAllowedClassName(className);
        }
        if (this.isCaseObject(className)) {
            var25_19 = this.system().dynamicAccess().getObjectFor(className, ClassTag$.MODULE$.AnyRef());
            if (!(var25_19 instanceof Success)) {
                if (var25_19 instanceof Failure) {
                    throw new NotSerializableException(new StringBuilder(54).append("Cannot find manifest case object [").append(className).append("] for serializer [").append(this.getClass().getName()).append("].").toString());
                }
                throw new MatchError((Object)var25_19);
            }
            var26_20 = (Success)var25_19;
            obj = var26_20.value();
            result = obj;
            clazz = result.getClass();
            this.checkAllowedClass(clazz);
            this.logFromBinaryDuration(bytes, bytes, startTime, clazz);
            return result;
        }
        clazz = (Class)this.deserializationType().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fromBinary$3(org.apache.pekko.serialization.jackson.JacksonSerializer java.lang.String ), ()Ljava/lang/Class;)((JacksonSerializer)this, (String)className));
        if (this.typeInManifest()) {
            this.checkAllowedClass(clazz);
        }
        decompressedBytes = this.decompress(bytes);
        var32_26 = false;
        var33_27 = null;
        var34_28 = migration;
        if (!(var34_28 instanceof Some)) ** GOTO lbl-1000
        var32_26 = true;
        var33_27 = (Some)var34_28;
        transformer = (JacksonMigration)var33_27.value();
        if (fromVersion < transformer.currentVersion()) {
            jsonTree = this.objectMapper().readTree(decompressedBytes);
            newJsonTree = transformer.transform(fromVersion, jsonTree);
            v1 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
        } else if (var32_26 && fromVersion == (transformer = (JacksonMigration)var33_27.value()).currentVersion()) {
            v1 = this.objectMapper().readValue(decompressedBytes, clazz);
        } else if (var32_26 && fromVersion <= (transformer = (JacksonMigration)var33_27.value()).supportedForwardVersion()) {
            jsonTree = this.objectMapper().readTree(decompressedBytes);
            newJsonTree = transformer.transform(fromVersion, jsonTree);
            v1 = this.objectMapper().treeToValue((TreeNode)newJsonTree, clazz);
        } else {
            v1 = this.objectMapper().readValue(decompressedBytes, clazz);
        }
        result = v1;
        this.logFromBinaryDuration(bytes, decompressedBytes, startTime, clazz);
        return result;
    }

    private void logFromBinaryDuration(byte[] bytes, byte[] decompressBytes, long startTime, Class<?> clazz) {
        if (this.isDebugEnabled()) {
            long durationMicros = (System.nanoTime() - startTime) / 1000L;
            if (bytes.length == decompressBytes.length) {
                this.log().debug("Deserialization of [{}] took [{}] \u00b5s, size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
                return;
            }
            this.log().debug("Deserialization of [{}] took [{}] \u00b5s, compressed size [{}] bytes, uncompressed size [{}] bytes", (Object)clazz.getName(), (Object)BoxesRunTime.boxToLong((long)durationMicros), (Object)BoxesRunTime.boxToInteger((int)bytes.length), (Object)BoxesRunTime.boxToInteger((int)decompressBytes.length));
            return;
        }
    }

    private boolean isCaseObject(String className) {
        return className.length() > 0 && className.charAt(className.length() - 1) == '$';
    }

    private void checkAllowedClassName(String className) {
        if (!this.denyList().isAllowedClassName(className)) {
            String warnMsg = new StringBuilder(100).append("Can't serialize/deserialize object of type [").append(className).append("] in [").append(this.getClass().getName()).append("]. ").append("Disallowed (on deny list) for security reasons.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private void checkAllowedClass(Class<?> clazz) {
        if (!this.denyList().isAllowedClass(clazz)) {
            String warnMsg = new StringBuilder(86).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Not allowed for security reasons.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
        if (!this.isInAllowList(clazz)) {
            String warnMsg = new StringBuilder(245).append("Can't serialize/deserialize object of type [").append(clazz.getName()).append("] in [").append(this.getClass().getName()).append("]. ").append("Only classes that are listed as allowed are allowed for security reasons. ").append("Configure allowed classes with pekko.actor.serialization-bindings or ").append("pekko.serialization.jackson.allowed-class-prefix.").toString();
            this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private boolean isInAllowList(Class<?> clazz) {
        return this.isBoundToJacksonSerializer(clazz) || this.hasAllowedClassPrefix(clazz.getName());
    }

    private boolean isBoundToJacksonSerializer(Class<?> clazz) {
        boolean bl;
        try {
            Serializer boundSerializer = this.serialization().serializerFor(clazz);
            bl = boundSerializer instanceof JacksonSerializer;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    private boolean hasAllowedClassPrefix(String className) {
        return this.allowedClassPrefix().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)className.startsWith(x$1)));
    }

    private void checkAllowedSerializationBindings() {
        if (!this.serializationBindingsCheckedOk()) {
            JacksonSerializer$.MODULE$.disallowedSerializationBindings().foreach((Function1 & Serializable)clazz -> {
                JacksonSerializer.$anonfun$checkAllowedSerializationBindings$1(this, clazz);
                return BoxedUnit.UNIT;
            });
            this.serializationBindingsCheckedOk_$eq(true);
            return;
        }
    }

    private Tuple2<Object, String> parseManifest(String manifest) {
        int i = manifest.lastIndexOf(35);
        int fromVersion = i == -1 ? 1 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(manifest.substring(i + 1)));
        String manifestClassName = i == -1 ? manifest : manifest.substring(0, i);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)fromVersion), (Object)manifestClassName);
    }

    public byte[] compress(byte[] bytes) {
        boolean bl = false;
        Compression.GZip gZip = null;
        boolean bl2 = false;
        Compression.LZ4 lZ4 = null;
        Compression.Algoritm algoritm = this.compressionAlgorithm();
        if (Compression$Off$.MODULE$.equals(algoritm)) {
            return bytes;
        }
        if (algoritm instanceof Compression.GZip) {
            bl = true;
            gZip = (Compression.GZip)algoritm;
            long largerThan = gZip.largerThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
        }
        if (bl) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
                zip.write(bytes);
            }
            return bos.toByteArray();
        }
        if (algoritm instanceof Compression.LZ4) {
            bl2 = true;
            lZ4 = (Compression.LZ4)algoritm;
            long largerThan = lZ4.largerThan();
            if ((long)bytes.length <= largerThan) {
                return bytes;
            }
        }
        if (bl2) {
            LZ4Meta meta = JacksonSerializer$LZ4Meta$.MODULE$.apply(bytes);
            byte[] compressed = this.lz4Compressor().compress(bytes);
            return meta.prependTo(compressed);
        }
        throw new MatchError((Object)algoritm);
    }

    public byte[] decompress(byte[] bytes) {
        if (JacksonSerializer$.MODULE$.isGZipped(bytes)) {
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            try {
                this.readChunk$1(in, buffer, out);
            }
            finally {
                in.close();
            }
            return out.toByteArray();
        }
        LZ4Meta lZ4Meta = JacksonSerializer$LZ4Meta$.MODULE$.get(bytes);
        LZ4Meta lZ4Meta2 = (LZ4Meta)OptionVal.Some$.MODULE$.unapply((Object)lZ4Meta);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lZ4Meta2)) {
            LZ4Meta meta = (LZ4Meta)OptionVal$.MODULE$.get$extension((Object)lZ4Meta2);
            int srcLen = bytes.length - meta.offset();
            return this.lz4Decompressor().decompress(bytes, meta.offset(), srcLen, meta.length());
        }
        return bytes;
    }

    public static final /* synthetic */ boolean $anonfun$deserializationType$2(JacksonSerializer $this, Tuple2 x$1) {
        return ((Serializer)x$1._2()).identifier() == $this.identifier();
    }

    public static final /* synthetic */ String $anonfun$fromBinary$1(String manifestClassName$1) {
        return manifestClassName$1;
    }

    public static final /* synthetic */ String $anonfun$fromBinary$2(Class x$3) {
        return x$3.getName();
    }

    public static final /* synthetic */ Class $anonfun$fromBinary$3(JacksonSerializer $this, String className$1) {
        Try try_ = $this.system().dynamicAccess().getClassFor(className$1, ClassTag$.MODULE$.AnyRef());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Class c = (Class)success.value();
            return c;
        }
        if (try_ instanceof Failure) {
            throw new NotSerializableException(new StringBuilder(48).append("Cannot find manifest class [").append(className$1).append("] for serializer [").append($this.getClass().getName()).append("].").toString());
        }
        throw new MatchError((Object)try_);
    }

    private final boolean isBindingOk$1(Class clazz) {
        boolean bl;
        try {
            bl = this.serialization().serializerFor(clazz) != this;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = true;
            }
            throw throwable;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkAllowedSerializationBindings$1(JacksonSerializer $this, Class clazz) {
        if (!$this.isBindingOk$1(clazz)) {
            String warnMsg = new StringBuilder(144).append("For security reasons it's not allowed to bind open-ended interfaces like ").append("[").append(clazz.getName()).append("] to [").append($this.getClass().getName()).append("]. ").append("Change your pekko.actor.serialization-bindings configuration.").toString();
            $this.log().warning(LogMarker$.MODULE$.Security(), warnMsg);
            throw new IllegalArgumentException(warnMsg);
        }
    }

    private final void readChunk$1(GZIPInputStream in$1, byte[] buffer$1, ByteArrayOutputStream out$1) {
        block3: while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                case -1: {
                    break block3;
                }
                default: {
                    out$1.write(buffer$1, 0, n);
                    break;
                }
            }
        }
    }

    public JacksonSerializer(ExtendedActorSystem system, String bindingName, ObjectMapper objectMapper) {
        None$ none$;
        block12: {
            Compression.Algoritm algoritm;
            block11: {
                this.system = system;
                this.bindingName = bindingName;
                this.objectMapper = objectMapper;
                this.log = Logging$.MODULE$.withMarker((ActorSystem)system, JacksonSerializer.class, LogSource$.MODULE$.fromAnyClass());
                this.conf = JacksonObjectMapperProvider$.MODULE$.configForBinding(bindingName, system.settings().config());
                this.isDebugEnabled = this.conf().getBoolean("verbose-debug-logging") && this.log().isDebugEnabled();
                String string = Helpers$.MODULE$.toRootLowerCase(this.conf().getString("compression.algorithm"));
                switch (string == null ? 0 : string.hashCode()) {
                    case 107622: {
                        if (!"lz4".equals(string)) break;
                        Long compressLargerThan = this.conf().getBytes("compression.compress-larger-than");
                        algoritm = new Compression.LZ4(Predef$.MODULE$.Long2long(compressLargerThan));
                        break block11;
                    }
                    case 109935: {
                        if (!"off".equals(string)) break;
                        algoritm = Compression$Off$.MODULE$;
                        break block11;
                    }
                    case 3189082: {
                        if (!"gzip".equals(string)) break;
                        Long compressLargerThan = this.conf().getBytes("compression.compress-larger-than");
                        algoritm = new Compression.GZip(Predef$.MODULE$.Long2long(compressLargerThan));
                        break block11;
                    }
                }
                throw new IllegalArgumentException(new StringBuilder(69).append("Unknown compression algorithm [").append(string).append("], possible values are ").append("\"off\" or \"gzip\"").toString());
            }
            this.compressionAlgorithm = algoritm;
            this.migrations = (Map)package.JavaConverters$.MODULE$.MapHasAsScala(this.conf().getConfig("migrations").root().unwrapped()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    JacksonMigration transformer = (JacksonMigration)this.system().dynamicAccess().createInstanceFor(v.toString(), (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(JacksonMigration.class)).get();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)transformer);
                }
                throw new MatchError((Object)tuple2);
            });
            this.denyList = new GadgetClassDenyList();
            this.allowedClassPrefix = package.JavaConverters$.MODULE$.ListHasAsScala(this.conf().getStringList("allowed-class-prefix")).asScala().toVector();
            this.typeInManifest = this.conf().getBoolean("type-in-manifest");
            String string = this.conf().getString("deserialization-type");
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    none$ = None$.MODULE$;
                    break block12;
                }
            }
            Try try_ = system.dynamicAccess().getClassFor(string, ClassTag$.MODULE$.AnyRef());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Class c = (Class)success.value();
                none$ = new Some((Object)c);
            } else {
                if (try_ instanceof Failure) {
                    throw new IllegalArgumentException(new StringBuilder(61).append("Cannot find deserialization-type [").append(string).append("] for Jackson serializer [").append(bindingName).append("]").toString());
                }
                throw new MatchError((Object)try_);
            }
        }
        this.configuredDeserializationType = none$;
        this.serializationBindingsCheckedOk = false;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig(bindingName, system);
    }

    public static class GadgetClassDenyList
    extends SubTypeValidator {
        private final String prefixSpring;
        private final String prefixC3P0;

        private Set<String> defaultNoDeserClassNames() {
            return SubTypeValidator.DEFAULT_NO_DESER_CLASS_NAMES;
        }

        private String prefixSpring() {
            return this.prefixSpring;
        }

        private String prefixC3P0() {
            return this.prefixC3P0;
        }

        public boolean isAllowedClassName(String className) {
            if (this.defaultNoDeserClassNames().contains(className)) {
                return false;
            }
            return !className.startsWith(this.prefixC3P0()) || !className.endsWith("DataSource");
        }

        public boolean isAllowedClass(Class<?> clazz) {
            if (clazz.getName().startsWith(this.prefixSpring())) {
                return this.isAllowedSpringClass(clazz);
            }
            return true;
        }

        private boolean isAllowedSpringClass(Class<?> clazz) {
            while (clazz != null && !clazz.equals(Object.class)) {
                String name = clazz.getSimpleName();
                if ("AbstractPointcutAdvisor".equals(name) || "AbstractApplicationContext".equals(name)) {
                    return false;
                }
                clazz = clazz.getSuperclass();
            }
            return true;
        }

        public GadgetClassDenyList() {
            this.prefixSpring = "org.springframework.";
            this.prefixC3P0 = "com.mchange.v2.c3p0.";
        }
    }

    public static final class LZ4Meta
    implements Product,
    Serializable {
        private final int offset;
        private final int length;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int offset() {
            return this.offset;
        }

        public int length() {
            return this.length;
        }

        public void putInto(ByteBuffer buffer) {
            buffer.putInt(JacksonSerializer$LZ4Meta$.MODULE$.LZ4_MAGIC());
            buffer.putInt(this.length());
        }

        public byte[] prependTo(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.allocate(bytes.length + this.offset());
            this.putInto(buffer);
            buffer.put(bytes);
            return buffer.array();
        }

        public LZ4Meta copy(int offset, int length) {
            return new LZ4Meta(offset, length);
        }

        public int copy$default$1() {
            return this.offset();
        }

        public int copy$default$2() {
            return this.length();
        }

        public String productPrefix() {
            return "LZ4Meta";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.offset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.length());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LZ4Meta;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "offset";
                }
                case 1: {
                    return "length";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.offset());
            n = Statics.mix((int)n, (int)this.length());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LZ4Meta)) return false;
            boolean bl = true;
            if (!bl) return false;
            LZ4Meta lZ4Meta = (LZ4Meta)x$1;
            if (this.offset() != lZ4Meta.offset()) return false;
            if (this.length() != lZ4Meta.length()) return false;
            return true;
        }

        public LZ4Meta(int offset, int length) {
            this.offset = offset;
            this.length = length;
            Product.$init$((Product)this);
        }
    }
}

