/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class DeferringLoadBalancerExchangeFilterFunction<T extends ExchangeFilterFunction>
implements ExchangeFilterFunction {
    private final ObjectProvider<T> exchangeFilterFunctionProvider;
    private T delegate;

    public DeferringLoadBalancerExchangeFilterFunction(ObjectProvider<T> exchangeFilterFunctionProvider) {
        this.exchangeFilterFunctionProvider = exchangeFilterFunctionProvider;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        this.tryResolveDelegate();
        return this.delegate.filter(request, next);
    }

    void tryResolveDelegate() {
        if (this.delegate == null) {
            this.delegate = (ExchangeFilterFunction)this.exchangeFilterFunctionProvider.getIfAvailable();
            if (this.delegate == null) {
                throw new IllegalStateException("LoadBalancer ExchangeFilterFunction not available.");
            }
        }
    }

    T getDelegate() {
        return this.delegate;
    }
}

