/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.impl.jdbc.UTF8Reader;

public final class ReaderToAscii
extends InputStream {
    private final Reader data;
    private char[] conv;
    private boolean closed;

    public ReaderToAscii(Reader reader) {
        this.data = reader;
        if (!(reader instanceof UTF8Reader)) {
            this.conv = new char[256];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        int n = this.data.read();
        if (n == -1) {
            return -1;
        }
        if (n <= 255) {
            return n & 0xFF;
        }
        return 63;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.data instanceof UTF8Reader) {
            return ((UTF8Reader)this.data).readAsciiInto(byArray, n, n2);
        }
        if (n2 > this.conv.length) {
            n2 = this.conv.length;
        }
        if ((n2 = this.data.read(this.conv, 0, n2)) == -1) {
            return -1;
        }
        for (int i = 0; i < n2; ++i) {
            char c = this.conv[i];
            int n3 = c <= '\u00ff' ? (int)((byte)c) : 63;
            byArray[n++] = n3;
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        return this.data.skip(l);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.data.close();
        }
    }
}

