/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.backoff;

import java.util.Random;
import java.util.function.Supplier;
import org.springframework.retry.backoff.BackOffInterruptedException;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.retry.backoff.StatelessBackOffPolicy;
import org.springframework.retry.backoff.ThreadWaitSleeper;
import org.springframework.util.Assert;

public class UniformRandomBackOffPolicy
extends StatelessBackOffPolicy
implements SleepingBackOffPolicy<UniformRandomBackOffPolicy> {
    private static final long DEFAULT_BACK_OFF_MIN_PERIOD = 500L;
    private static final long DEFAULT_BACK_OFF_MAX_PERIOD = 1500L;
    private Supplier<Long> minBackOffPeriod = () -> 500L;
    private Supplier<Long> maxBackOffPeriod = () -> 1500L;
    private final Random random = new Random(System.currentTimeMillis());
    private Sleeper sleeper = new ThreadWaitSleeper();

    @Override
    public UniformRandomBackOffPolicy withSleeper(Sleeper sleeper) {
        UniformRandomBackOffPolicy res = new UniformRandomBackOffPolicy();
        res.minBackOffPeriodSupplier(this.minBackOffPeriod);
        res.maxBackOffPeriodSupplier(this.maxBackOffPeriod);
        res.setSleeper(sleeper);
        return res;
    }

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public void setMinBackOffPeriod(long backOffPeriod) {
        this.minBackOffPeriod = () -> backOffPeriod > 0L ? backOffPeriod : 1L;
    }

    public void minBackOffPeriodSupplier(Supplier<Long> backOffPeriodSupplier) {
        Assert.notNull(backOffPeriodSupplier, (String)"'backOffPeriodSupplier' cannot be null");
        this.minBackOffPeriod = backOffPeriodSupplier;
    }

    public long getMinBackOffPeriod() {
        return this.minBackOffPeriod.get();
    }

    public void setMaxBackOffPeriod(long backOffPeriod) {
        this.maxBackOffPeriod = () -> backOffPeriod > 0L ? backOffPeriod : 1L;
    }

    public void maxBackOffPeriodSupplier(Supplier<Long> backOffPeriodSupplier) {
        Assert.notNull(backOffPeriodSupplier, (String)"'backOffPeriodSupplier' cannot be null");
        this.maxBackOffPeriod = backOffPeriodSupplier;
    }

    public long getMaxBackOffPeriod() {
        return this.maxBackOffPeriod.get();
    }

    @Override
    protected void doBackOff() throws BackOffInterruptedException {
        try {
            Long min = this.minBackOffPeriod.get();
            long delta = this.maxBackOffPeriod.get() == this.minBackOffPeriod.get() ? 0L : (long)this.random.nextInt((int)(this.maxBackOffPeriod.get() - min));
            this.sleeper.sleep(min + delta);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BackOffInterruptedException("Thread interrupted while sleeping", e);
        }
    }

    public String toString() {
        return "RandomBackOffPolicy[backOffPeriod=" + this.minBackOffPeriod + ", " + this.maxBackOffPeriod + "]";
    }
}

