/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.Internal;
import org.hibernate.property.access.internal.AbstractSetterMethodSerialForm;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.SetterMethodImpl;

@Internal
public class EnhancedSetterMethodImpl
extends SetterMethodImpl {
    private final String propertyName;
    private final int enhancementState;

    public EnhancedSetterMethodImpl(Class<?> containerClass, String propertyName, Method setterMethod) {
        super(containerClass, propertyName, setterMethod);
        this.propertyName = propertyName;
        this.enhancementState = AccessStrategyHelper.determineEnhancementState(containerClass, setterMethod.getReturnType());
    }

    @Override
    public void set(Object target, Object value) {
        super.set(target, value);
        AccessStrategyHelper.handleEnhancedInjection(target, value, this.enhancementState, this.propertyName);
    }

    private Object writeReplace() {
        return new SerialForm(this.getContainerClass(), this.propertyName, this.getMethod());
    }

    private static class SerialForm
    extends AbstractSetterMethodSerialForm
    implements Serializable {
        private SerialForm(Class<?> containerClass, String propertyName, Method method) {
            super(containerClass, propertyName, method);
        }

        private Object readResolve() {
            return new EnhancedSetterMethodImpl(this.getContainerClass(), this.getPropertyName(), this.resolveMethod());
        }
    }
}

