/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Remove;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.BindableType;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.QueryParameter;

@Incubating
public interface SelectionQuery<R>
extends CommonQueryContract {
    public List<R> list();

    default public List<R> getResultList() {
        return this.list();
    }

    public ScrollableResults<R> scroll();

    public ScrollableResults<R> scroll(ScrollMode var1);

    default public Stream<R> getResultStream() {
        return this.stream();
    }

    default public Stream<R> stream() {
        return this.getResultStream();
    }

    public R uniqueResult();

    public R getSingleResult();

    public R getSingleResultOrNull();

    public Optional<R> uniqueResultOptional();

    @Override
    public SelectionQuery<R> setHint(String var1, Object var2);

    @Override
    public SelectionQuery<R> setFlushMode(FlushModeType var1);

    @Override
    public SelectionQuery<R> setHibernateFlushMode(FlushMode var1);

    @Override
    public SelectionQuery<R> setTimeout(int var1);

    @Override
    public SelectionQuery<R> setComment(String var1);

    public Integer getFetchSize();

    public SelectionQuery<R> setFetchSize(int var1);

    public boolean isReadOnly();

    public SelectionQuery<R> setReadOnly(boolean var1);

    public int getMaxResults();

    public SelectionQuery<R> setMaxResults(int var1);

    public int getFirstResult();

    public SelectionQuery<R> setFirstResult(int var1);

    public CacheMode getCacheMode();

    public CacheStoreMode getCacheStoreMode();

    public CacheRetrieveMode getCacheRetrieveMode();

    public SelectionQuery<R> setCacheMode(CacheMode var1);

    public SelectionQuery<R> setCacheStoreMode(CacheStoreMode var1);

    public SelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode var1);

    public boolean isCacheable();

    public SelectionQuery<R> setCacheable(boolean var1);

    public String getCacheRegion();

    public SelectionQuery<R> setCacheRegion(String var1);

    public LockOptions getLockOptions();

    public LockModeType getLockMode();

    public SelectionQuery<R> setLockMode(LockModeType var1);

    public LockMode getHibernateLockMode();

    public SelectionQuery<R> setHibernateLockMode(LockMode var1);

    public SelectionQuery<R> setLockMode(String var1, LockMode var2);

    @Deprecated(since="6.2")
    @Remove
    public SelectionQuery<R> setAliasSpecificLockMode(String var1, LockMode var2);

    public SelectionQuery<R> setFollowOnLocking(boolean var1);

    @Override
    public SelectionQuery<R> setParameter(String var1, Object var2);

    @Override
    public <P> SelectionQuery<R> setParameter(String var1, P var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameter(String var1, P var2, BindableType<P> var3);

    @Override
    public SelectionQuery<R> setParameter(String var1, Instant var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameter(String var1, Calendar var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameter(String var1, Date var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameter(int var1, Object var2);

    @Override
    public <P> SelectionQuery<R> setParameter(int var1, P var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameter(int var1, P var2, BindableType<P> var3);

    @Override
    public SelectionQuery<R> setParameter(int var1, Instant var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameter(int var1, Date var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameter(int var1, Calendar var2, TemporalType var3);

    @Override
    public <T> SelectionQuery<R> setParameter(QueryParameter<T> var1, T var2);

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> var1, P var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> var1, P var2, BindableType<P> var3);

    @Override
    public <T> SelectionQuery<R> setParameter(Parameter<T> var1, T var2);

    @Override
    public SelectionQuery<R> setParameter(Parameter<Calendar> var1, Calendar var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameter(Parameter<Date> var1, Date var2, TemporalType var3);

    @Override
    public SelectionQuery<R> setParameterList(String var1, Collection var2);

    @Override
    public <P> SelectionQuery<R> setParameterList(String var1, Collection<? extends P> var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(String var1, Collection<? extends P> var2, BindableType<P> var3);

    @Override
    public SelectionQuery<R> setParameterList(String var1, Object[] var2);

    @Override
    public <P> SelectionQuery<R> setParameterList(String var1, P[] var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(String var1, P[] var2, BindableType<P> var3);

    @Override
    public SelectionQuery<R> setParameterList(int var1, Collection var2);

    @Override
    public <P> SelectionQuery<R> setParameterList(int var1, Collection<? extends P> var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(int var1, Collection<? extends P> var2, BindableType<P> var3);

    @Override
    public SelectionQuery<R> setParameterList(int var1, Object[] var2);

    @Override
    public <P> SelectionQuery<R> setParameterList(int var1, P[] var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(int var1, P[] var2, BindableType<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2);

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> var1, Collection<? extends P> var2, BindableType<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> var1, P[] var2);

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> var1, P[] var2, Class<P> var3);

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> var1, P[] var2, BindableType<P> var3);

    @Override
    public SelectionQuery<R> setProperties(Object var1);

    @Override
    public SelectionQuery<R> setProperties(Map var1);
}

