/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.TemporalType;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.BindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class BindingTypeHelper {
    public static final BindingTypeHelper INSTANCE = new BindingTypeHelper();

    private BindingTypeHelper() {
    }

    public <T> BindableType<T> resolveTemporalPrecision(TemporalType precision, BindableType<T> declaredParameterType, SessionFactoryImplementor sessionFactory) {
        if (precision != null) {
            SqmExpressible<T> sqmExpressible = declaredParameterType.resolveExpressible(sessionFactory);
            if (!JavaTypeHelper.isTemporal(sqmExpressible.getExpressibleJavaType())) {
                throw new UnsupportedOperationException("Cannot treat non-temporal parameter type with temporal precision");
            }
            TemporalJavaType temporalJtd = (TemporalJavaType)sqmExpressible.getExpressibleJavaType();
            if (temporalJtd.getPrecision() != precision) {
                TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
                return typeConfiguration.getBasicTypeRegistry().resolve(temporalJtd.resolveTypeForPrecision(precision, typeConfiguration), TemporalJavaType.resolveJdbcTypeCode(precision));
            }
        }
        return declaredParameterType;
    }

    public JdbcMapping resolveBindType(Object value, JdbcMapping baseType, TypeConfiguration typeConfiguration) {
        if (value == null || !JavaTypeHelper.isTemporal(baseType.getJdbcJavaType())) {
            return baseType;
        }
        Class<?> javaType = value.getClass();
        TemporalType temporalType = ((TemporalJavaType)baseType.getJdbcJavaType()).getPrecision();
        switch (temporalType) {
            case TIMESTAMP: {
                return (JdbcMapping)((Object)this.resolveTimestampTemporalTypeVariant(javaType, (BindableType)((Object)baseType), typeConfiguration));
            }
            case DATE: {
                return (JdbcMapping)((Object)this.resolveDateTemporalTypeVariant(javaType, (BindableType)((Object)baseType), typeConfiguration));
            }
            case TIME: {
                return (JdbcMapping)((Object)this.resolveTimeTemporalTypeVariant(javaType, (BindableType)((Object)baseType), typeConfiguration));
            }
        }
        throw new IllegalArgumentException("Unexpected TemporalType [" + temporalType + "]; expecting TIMESTAMP, DATE or TIME");
    }

    public BindableType resolveTimestampTemporalTypeVariant(Class javaType, BindableType baseType, TypeConfiguration typeConfiguration) {
        if (baseType.getBindableJavaType().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.TIMESTAMP);
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT);
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.ZONED_DATE_TIME);
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIMESTAMP");
    }

    public BindableType<?> resolveDateTemporalTypeVariant(Class<?> javaType, BindableType<?> baseType, TypeConfiguration typeConfiguration) {
        if (baseType.getBindableJavaType().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR_DATE);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DATE);
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INSTANT);
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.ZONED_DATE_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#DATE");
    }

    public BindableType resolveTimeTemporalTypeVariant(Class javaType, BindableType baseType, TypeConfiguration typeConfiguration) {
        if (Calendar.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.CALENDAR_TIME);
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.TIME);
        }
        if (LocalTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LOCAL_TIME);
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.OFFSET_TIME);
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIME");
    }
}

