/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.shared.common.i18n.MessageService;

public class OptTraceViewer
implements OptionalTool {
    @Override
    public void loadTool(String ... stringArray) throws SQLException {
        if (stringArray == null || stringArray.length != 1) {
            throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
        }
        String string = stringArray[0];
        String string2 = "create view planCost as\nselect *\nfrom table\n(\n    planCost\n    (\n        'FILE_URL',\n        'planCost',\n        asList( 'stmtText', 'stmtID', 'qbID' ),\n        asList( 'pcComplete', 'pcSummary', 'pcType', 'ceEstimatedCost', 'ceEstimatedRowCount' )\n     )\n) v\n".replace("FILE_URL", string);
        Connection connection = this.getDerbyConnection();
        this.executeDDL(connection, "create type ArrayList external name 'java.util.ArrayList' language java");
        this.executeDDL(connection, "create function asList( cell varchar( 32672 ) ... ) returns ArrayList\nlanguage java parameter style derby no sql\nexternal name 'org.apache.derby.vti.XmlVTI.asList'\n");
        this.executeDDL(connection, "create function planCost\n(\n    xmlResourceName varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    parentTags ArrayList,\n    childTags ArrayList\n)\nreturns table\n(\n    text varchar( 32672 ),\n    stmtID    int,\n    qbID   int,\n    complete  boolean,\n    summary   varchar( 32672 ),\n    type        varchar( 50 ),\n    estimatedCost        double,\n    estimatedRowCount    bigint\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTI'\n");
        this.executeDDL(connection, string2);
    }

    @Override
    public void unloadTool(String ... stringArray) throws SQLException {
        Connection connection = this.getDerbyConnection();
        this.executeDDL(connection, "drop view planCost");
        this.executeDDL(connection, "drop function planCost");
        this.executeDDL(connection, "drop function asList");
        this.executeDDL(connection, "drop type ArrayList restrict");
    }

    private Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private void executeDDL(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage(), throwable);
    }

    private SQLException wrap(String string) {
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2);
    }
}

