/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class ChainedPropertyAccessImpl
implements PropertyAccess,
Getter,
Setter {
    private final PropertyAccess[] propertyAccesses;

    public ChainedPropertyAccessImpl(PropertyAccess ... propertyAccesses) {
        this.propertyAccesses = propertyAccesses;
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.propertyAccesses[0].getPropertyAccessStrategy();
    }

    @Override
    public Getter getGetter() {
        return this;
    }

    @Override
    public Setter getSetter() {
        return this;
    }

    @Override
    public Object get(Object owner) {
        for (int i = 0; i < this.propertyAccesses.length; ++i) {
            owner = this.propertyAccesses[i].getGetter().get(owner);
        }
        return owner;
    }

    @Override
    public Object getForInsert(Object owner, Map mergeMap, SharedSessionContractImplementor session) {
        for (int i = 0; i < this.propertyAccesses.length; ++i) {
            owner = this.propertyAccesses[i].getGetter().getForInsert(owner, mergeMap, session);
        }
        return owner;
    }

    @Override
    public void set(Object target, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> getReturnTypeClass() {
        return this.propertyAccesses[this.propertyAccesses.length - 1].getGetter().getReturnTypeClass();
    }

    @Override
    public Type getReturnType() {
        return this.propertyAccesses[this.propertyAccesses.length - 1].getGetter().getReturnType();
    }

    @Override
    public Member getMember() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Method getMethod() {
        return null;
    }
}

