/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.observation.ClientHttpObservationDocumentation;
import org.springframework.http.client.observation.ClientRequestObservationContext;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultClientRequestObservationConvention
implements ClientRequestObservationConvention {
    private static final String DEFAULT_NAME = "http.client.requests";
    private static final Pattern PATTERN_BEFORE_PATH = Pattern.compile("^https?://[^/]+/");
    private static final KeyValue URI_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)"none");
    private static final KeyValue METHOD_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)"none");
    private static final KeyValue STATUS_IO_ERROR = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"IO_ERROR");
    private static final KeyValue STATUS_CLIENT_ERROR = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)"CLIENT_ERROR");
    private static final KeyValue HTTP_OUTCOME_SUCCESS = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue HTTP_OUTCOME_UNKNOWN = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)"UNKNOWN");
    private static final KeyValue CLIENT_NAME_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.CLIENT_NAME, (String)"none");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue HTTP_URL_NONE = KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)"none");
    private final String name;

    public DefaultClientRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultClientRequestObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getContextualName(ClientRequestObservationContext context) {
        ClientHttpRequest request = (ClientHttpRequest)context.getCarrier();
        return request != null ? "http " + request.getMethod().name().toLowerCase(Locale.ROOT) : null;
    }

    public KeyValues getLowCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.clientName(context), this.exception(context), this.method(context), this.outcome(context), this.status(context), this.uri(context)});
    }

    protected KeyValue uri(ClientRequestObservationContext context) {
        if (context.getUriTemplate() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, (String)DefaultClientRequestObservationConvention.extractPath(context.getUriTemplate()));
        }
        return URI_NONE;
    }

    private static String extractPath(String uriTemplate) {
        String path = PATTERN_BEFORE_PATH.matcher(uriTemplate).replaceFirst("");
        return path.startsWith("/") ? path : "/" + path;
    }

    protected KeyValue method(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, (String)((ClientHttpRequest)context.getCarrier()).getMethod().name());
        }
        return METHOD_NONE;
    }

    protected KeyValue status(ClientRequestObservationContext context) {
        ClientHttpResponse response = (ClientHttpResponse)context.getResponse();
        if (response == null) {
            return STATUS_CLIENT_ERROR;
        }
        try {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, (String)String.valueOf(response.getStatusCode().value()));
        }
        catch (IOException ex) {
            return STATUS_IO_ERROR;
        }
    }

    protected KeyValue clientName(ClientRequestObservationContext context) {
        if (context.getCarrier() != null && ((ClientHttpRequest)context.getCarrier()).getURI().getHost() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.CLIENT_NAME, (String)((ClientHttpRequest)context.getCarrier()).getURI().getHost());
        }
        return CLIENT_NAME_NONE;
    }

    protected KeyValue exception(ClientRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(StringUtils.hasText((String)simpleName) ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ClientRequestObservationContext context) {
        if (context.getResponse() != null) {
            try {
                return HttpOutcome.forStatus(((ClientHttpResponse)context.getResponse()).getStatusCode());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return HTTP_OUTCOME_UNKNOWN;
    }

    public KeyValues getHighCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.requestUri(context)});
    }

    protected KeyValue requestUri(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of((KeyName)ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, (String)((ClientHttpRequest)context.getCarrier()).getURI().toASCIIString());
        }
        return HTTP_URL_NONE;
    }

    static class HttpOutcome {
        HttpOutcome() {
        }

        static KeyValue forStatus(HttpStatusCode statusCode) {
            if (statusCode.is2xxSuccessful()) {
                return HTTP_OUTCOME_SUCCESS;
            }
            if (statusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)statusCode;
                return KeyValue.of((KeyName)ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, (String)status.series().name());
            }
            return HTTP_OUTCOME_UNKNOWN;
        }
    }
}

