/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.AbstractStep;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.TransactionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operation
extends AbstractStep {
    private static final Logger logger = LoggerFactory.getLogger(Operation.class);
    private static final String DEFAULT_FORMAT = "flat";
    protected String _type = "CLEAN_INSERT";
    private String _format;
    private List<File> _sources = new ArrayList<File>();
    private boolean _combine = false;
    private boolean _transaction = false;
    private DatabaseOperation _operation;
    private boolean _forwardOperation = true;
    private String _nullToken;

    public File[] getSrc() {
        return this._sources.toArray(new File[this._sources.size()]);
    }

    public void setSrc(File[] sources) {
        this._sources.clear();
        this._sources.addAll(Arrays.asList(sources));
    }

    public void setSrc(File src) {
        this._sources.clear();
        this._sources.add(src);
    }

    public void addConfiguredFileset(FileSet fileSet) {
        DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
        for (String file : scanner.getIncludedFiles()) {
            this._sources.add(new File(scanner.getBasedir(), file));
        }
    }

    public String getFormat() {
        return this._format != null ? this._format : DEFAULT_FORMAT;
    }

    public void setFormat(String format) {
        logger.debug("setFormat(format={}) - start", (Object)format);
        this.checkDataFormat(format);
        this._format = format;
    }

    public boolean isCombine() {
        return this._combine;
    }

    public void setCombine(boolean combine) {
        this._combine = combine;
    }

    public boolean isTransaction() {
        return this._transaction;
    }

    public void setTransaction(boolean transaction) {
        this._transaction = transaction;
    }

    public String getNullToken() {
        return this._nullToken;
    }

    public void setNullToken(String nullToken) {
        this._nullToken = nullToken;
    }

    public DatabaseOperation getDbOperation() {
        return this._operation;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        logger.debug("setType(type={}) - start", (Object)type);
        if ("UPDATE".equals(type)) {
            this._operation = DatabaseOperation.UPDATE;
            this._forwardOperation = true;
        } else if ("INSERT".equals(type)) {
            this._operation = DatabaseOperation.INSERT;
            this._forwardOperation = true;
        } else if ("REFRESH".equals(type)) {
            this._operation = DatabaseOperation.REFRESH;
            this._forwardOperation = true;
        } else if ("DELETE".equals(type)) {
            this._operation = DatabaseOperation.DELETE;
            this._forwardOperation = false;
        } else if ("DELETE_ALL".equals(type)) {
            this._operation = DatabaseOperation.DELETE_ALL;
            this._forwardOperation = false;
        } else if ("CLEAN_INSERT".equals(type)) {
            this._operation = DatabaseOperation.CLEAN_INSERT;
            this._forwardOperation = false;
        } else if ("NONE".equals(type)) {
            this._operation = DatabaseOperation.NONE;
            this._forwardOperation = true;
        } else if ("MSSQL_CLEAN_INSERT".equals(type)) {
            this._operation = InsertIdentityOperation.CLEAN_INSERT;
            this._forwardOperation = false;
        } else if ("MSSQL_INSERT".equals(type)) {
            this._operation = InsertIdentityOperation.INSERT;
            this._forwardOperation = true;
        } else if ("MSSQL_REFRESH".equals(type)) {
            this._operation = InsertIdentityOperation.REFRESH;
            this._forwardOperation = true;
        } else {
            throw new IllegalArgumentException("Type must be one of: UPDATE, INSERT, REFRESH, DELETE, DELETE_ALL, CLEAN_INSERT, MSSQL_INSERT,  or MSSQL_REFRESH but was: " + type);
        }
        this._type = type;
    }

    @Override
    public void execute(IDatabaseConnection connection) throws DatabaseUnitException {
        logger.debug("execute(connection={}) - start", (Object)connection);
        if (this._operation == null) {
            throw new DatabaseUnitException("Operation.execute(): setType(String) must be called before execute()!");
        }
        if (this._operation == DatabaseOperation.NONE) {
            return;
        }
        if (this._sources.size() == 0) {
            throw new DatabaseUnitException("Operation.execute(): must call setSrc(File), addSrc(File), or setSources(File[]) before execute()!");
        }
        try {
            IDataSet dataset;
            boolean useForwardOnly;
            DatabaseOperation operation = this._transaction ? new TransactionOperation(this._operation) : this._operation;
            boolean bl = useForwardOnly = this._forwardOperation && !this.isOrdered();
            if (this._sources.size() > 1) {
                IDataSet[] datasets = new IDataSet[this._sources.size()];
                for (int i = 0; i < this._sources.size(); ++i) {
                    datasets[i] = this.getSrcDataSet(this._sources.get(i), this.getFormat(), useForwardOnly);
                }
                dataset = new CompositeDataSet(datasets, this._combine);
            } else {
                dataset = this.getSrcDataSet(this._sources.get(0), this.getFormat(), useForwardOnly);
            }
            if (this._nullToken != null) {
                dataset = new ReplacementDataSet(dataset);
                ((ReplacementDataSet)dataset).addReplacementObject(this._nullToken, null);
            }
            if (this.isOrdered()) {
                DatabaseSequenceFilter databaseSequenceFilter = new DatabaseSequenceFilter(connection);
                dataset = new FilteredDataSet(databaseSequenceFilter, dataset);
            }
            operation.execute(connection, dataset);
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    @Override
    public String getLogMessage() {
        StringBuffer result = new StringBuffer();
        result.append("Executing operation: " + this._type);
        result.append("\n          on   files: [ ");
        for (File f : this._sources) {
            result.append(f.getAbsolutePath() + " ");
        }
        result.append("]");
        result.append("\n          with format: " + this._format);
        return result.toString();
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Operation: ");
        result.append(" type=").append(this._type);
        result.append(", format=").append(this._format);
        result.append(", sources=[ ");
        for (File f : this._sources) {
            result.append(f.getAbsolutePath() + " ");
        }
        result.append("]");
        result.append(", operation=").append(this._operation);
        result.append(", nullToken=").append(this._nullToken);
        result.append(", ordered=").append(super.isOrdered());
        return result.toString();
    }
}

