/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;

public class GroupFirstMessageReference
implements MessageReference {
    private final MessageReference messageReference;
    private final SimpleString key;
    private volatile Message message;
    private volatile PagingStore owner;

    public GroupFirstMessageReference(SimpleString key, MessageReference messageReference) {
        this.messageReference = messageReference;
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessage() {
        if (this.message == null) {
            GroupFirstMessageReference groupFirstMessageReference = this;
            synchronized (groupFirstMessageReference) {
                if (this.message == null) {
                    this.message = this.messageReference.getMessage().copy();
                    this.message.putBooleanProperty(this.key, true).reencode();
                }
            }
        }
        return this.message;
    }

    @Override
    public boolean isPaged() {
        return this.messageReference.isPaged();
    }

    @Override
    public long getMessageID() {
        return this.messageReference.getMessageID();
    }

    @Override
    public boolean isDurable() {
        return this.messageReference.isDurable();
    }

    @Override
    public SimpleString getLastValueProperty() {
        return this.messageReference.getLastValueProperty();
    }

    @Override
    public void onDelivery(Consumer<? super MessageReference> callback) {
        this.messageReference.onDelivery(callback);
    }

    @Override
    public int getMessageMemoryEstimate() {
        return this.messageReference.getMessageMemoryEstimate();
    }

    @Override
    public <T> T getProtocolData(Class<T> typeClass) {
        return this.messageReference.getProtocolData(typeClass);
    }

    @Override
    public <T> void setProtocolData(Class<T> typeClass, T data) {
        this.messageReference.setProtocolData(typeClass, data);
    }

    @Override
    public MessageReference copy(Queue queue) {
        return this.messageReference.copy(queue);
    }

    @Override
    public long getScheduledDeliveryTime() {
        return this.messageReference.getScheduledDeliveryTime();
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.messageReference.setScheduledDeliveryTime(scheduledDeliveryTime);
    }

    @Override
    public int getDeliveryCount() {
        return this.messageReference.getDeliveryCount();
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.messageReference.setDeliveryCount(deliveryCount);
    }

    @Override
    public void setPersistedCount(int deliveryCount) {
        this.messageReference.setPersistedCount(deliveryCount);
    }

    @Override
    public int getPersistedCount() {
        return this.messageReference.getPersistedCount();
    }

    @Override
    public void incrementDeliveryCount() {
        this.messageReference.incrementDeliveryCount();
    }

    @Override
    public void decrementDeliveryCount() {
        this.messageReference.decrementDeliveryCount();
    }

    @Override
    public Queue getQueue() {
        return this.messageReference.getQueue();
    }

    @Override
    public void acknowledge() throws Exception {
        this.messageReference.acknowledge();
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.messageReference.acknowledge(tx);
    }

    @Override
    public void acknowledge(Transaction tx, ServerConsumer consumer) throws Exception {
        this.messageReference.acknowledge(tx, consumer);
    }

    @Override
    public void acknowledge(Transaction tx, AckReason reason, ServerConsumer consumer) throws Exception {
        this.messageReference.acknowledge(tx, reason, consumer);
    }

    @Override
    public void emptyConsumerID() {
        this.messageReference.emptyConsumerID();
    }

    @Override
    public void setConsumerId(long consumerID) {
        this.messageReference.setConsumerId(consumerID);
    }

    @Override
    public boolean hasConsumerId() {
        return this.messageReference.hasConsumerId();
    }

    @Override
    public long getConsumerId() {
        return this.messageReference.getConsumerId();
    }

    @Override
    public void handled() {
        this.messageReference.handled();
    }

    @Override
    public void setInDelivery(boolean inDelivery) {
        this.messageReference.setInDelivery(inDelivery);
    }

    @Override
    public boolean isInDelivery() {
        return this.messageReference.isInDelivery();
    }

    @Override
    public void setAlreadyAcked() {
        this.messageReference.setAlreadyAcked();
    }

    @Override
    public boolean isAlreadyAcked() {
        return this.messageReference.isAlreadyAcked();
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.messageReference.getPersistentSize();
    }

    @Override
    public long getSequence() {
        return this.messageReference.getSequence();
    }

    @Override
    public void setSequence(long nextSequence) {
        this.messageReference.setSequence(nextSequence);
    }
}

