/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.AccessType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;
import org.hibernate.property.access.spi.SetterMethodImpl;

public class PropertyAccessMixedImpl
implements PropertyAccess {
    private final PropertyAccessStrategy strategy;
    private final Getter getter;
    private final Setter setter;

    public PropertyAccessMixedImpl(PropertyAccessStrategy strategy, Class<?> containerJavaType, String propertyName) {
        this.strategy = strategy;
        AccessType propertyAccessType = AccessStrategyHelper.getAccessType(containerJavaType, propertyName);
        switch (propertyAccessType) {
            case FIELD: {
                Field field = AccessStrategyHelper.fieldOrNull(containerJavaType, propertyName);
                if (field == null) {
                    throw new PropertyAccessBuildingException("Could not locate field for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                this.getter = this.fieldGetter(containerJavaType, propertyName, field);
                this.setter = this.fieldSetter(containerJavaType, propertyName, field);
                break;
            }
            case PROPERTY: {
                Method getterMethod = ReflectHelper.getterMethodOrNull(containerJavaType, propertyName);
                if (getterMethod == null) {
                    throw new PropertyAccessBuildingException("Could not locate getter for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
                }
                Method setterMethod = ReflectHelper.findSetterMethod(containerJavaType, propertyName, getterMethod.getReturnType());
                this.getter = this.propertyGetter(containerJavaType, propertyName, getterMethod);
                this.setter = this.propertySetter(containerJavaType, propertyName, setterMethod);
                break;
            }
            default: {
                throw new PropertyAccessBuildingException("Invalid access type " + propertyAccessType + " for property named [" + containerJavaType.getName() + "#" + propertyName + "]");
            }
        }
    }

    protected Getter fieldGetter(Class<?> containerJavaType, String propertyName, Field field) {
        return new GetterFieldImpl(containerJavaType, propertyName, field);
    }

    protected Setter fieldSetter(Class<?> containerJavaType, String propertyName, Field field) {
        return new SetterFieldImpl(containerJavaType, propertyName, field);
    }

    protected Getter propertyGetter(Class<?> containerJavaType, String propertyName, Method method) {
        return new GetterMethodImpl(containerJavaType, propertyName, method);
    }

    protected Setter propertySetter(Class<?> containerJavaType, String propertyName, Method method) {
        return method == null ? null : new SetterMethodImpl(containerJavaType, propertyName, method);
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this.getter;
    }

    @Override
    public Setter getSetter() {
        return this.setter;
    }
}

