/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BaseMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.RelayHeader;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.Relayer3;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteStatus;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Delayer;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.Headers;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.UUID;

@MBean(description="RELAY3 protocol")
public class RELAY3
extends RELAY {
    @ManagedAttribute(description="A cache maintaining a list of sites that are up")
    protected final SiteStatus site_status = new SiteStatus();
    @Property(description="Number of millis by which SITE_UNREACHABLE events are delayed; see RelayTest.testFailover() for details")
    protected long delay_site_unreachable_events = 3000L;
    protected Delayer<String> site_unreachable_delayer;
    protected UNICAST3 unicast;

    public SiteStatus siteStatus() {
        return this.site_status;
    }

    public long delaySiteUnreachableEvents() {
        return this.delay_site_unreachable_events;
    }

    public RELAY3 delaySiteUnreachableEvents(long t) {
        this.delay_site_unreachable_events = t;
        if (this.site_unreachable_delayer != null) {
            this.site_unreachable_delayer.timeout(t);
        }
        return this;
    }

    @Override
    public void configure() throws Exception {
        super.configure();
        JChannel ch = this.getProtocolStack().getChannel();
        ch.addAddressGenerator(new AddressGenerator(){

            @Override
            public Address generateAddress() {
                return this.generateAddress(null);
            }

            @Override
            public Address generateAddress(String name) {
                SiteUUID uuid = new SiteUUID(UUID.randomUUID(), name, RELAY3.this.site);
                if (RELAY3.this.can_become_site_master) {
                    uuid.setFlag((short)2);
                }
                return uuid;
            }
        });
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.site_unreachable_delayer = new Delayer(this.delay_site_unreachable_events);
        this.unicast = (UNICAST3)ProtocolStack.findProtocol(this.up_prot, false, UNICAST3.class);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.site_unreachable_delayer.clear();
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printTopology(boolean all_sites) {
        if (!all_sites) {
            return this.printLocalTopology();
        }
        return this.topo.print();
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printLocalTopology() {
        return this.topo.print(this.site);
    }

    @Override
    public Object down(Message msg) {
        if (msg.src() == null) {
            msg.src(this.local_addr);
        }
        return this.process(true, msg);
    }

    @Override
    public Object up(Message msg) {
        Message copy = msg;
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        if (hdr != null) {
            switch (hdr.type) {
                case 2: {
                    Set<String> tmp_sites = hdr.getSites();
                    if (tmp_sites != null) {
                        for (String s : tmp_sites) {
                            this.triggerSiteUnreachableEvent(new SiteMaster(s));
                        }
                    }
                    return null;
                }
                case 3: {
                    Address unreachable_mbr = (Address)msg.getObject();
                    this.triggerMemberUnreachableEvent(unreachable_mbr);
                    return null;
                }
            }
            copy = this.copy(msg).dest(hdr.final_dest).src(hdr.original_sender).putHeader(this.id, hdr);
        }
        return this.process(false, copy);
    }

    @Override
    public void up(MessageBatch batch) {
        HashSet<String> unreachable_sites = null;
        Iterator<Message> it = batch.iterator();
        block4: while (it.hasNext()) {
            Message msg;
            Message copy = msg = it.next();
            RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
            it.remove();
            if (hdr != null) {
                switch (hdr.type) {
                    case 2: {
                        Set<String> tmp_sites = hdr.getSites();
                        if (tmp_sites == null) continue block4;
                        if (unreachable_sites == null) {
                            unreachable_sites = new HashSet<String>();
                        }
                        unreachable_sites.addAll(tmp_sites);
                        continue block4;
                    }
                    case 3: {
                        Address unreachable_mbr = (Address)msg.getObject();
                        this.triggerMemberUnreachableEvent(unreachable_mbr);
                        continue block4;
                    }
                }
                copy = this.copy(msg).dest(hdr.final_dest).src(hdr.original_sender).putHeader(this.id, hdr);
            }
            this.process(false, copy);
        }
        if (unreachable_sites != null) {
            for (String s : unreachable_sites) {
                this.triggerSiteUnreachableEvent(new SiteMaster(s));
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void sendResponseTo(Address dest, boolean all_sites) {
        if (all_sites) {
            this.sendResponsesForAllSites(dest);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("%s: sending topo response to %s: %s", this.local_addr, dest, this.view);
        }
        RelayHeader hdr = new RelayHeader(7, dest, this.local_addr).addToSites(this.site);
        Message rsp = new ObjectMessage(dest, this.view).putHeader(this.id, hdr).setFlag(Message.TransientFlag.DONT_LOOPBACK);
        this.down(rsp);
    }

    protected void sendResponsesForAllSites(Address dest) {
        for (Map.Entry<String, View> e : this.topo.cache().entrySet()) {
            String site_name = e.getKey();
            View v = e.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug("%s: sending topo response to %s: %s", this.local_addr, dest, this.view);
            }
            RelayHeader hdr = new RelayHeader(7, dest, this.local_addr).addToSites(site_name);
            Message rsp = new ObjectMessage(dest, v).putHeader(this.id, hdr).setFlag(Message.TransientFlag.DONT_LOOPBACK);
            this.down(rsp);
        }
    }

    @Override
    public void handleView(View view) {
        View old_view = this.view;
        this.view = view;
        this.members = view.getMembers();
        int max_num_site_masters = this.max_site_masters;
        if (this.site_masters_ratio > 0.0) {
            max_num_site_masters = (int)Math.max((double)this.max_site_masters, this.site_masters_ratio * (double)view.size());
        }
        List old_site_masters = this.site_masters;
        List<Address> new_site_masters = RELAY3.determineSiteMasters(view, max_num_site_masters);
        boolean become_site_master = new_site_masters.contains(this.local_addr) && (old_site_masters == null || !old_site_masters.contains(this.local_addr));
        boolean cease_site_master = old_site_masters != null && old_site_masters.contains(this.local_addr) && !new_site_masters.contains(this.local_addr);
        this.site_masters = new_site_masters;
        if (!this.site_masters.isEmpty() && ((Address)this.site_masters.get(0)).equals(this.local_addr)) {
            this.broadcast_route_notifications = true;
        }
        if (become_site_master) {
            this.is_site_master = true;
            String bridge_name = "_" + NameCache.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            this.relayer = new Relayer3(this, this.log);
            Relayer3 tmp = (Relayer3)this.relayer;
            long start = System.currentTimeMillis();
            if (this.async_relay_creation) {
                this.timer.execute(() -> this.startRelayer(tmp, bridge_name).handleAsync((r, t) -> this.handleRelayerStarted(this.relayer, start, (Object)r, (Throwable)t)));
            } else {
                this.startRelayer(tmp, bridge_name).handleAsync((r, t) -> this.handleRelayerStarted(this.relayer, start, (Object)r, (Throwable)t));
            }
            this.notifySiteMasterListener(true);
        } else if (cease_site_master) {
            this.is_site_master = false;
            this.notifySiteMasterListener(false);
            this.log.trace(String.valueOf(this.local_addr) + ": ceased to be site master; closing bridges");
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
        this.suppress_log_no_route.removeExpired(this.suppress_time_no_route_errors);
        this.topo.put(this.site, view);
        if (!this.topo.globalViews()) {
            return;
        }
        if (this.is_site_master) {
            if (!become_site_master) {
                this.sendResponseTo(new SiteMaster(null), false);
            }
        } else if (old_view == null && !cease_site_master) {
            this.topo.refresh(this.site, true);
        }
    }

    protected <T> Object handleRelayerStarted(Relayer r, long start, T ignored, Throwable t) {
        if (t != null) {
            this.log.error(String.valueOf(this.local_addr) + ": failed starting relayer", t);
        } else {
            this.log.info("%s: relayer was started in %d ms: %s", this.local_addr, System.currentTimeMillis() - start, r);
            if (this.topo.globalViews()) {
                this.topo.refresh(null);
                this.sendResponseTo(new SiteMaster(null), true);
            }
        }
        return null;
    }

    @Override
    protected void handleRelayMessage(Message msg) {
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        if (hdr == null) {
            this.log.warn("%s: received a message without a relay header; discarding it", this.local_addr);
            return;
        }
        try {
            Header[] original_hdrs = hdr.originalHeaders();
            Message copy = this.copy(msg).dest(hdr.final_dest).src(hdr.original_sender);
            copy.clearHeaders();
            if (original_hdrs != null && Headers.size(original_hdrs) > 0) {
                ((BaseMessage)copy).headers(original_hdrs);
            }
            copy.putHeader(this.id, hdr);
            if (msg.dest() != null) {
                copy.setFlag(hdr.originalFlags(), false);
            }
            this.process(true, copy);
        }
        catch (Exception ex) {
            this.log.error("%s: failed handling message relayed from %s: %s", this.local_addr, msg.src(), ex);
        }
    }

    protected boolean handleAdminMessage(RelayHeader hdr, Message msg) {
        switch (hdr.type) {
            case 4: 
            case 5: {
                HashSet<String> tmp_sites = new HashSet<String>();
                if (hdr.hasSites()) {
                    tmp_sites.addAll(hdr.getSites());
                }
                tmp_sites.remove(this.site);
                if (tmp_sites != null && !tmp_sites.isEmpty()) {
                    SiteStatus.Status status = hdr.type == 4 ? SiteStatus.Status.up : SiteStatus.Status.down;
                    Set<String> tmp = this.site_status.add(tmp_sites, status);
                    if (status == SiteStatus.Status.down) {
                        this.topo.removeAll(tmp_sites);
                    }
                    if (this.route_status_listener != null && !tmp.isEmpty()) {
                        String[] t = tmp.toArray(new String[0]);
                        if (hdr.type == 4) {
                            this.route_status_listener.sitesUp(t);
                        } else {
                            this.route_status_listener.sitesDown(t);
                        }
                    }
                }
                return true;
            }
            case 6: {
                if (!Objects.equals(this.local_addr, msg.src())) {
                    this.sendResponseTo(msg.src(), hdr.returnEntireCache());
                }
                return true;
            }
            case 7: {
                View v = (View)msg.getObject();
                String site_name = Objects.requireNonNull(hdr.getSite());
                if (v != null) {
                    this.topo.put(site_name, v);
                    if (!this.topo.globalViews()) {
                        return true;
                    }
                    Address dest = msg.getDest();
                    if (dest != null && ((SiteAddress)dest).type() == SiteAddress.Type.SM_ALL) {
                        Message local_mcast = new ObjectMessage(null, v).putHeader(this.id, hdr);
                        this.deliver(null, local_mcast, true, true, true);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void triggerSiteUnreachableEvent(SiteAddress s) {
        if (!this.delay_sites_down) {
            this._triggerSiteUnreachableEvent(s);
            return;
        }
        String unreachable_site = s.getSite();
        Predicate<String> pred = k -> this.relayer != null && this.relayer.hasRouteTo((String)k);
        this.site_unreachable_delayer.add(unreachable_site, pred, success -> {
            if (!success.booleanValue()) {
                this._triggerSiteUnreachableEvent(s);
            }
        });
    }

    protected void _triggerSiteUnreachableEvent(SiteAddress s) {
        super.triggerSiteUnreachableEvent(s);
        if (this.unicast != null) {
            Predicate<Address> pred = addr -> addr.isSiteAddress() && ((SiteAddress)addr).getSite().equals(s.getSite());
            this.unicast.removeSendConnection(pred);
        }
    }

    @Override
    protected void triggerMemberUnreachableEvent(Address mbr) {
        super.triggerMemberUnreachableEvent(mbr);
        if (this.unicast != null) {
            this.unicast.removeSendConnection(mbr);
        }
    }

    protected Object routeThen(Message msg, List<String> sites, Supplier<Object> action) {
        if (!msg.isFlagSet(Message.Flag.NO_RELAY)) {
            this.route(msg, sites);
        }
        return action != null ? action.get() : null;
    }

    protected Object process(boolean down2, Message msg) {
        SiteAddress.Type type;
        SiteAddress.Type type2;
        Address dest = msg.dest();
        SiteAddress dst = null;
        if (dest == null) {
            type2 = SiteAddress.Type.ALL;
        } else {
            dst = (SiteAddress)dest;
            type2 = type = dst.type();
        }
        if (this.is_site_master) {
            switch (type) {
                case ALL: {
                    if (down2) {
                        return this.routeThen(msg, null, () -> this.deliver(null, msg, true));
                    }
                    return this.mustBeRouted(msg) ? this.routeThen(msg, null, () -> this.passUp(msg)) : this.passUp(msg);
                }
                case SM_ALL: {
                    return this.routeThen(msg, null, () -> this.passUp(msg));
                }
                case SM: {
                    if (this.sameSite(dst)) {
                        return this.passUp(msg);
                    }
                    return this.route(msg, Arrays.asList(dst.getSite()));
                }
                case UNICAST: {
                    if (this.sameSite(dst)) {
                        if (down2) {
                            return this.deliver(dst, msg, false);
                        }
                        return this.passUp(msg);
                    }
                    return this.route(msg, Arrays.asList(dst.getSite()));
                }
            }
        } else {
            switch (type) {
                case ALL: {
                    if (down2) {
                        return this.deliver(null, msg, false);
                    }
                    return this.passUp(msg);
                }
                case SM_ALL: 
                case SM: {
                    if (down2) {
                        return this.sendToLocalSiteMaster(this.local_addr, msg);
                    }
                    throw new IllegalStateException(String.format("non site master %s received a msg with dst %s", this.local_addr, dst));
                }
                case UNICAST: {
                    if (down2) {
                        if (this.sameSite(dst)) {
                            return this.deliver(dst, msg, false);
                        }
                        return this.sendToLocalSiteMaster(this.local_addr, msg);
                    }
                    return this.passUp(msg);
                }
            }
        }
        return null;
    }

    protected boolean mustBeRouted(Message msg) {
        if (msg.isFlagSet(Message.Flag.NO_RELAY)) {
            return false;
        }
        List sms = this.site_masters;
        if (sms == null || sms.size() < 2) {
            return true;
        }
        Address first_sm = (Address)sms.get(0);
        return this.local_addr.equals(first_sm);
    }

    protected Object route(Message msg, Collection<String> sites) {
        Relayer r = this.relayer;
        if (r == null) {
            this.log.warn("%s: not site master; dropping message", this.local_addr);
            return null;
        }
        if (sites == null) {
            sites = new ArrayList<String>(r.routes.keySet());
        }
        sites.remove(this.site);
        if (sites.isEmpty()) {
            return null;
        }
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        Address dest = msg.dest();
        Address sender = msg.src();
        if (sender == null) {
            sender = hdr != null && hdr.original_sender != null ? ((ExtendedUUID)hdr.getOriginalSender()).addContents((ExtendedUUID)this.local_addr) : this.local_addr;
        }
        HashSet<String> visited_sites = null;
        if (dest == null || dest.isMulticast()) {
            visited_sites = new HashSet<String>(sites);
            visited_sites.add(this.site);
            if (hdr != null && hdr.hasVisitedSites()) {
                visited_sites.addAll(hdr.getVisitedSites());
                sites.removeAll(hdr.getVisitedSites());
            }
        }
        for (String s : sites) {
            Route route = r.getRoute(s, sender);
            if (route == null) {
                route = r.getForwardingRouteMatching(s, sender);
            }
            if (route == null) {
                this.suppress_log_no_route.log(SuppressLog.Level.error, s, this.suppress_time_no_route_errors, this.local_addr, sender, dest);
                this.sendSiteUnreachableTo(msg.getSrc(), s);
                continue;
            }
            route.send(dest, sender, msg, visited_sites);
        }
        return null;
    }

    protected Object deliver(Address next_dest, Message msg, boolean dont_relay) {
        return this.deliver(next_dest, msg, dont_relay, false, false);
    }

    protected Object deliver(Address next_dest, Message msg, boolean dont_relay, boolean dont_loopback, boolean oob) {
        this.checkLocalAddress(next_dest);
        Address final_dest = msg.dest();
        Address original_sender = msg.src();
        if (next_dest != null && this.view != null && !this.view.containsMember(next_dest)) {
            this.sendMemberUnreachableTo(original_sender, next_dest);
            return null;
        }
        RelayHeader tmp = (RelayHeader)msg.getHeader(this.id);
        RelayHeader hdr = tmp != null ? tmp.copy().setOriginalSender(original_sender).setFinalDestination(final_dest) : new RelayHeader(1, final_dest, original_sender);
        Message copy = this.copy(msg).setDest(next_dest).setSrc(null).putHeader(this.id, hdr);
        if (dont_relay) {
            copy.setFlag(Message.Flag.NO_RELAY);
        }
        if (oob) {
            copy.setFlag(Message.Flag.OOB);
        }
        if (dont_loopback) {
            copy.setFlag(Message.TransientFlag.DONT_LOOPBACK);
        }
        return this.down_prot.down(copy);
    }

    protected Object sendToLocalSiteMaster(Address sender, Message msg) {
        long start = this.stats ? System.nanoTime() : 0L;
        Address site_master = this.pickSiteMaster(sender);
        if (site_master == null) {
            throw new IllegalStateException("site master is null");
        }
        Object ret = this.deliver(site_master, msg, false);
        if (this.stats) {
            this.forward_sm_time.add(System.nanoTime() - start);
            this.forward_to_site_master.increment();
        }
        return ret;
    }

    protected Object passUp(Message msg) {
        if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
            Address dest = msg.dest();
            SiteAddress.Type type = dest == null ? SiteAddress.Type.ALL : ((SiteAddress)dest).type();
            switch (type) {
                case ALL: 
                case SM_ALL: 
                case SM: {
                    return null;
                }
            }
        }
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        Message copy = this.copy(msg);
        if (hdr != null) {
            copy.dest(hdr.final_dest).src(hdr.original_sender);
            if (this.handleAdminMessage(hdr, copy)) {
                return null;
            }
        }
        return this.up_prot.up(copy);
    }

    protected Address checkLocalAddress(Address dest) {
        if (dest == null) {
            return dest;
        }
        SiteAddress s = (SiteAddress)dest;
        String dest_site = s.getSite();
        if (dest_site != null && !this.site.equals(dest_site)) {
            throw new IllegalArgumentException(String.format("destination %s it not the same as the local site %s", dest_site, this.site));
        }
        return dest;
    }

    protected boolean sameSite(SiteAddress addr) {
        if (addr == null) {
            return true;
        }
        String dest_site = addr.getSite();
        return dest_site == null || this.site.equals(dest_site);
    }

    protected void sendSiteUnreachableTo(Address dest, String target_site) {
        if (dest == null || dest.equals(this.local_addr)) {
            this.triggerSiteUnreachableEvent(new SiteMaster(target_site));
            return;
        }
        Message msg = new EmptyMessage(dest).setFlag(Message.Flag.OOB).putHeader(this.id, new RelayHeader(2).addToSites(target_site));
        this.down(msg);
    }

    protected void sendMemberUnreachableTo(Address dest, Address member) {
        if (dest.equals(this.local_addr)) {
            this.triggerMemberUnreachableEvent(member);
            return;
        }
        Message msg = new ObjectMessage(dest, member).setFlag(Message.Flag.OOB).putHeader(this.id, new RelayHeader(3));
        this.down(msg);
    }

    protected CompletableFuture<Relayer> startRelayer(Relayer3 rel, String bridge_name) {
        try {
            this.log.trace(String.valueOf(this.local_addr) + ": became site master; starting bridges");
            return rel.start(this.site_config, bridge_name, this.site);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}

