/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmConfigParameterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTypeSpecificationType;
import org.hibernate.envers.boot.model.Bindable;
import org.hibernate.envers.boot.model.Cloneable;
import org.hibernate.envers.boot.model.ConfigParameterContainer;

public class TypeSpecification
implements ConfigParameterContainer,
Bindable<JaxbHbmTypeSpecificationType>,
Cloneable<TypeSpecification> {
    private final String name;
    private final Map<String, String> parameters;

    public TypeSpecification(String name) {
        this.name = name;
        this.parameters = new HashMap<String, String>();
    }

    public TypeSpecification(TypeSpecification other) {
        this.name = other.name;
        this.parameters = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : other.parameters.entrySet()) {
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public JaxbHbmTypeSpecificationType build() {
        JaxbHbmTypeSpecificationType definition = new JaxbHbmTypeSpecificationType();
        definition.setName(this.name);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            JaxbHbmConfigParameterType param = new JaxbHbmConfigParameterType();
            param.setName(entry.getKey());
            param.setValue(entry.getValue());
            definition.getConfigParameters().add(param);
        }
        return definition;
    }

    @Override
    public TypeSpecification deepCopy() {
        return new TypeSpecification(this);
    }
}

