/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public class HtmlEntity
extends Node
implements TextContainer {
    public void getAstExtra(@NotNull StringBuilder out) {
        if (!this.getChars().isEmpty()) {
            out.append(" \"").append((CharSequence)this.getChars()).append("\"");
        }
    }

    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public HtmlEntity() {
    }

    public HtmlEntity(BasedSequence chars) {
        super(chars);
    }

    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags) {
        if (BitFieldSet.any((long)flags, (long)F_NODE_TEXT)) {
            out.append((CharSequence)this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape((BasedSequence)this.getChars(), (ReplacedTextMapper)textMapper);
            out.append((CharSequence)unescaped);
        }
        return false;
    }
}

