/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceMonitor;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"})
@Configuration(proxyBeanMethods=false)
@Import(value={UtilAutoConfiguration.class})
@EnableDiscoveryClient
public class DiscoveryClientConfigServiceBootstrapConfiguration {
    @Bean
    public ConfigServerInstanceProvider configServerInstanceProvider(ObjectProvider<ConfigServerInstanceProvider.Function> function, ObjectProvider<DiscoveryClient> discoveryClient) {
        ConfigServerInstanceProvider.Function fn = (ConfigServerInstanceProvider.Function)function.getIfAvailable();
        if (fn != null) {
            return new ConfigServerInstanceProvider(fn);
        }
        DiscoveryClient client = (DiscoveryClient)discoveryClient.getIfAvailable();
        if (client == null) {
            throw new IllegalStateException("ConfigServerInstanceProvider requires a DiscoveryClient or Function");
        }
        return new ConfigServerInstanceProvider(arg_0 -> ((DiscoveryClient)client).getInstances(arg_0));
    }

    @Bean
    public ConfigServerInstanceMonitor configServerInstanceMonitor(ConfigClientProperties properties, ConfigServerInstanceProvider provider) {
        return new ConfigServerInstanceMonitor(LogFactory.getLog(ConfigServerInstanceMonitor.class), properties, provider);
    }
}

