/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractArrayJavaType;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class BooleanPrimitiveArrayJavaType
extends AbstractArrayJavaType<boolean[], Boolean> {
    public static final BooleanPrimitiveArrayJavaType INSTANCE = new BooleanPrimitiveArrayJavaType();

    private BooleanPrimitiveArrayJavaType() {
        this(BooleanJavaType.INSTANCE);
    }

    protected BooleanPrimitiveArrayJavaType(JavaType<Boolean> baseDescriptor) {
        super(boolean[].class, baseDescriptor, new ArrayMutabilityPlan());
    }

    @Override
    public String extractLoggableRepresentation(boolean[] value) {
        return value == null ? super.extractLoggableRepresentation(null) : Arrays.toString(value);
    }

    @Override
    public boolean areEqual(boolean[] one, boolean[] another) {
        return Arrays.equals(one, another);
    }

    @Override
    public int extractHashCode(boolean[] value) {
        return Arrays.hashCode(value);
    }

    @Override
    public String toString(boolean[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(value[0]);
        for (int i = 1; i < value.length; ++i) {
            sb.append(value[i]);
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean[] fromString(CharSequence charSequence) {
        int elementStart;
        if (charSequence == null) {
            return null;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        for (int i = elementStart = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c != ',') continue;
            list.add(Boolean.parseBoolean(charSequence.subSequence(elementStart, i).toString()));
            elementStart = i + 1;
        }
        boolean[] result = new boolean[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Boolean)list.get(i);
        }
        return result;
    }

    @Override
    public <X> X unwrap(boolean[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (Object[].class.isAssignableFrom(type)) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                unwrapped[i] = this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options);
            }
            return (X)unwrapped;
        }
        if (type == byte[].class) {
            return (X)SerializationHelper.serialize((Serializable)value);
        }
        if (type == BinaryStream.class) {
            return (X)new BinaryStreamImpl(SerializationHelper.serialize((Serializable)value));
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object unwrapped = Array.newInstance(preferredJavaTypeClass, value.length);
            for (int i = 0; i < value.length; ++i) {
                Array.set(unwrapped, i, this.getElementJavaType().unwrap(value[i], preferredJavaTypeClass, options));
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> boolean[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            try {
                value = ((java.sql.Array)value).getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof boolean[]) {
            return (boolean[])value;
        }
        if (value instanceof byte[]) {
            return (boolean[])SerializationHelper.deserialize((byte[])value);
        }
        if (value instanceof BinaryStream) {
            return (boolean[])SerializationHelper.deserialize(((BinaryStream)value).getBytes());
        }
        if (value.getClass().isArray()) {
            boolean[] wrapped = new boolean[Array.getLength(value)];
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = (Boolean)this.getElementJavaType().wrap(Array.get(value, i), options);
            }
            return wrapped;
        }
        if (value instanceof Boolean) {
            return new boolean[]{(Boolean)value};
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class ArrayMutabilityPlan
    implements MutabilityPlan<boolean[]> {
        private ArrayMutabilityPlan() {
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public boolean[] deepCopy(boolean[] value) {
            return value == null ? null : (boolean[])value.clone();
        }

        @Override
        public Serializable disassemble(boolean[] value, SharedSessionContract session) {
            return this.deepCopy(value);
        }

        @Override
        public boolean[] assemble(Serializable cached, SharedSessionContract session) {
            return this.deepCopy((boolean[])cached);
        }
    }
}

