/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryContext;

public final class RetrySynchronizationManager {
    private static final ThreadLocal<RetryContext> context = new ThreadLocal();
    private static final Map<Thread, RetryContext> contexts = new ConcurrentHashMap<Thread, RetryContext>();
    private static boolean useThreadLocal = true;

    private RetrySynchronizationManager() {
    }

    public static void setUseThreadLocal(boolean use) {
        useThreadLocal = use;
    }

    public static boolean isUseThreadLocal() {
        return useThreadLocal;
    }

    @Nullable
    public static RetryContext getContext() {
        if (useThreadLocal) {
            return context.get();
        }
        return contexts.get(Thread.currentThread());
    }

    @Nullable
    public static RetryContext register(RetryContext context) {
        if (useThreadLocal) {
            RetryContext oldContext = RetrySynchronizationManager.getContext();
            RetrySynchronizationManager.context.set(context);
            return oldContext;
        }
        RetryContext oldContext = contexts.get(Thread.currentThread());
        contexts.put(Thread.currentThread(), context);
        return oldContext;
    }

    @Nullable
    public static RetryContext clear() {
        RetryContext parent;
        RetryContext value = RetrySynchronizationManager.getContext();
        RetryContext retryContext = parent = value == null ? null : value.getParent();
        if (useThreadLocal) {
            context.set(parent);
        } else if (parent != null) {
            contexts.put(Thread.currentThread(), parent);
        } else {
            contexts.remove(Thread.currentThread());
        }
        return value;
    }
}

