/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public class TextBase
extends Node
implements TextContainer {
    public TextBase() {
    }

    public TextBase(BasedSequence chars) {
        super(chars);
    }

    public TextBase(String chars) {
        super(BasedSequence.of((CharSequence)chars));
    }

    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public void getAstExtra(@NotNull StringBuilder out) {
        this.astExtraChars(out);
    }

    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags) {
        if (BitFieldSet.any((long)flags, (long)F_NODE_TEXT)) {
            out.append((CharSequence)this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape((BasedSequence)this.getChars(), (ReplacedTextMapper)textMapper);
            out.append((CharSequence)unescaped);
        }
        return false;
    }

    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.getChars();
    }
}

