/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Index;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.hibernate.AnnotationException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

class IndexBinder {
    private final MetadataBuildingContext context;

    IndexBinder(MetadataBuildingContext context) {
        this.context = context;
    }

    private Database getDatabase() {
        return this.context.getMetadataCollector().getDatabase();
    }

    private ImplicitNamingStrategy getImplicitNamingStrategy() {
        return this.context.getBuildingOptions().getImplicitNamingStrategy();
    }

    private PhysicalNamingStrategy getPhysicalNamingStrategy() {
        return this.context.getBuildingOptions().getPhysicalNamingStrategy();
    }

    private Dialect getDialect() {
        return this.getDatabase().getJdbcEnvironment().getDialect();
    }

    private Selectable selectable(Table table, String columnNameOrFormula) {
        if (columnNameOrFormula.startsWith("(")) {
            return new Formula(columnNameOrFormula);
        }
        return this.createColumn(columnNameOrFormula);
    }

    private Column column(Table table, String columnName) {
        return this.createColumn(columnName);
    }

    private Column createColumn(String logicalName) {
        Database database = this.getDatabase();
        String physicalName = this.getPhysicalNamingStrategy().toPhysicalColumnName(database.toIdentifier(logicalName), database.getJdbcEnvironment()).render(this.getDialect());
        return new Column(physicalName);
    }

    private Selectable[] selectables(Table table, String name, String[] columnNames) {
        int size = columnNames.length;
        if (size == 0) {
            throw new AnnotationException("Index" + (String)(StringHelper.isEmpty(name) ? "" : " '" + name + "'") + " on table '" + table.getName() + "' has no columns");
        }
        Selectable[] columns = new Selectable[size];
        for (int index = 0; index < size; ++index) {
            String columnName = columnNames[index];
            if (StringHelper.isEmpty(columnName)) {
                throw new AnnotationException("Index" + (String)(StringHelper.isEmpty(name) ? "" : " '" + name + "'") + " on table '" + table.getName() + "' has an empty column name");
            }
            columns[index] = this.selectable(table, columnName);
        }
        return columns;
    }

    private Column[] columns(Table table, String name, String[] columnNames) {
        int size = columnNames.length;
        if (size == 0) {
            throw new AnnotationException("Unique constraint" + (String)(StringHelper.isEmpty(name) ? "" : " '" + name + "'") + " on table '" + table.getName() + "' has no columns");
        }
        Column[] columns = new Column[size];
        for (int index = 0; index < size; ++index) {
            String columnName = columnNames[index];
            if (StringHelper.isEmpty(columnName)) {
                throw new AnnotationException("Unique constraint" + (String)(StringHelper.isEmpty(name) ? "" : " '" + name + "'") + " on table '" + table.getName() + "' has an empty column name");
            }
            columns[index] = this.column(table, columnName);
        }
        return columns;
    }

    private void createIndexOrUniqueKey(Table table, String originalKeyName, boolean nameExplicit, String[] columnNames, String[] orderings, boolean unique, Selectable[] columns) {
        int i;
        String keyName;
        IndexOrUniqueKeyNameSource source = new IndexOrUniqueKeyNameSource(this.context, table, columnNames, originalKeyName);
        boolean hasFormula = false;
        for (Selectable selectable : columns) {
            if (!selectable.isFormula()) continue;
            hasFormula = true;
        }
        if (unique && !hasFormula) {
            keyName = this.getImplicitNamingStrategy().determineUniqueKeyName(source).render(this.getDialect());
            UniqueKey uniqueKey = table.getOrCreateUniqueKey(keyName);
            uniqueKey.setExplicit(true);
            uniqueKey.setNameExplicit(nameExplicit);
            for (i = 0; i < columns.length; ++i) {
                uniqueKey.addColumn((Column)columns[i], orderings != null ? orderings[i] : null);
            }
        } else {
            keyName = this.getImplicitNamingStrategy().determineIndexName(source).render(this.getDialect());
            org.hibernate.mapping.Index index = table.getOrCreateIndex(keyName);
            index.setUnique(unique);
            for (i = 0; i < columns.length; ++i) {
                index.addColumn(columns[i], orderings != null ? orderings[i] : null);
            }
        }
    }

    void bindIndexes(Table table, Index[] indexes) {
        for (Index index : indexes) {
            StringTokenizer tokenizer = new StringTokenizer(index.columnList(), ",");
            ArrayList<String> parsed = new ArrayList<String>();
            while (tokenizer.hasMoreElements()) {
                String trimmed = tokenizer.nextToken().trim();
                if (trimmed.isEmpty()) continue;
                parsed.add(trimmed);
            }
            String[] columnExpressions = new String[parsed.size()];
            String[] ordering = new String[parsed.size()];
            this.initializeColumns(columnExpressions, ordering, parsed);
            String name = index.name();
            boolean unique = index.unique();
            this.createIndexOrUniqueKey(table, name, !name.isEmpty(), columnExpressions, ordering, unique, this.selectables(table, name, columnExpressions));
        }
    }

    void bindUniqueConstraints(Table table, UniqueConstraint[] constraints) {
        for (UniqueConstraint constraint : constraints) {
            String name = constraint.name();
            String[] columnNames = constraint.columnNames();
            this.createIndexOrUniqueKey(table, name, !name.isEmpty(), columnNames, null, true, this.columns(table, name, columnNames));
        }
    }

    private void initializeColumns(String[] columns, String[] ordering, List<String> list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String description = list.get(i);
            String tmp = description.toLowerCase(Locale.ROOT);
            if (tmp.endsWith(" desc")) {
                columns[i] = description.substring(0, description.length() - 5);
                ordering[i] = "desc";
                continue;
            }
            if (tmp.endsWith(" asc")) {
                columns[i] = description.substring(0, description.length() - 4);
                ordering[i] = "asc";
                continue;
            }
            columns[i] = description;
            ordering[i] = null;
        }
    }

    private List<Identifier> toIdentifiers(String[] names) {
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<Identifier> columnNames = CollectionHelper.arrayList(names.length);
        for (String name : names) {
            columnNames.add(this.getDatabase().toIdentifier(name));
        }
        return columnNames;
    }

    private class IndexOrUniqueKeyNameSource
    implements ImplicitIndexNameSource,
    ImplicitUniqueKeyNameSource {
        private final MetadataBuildingContext buildingContext;
        private final Table table;
        private final String[] columnNames;
        private final String originalKeyName;
        private List<Identifier> columnNameIdentifiers;

        public IndexOrUniqueKeyNameSource(MetadataBuildingContext buildingContext, Table table, String[] columnNames, String originalKeyName) {
            this.buildingContext = buildingContext;
            this.table = table;
            this.columnNames = columnNames;
            this.originalKeyName = originalKeyName;
        }

        @Override
        public MetadataBuildingContext getBuildingContext() {
            return this.buildingContext;
        }

        @Override
        public Identifier getTableName() {
            return this.table.getNameIdentifier();
        }

        @Override
        public List<Identifier> getColumnNames() {
            if (this.columnNameIdentifiers == null) {
                this.columnNameIdentifiers = IndexBinder.this.toIdentifiers(this.columnNames);
            }
            return this.columnNameIdentifiers;
        }

        @Override
        public Identifier getUserProvidedIdentifier() {
            return this.originalKeyName != null ? Identifier.toIdentifier(this.originalKeyName) : null;
        }
    }
}

