/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public class SqmUnaryOperation<T>
extends AbstractSqmExpression<T>
implements SqmSelectableNode<T> {
    private final UnaryArithmeticOperator operation;
    private final SqmExpression<T> operand;

    public SqmUnaryOperation(UnaryArithmeticOperator operation, SqmExpression<T> operand) {
        this(operation, operand, operand.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(operand.getNodeType().getRelationalJavaType().getJavaType()));
    }

    public SqmUnaryOperation(UnaryArithmeticOperator operation, SqmExpression<T> operand, SqmExpressible<T> inherentType) {
        super(inherentType, operand.nodeBuilder());
        this.operation = operation;
        this.operand = operand;
    }

    @Override
    public SqmUnaryOperation<T> copy(SqmCopyContext context) {
        SqmUnaryOperation existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmUnaryOperation expression = context.registerCopy(this, new SqmUnaryOperation(this.operation, this.operand.copy(context), this.getNodeType()));
        this.copyTo(expression, context);
        return expression;
    }

    public SqmExpression getOperand() {
        return this.operand;
    }

    public UnaryArithmeticOperator getOperation() {
        return this.operation;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitUnaryOperationExpression(this);
    }

    @Override
    public String asLoggableText() {
        return (this.operation == UnaryArithmeticOperator.UNARY_MINUS ? (char)'-' : '+') + this.operand.asLoggableText();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.operation == UnaryArithmeticOperator.UNARY_MINUS ? (char)'-' : '+');
        this.operand.appendHqlString(sb);
    }
}

