/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.compatibility;

import com.xebialabs.plugin.manager.compatibility.XlFernflowerDecompiler;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.model.FilePlugin;
import com.xebialabs.plugin.manager.validator.ValidatorUtils$;
import com.xebialabs.xlplatform.sugar.PathSugar$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.exception.WindupStopException;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class Jdk17Compatibility$
implements Logging {
    public static final Jdk17Compatibility$ MODULE$ = new Jdk17Compatibility$();
    private static final List<String> EXTENSIONS;
    private static final List<String> EXCLUSION_LIST;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
        EXTENSIONS = new .colon.colon((Object)"java", (List)new .colon.colon((Object)"py", (List)Nil$.MODULE$));
        EXCLUSION_LIST = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"javax.activation", "javax.batch", "javax.ejb", "javax.el", "javax.enterprise", "javax.faces", "javax.jms", "javax.json", "javax.jws", "javax.mail", "javax.persistence", "javax.resource", "javax.servlet", "javax.validation", "javax.websocket", "javax.ws", "javax.xml.bind", "javax.annotation.Generated", "javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.annotation.Resource", "javax.annotation.Resources"}));
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Jdk17Compatibility$ jdk17Compatibility$ = this;
        synchronized (jdk17Compatibility$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public List<String> EXTENSIONS() {
        return EXTENSIONS;
    }

    public List<String> EXCLUSION_LIST() {
        return EXCLUSION_LIST;
    }

    public boolean isCompatible(FilePlugin plugin) {
        return this.verifyPluginCompatibility(plugin.name(), PathSugar$.MODULE$.path2File(plugin.filePath()));
    }

    public boolean isCompatible(DbPlugin plugin) {
        return this.isCompatible(plugin.name(), (byte[])plugin.bytes().get());
    }

    public boolean isCompatible(String plugin, byte[] bytes) {
        boolean bl;
        File pluginFile = ValidatorUtils$.MODULE$.createFileInWorkFolderFrom(bytes, plugin);
        try {
            bl = this.verifyPluginCompatibility(plugin, pluginFile);
        }
        catch (Throwable throwable) {
            try {
                FileUtils.deleteDirectory((File)pluginFile.getParentFile());
            }
            catch (Exception exception) {}
            throw throwable;
        }
        boolean bl2 = bl;
        try {
            FileUtils.deleteDirectory((File)pluginFile.getParentFile());
        }
        catch (Exception exception) {}
        return bl2;
    }

    private boolean verifyPluginCompatibility(String pluginName, File pluginPath) {
        boolean bl;
        Path workFolder = Paths.get("work" + File.separator + pluginName + "-compatibilityCheck", new String[0]);
        try {
            try {
                PathSugar$.MODULE$.path2File(workFolder).mkdirs();
                Map<File, Path> fileFolderMap = this.extractPlugin(pluginPath, workFolder);
                Map compatibleJars = (Map)fileFolderMap.takeWhile((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)Jdk17Compatibility$.$anonfun$verifyPluginCompatibility$1(e)));
                bl = ((Object)BoxesRunTime.boxToInteger((int)compatibleJars.size())).equals(BoxesRunTime.boxToInteger((int)fileFolderMap.size()));
            }
            catch (Exception e2) {
                this.logger().error((Function0 & Serializable)() -> "Unable to verify JDK17 compatibility for plugin " + pluginName + ": " + e2.getMessage() + ", cause: " + e2.getCause());
                throw e2;
            }
        }
        catch (Throwable throwable) {
            try {
                FileUtils.deleteDirectory((File)PathSugar$.MODULE$.path2File(workFolder));
            }
            catch (Exception exception) {}
            throw throwable;
        }
        boolean bl2 = bl;
        try {
            FileUtils.deleteDirectory((File)PathSugar$.MODULE$.path2File(workFolder));
        }
        catch (Exception exception) {}
        return bl2;
    }

    public boolean archiveContainsJars(ZipFile zipFile) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(zipFile.entries()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Jdk17Compatibility$.$anonfun$archiveContainsJars$1(x$1)));
    }

    private Map<File, Path> extractPlugin(File pluginPath, Path workFolder) {
        this.unzip(pluginPath, workFolder);
        if (this.archiveContainsJars(new ZipFile(pluginPath))) {
            File[] jars = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])PathSugar$.MODULE$.path2File(workFolder).listFiles()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Jdk17Compatibility$.$anonfun$extractPlugin$1(f)));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])jars), (Function1 & Serializable)jar -> {
                String jarFolderPathAsString = jar.getAbsolutePath().substring(0, jar.getAbsolutePath().lastIndexOf(".jar"));
                Path jarFolder = Paths.get(jarFolderPathAsString, new String[0]);
                PathSugar$.MODULE$.path2File(jarFolder).mkdir();
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(jar), (Object)jarFolder)}));
            }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pluginPath), (Object)workFolder)}));
    }

    private void unzip(File pluginFile, Path targetFolder) {
        ZipFile zipFile = new ZipFile(pluginFile);
        CollectionConverters$.MODULE$.EnumerationHasAsScala(zipFile.entries()).asScala().foreach((Function1 & Serializable)entry -> {
            Path path = targetFolder.resolve(entry.getName());
            if (entry.isDirectory()) {
                return Files.createDirectories(path, new FileAttribute[0]);
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return BoxesRunTime.boxToLong((long)Files.copy(zipFile.getInputStream((ZipEntry)entry), path, StandardCopyOption.REPLACE_EXISTING));
        });
    }

    private void decompilePlugin(File plugin, Path workFolder) {
        XlFernflowerDecompiler decompiler = new XlFernflowerDecompiler();
        DecompilationResult decompileResult = new DecompilationResult();
        DecompilationListener decompileListener = new DecompilationListener(decompileResult){
            private boolean cancelled;
            private final DecompilationResult decompileResult$1;

            public void fileDecompiled(java.util.List<String> x$1, String x$2, int[] x$3) {
                super.fileDecompiled(x$1, x$2, x$3);
            }

            private boolean cancelled() {
                return this.cancelled;
            }

            private void cancelled_$eq(boolean x$1) {
                this.cancelled = x$1;
            }

            public void fileDecompiled(java.util.List<String> inputPath, String outputPath) {
                try {
                    this.decompileResult$1.addDecompiled(inputPath, outputPath);
                }
                catch (WindupStopException stop) {
                    this.cancelled_$eq(true);
                    throw new WindupStopException((Exception)((Object)stop));
                }
            }

            public void decompilationFailed(java.util.List<String> inputPath, String message) {
                this.decompileResult$1.addFailure(new DecompilationFailure(message, inputPath, null));
            }

            public void decompilationProcessComplete() {
            }

            public boolean isCancelled() {
                return this.cancelled();
            }
            {
                this.decompileResult$1 = decompileResult$1;
                this.cancelled = false;
            }
        };
        Filter<ZipEntry> filter = new Filter<ZipEntry>(){

            public Filter.Result decide(ZipEntry entry) {
                if (entry.getName().endsWith("module-info.class")) {
                    return Filter.Result.REJECT;
                }
                return Filter.Result.ACCEPT;
            }
        };
        DecompilationResult decompositionResult = decompiler.decompileArchive(plugin.toPath(), workFolder, (Filter)filter, decompileListener);
        if (!decompositionResult.getFailures().isEmpty()) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to decompile all files in plugin " + plugin.getName() + ".");
            return;
        }
    }

    private boolean validatePluginSource(Collection<File> fileList) {
        boolean bl;
        Object object = new Object();
        try {
            fileList.forEach(file -> Using$.MODULE$.apply((Function0 & Serializable)() -> Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)source -> {
                Jdk17Compatibility$.$anonfun$validatePluginSource$3(object, source);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyPluginCompatibility$1(Tuple2 e) {
        MODULE$.decompilePlugin((File)e._1(), (Path)e._2());
        return MODULE$.validatePluginSource(FileUtils.listFiles((File)PathSugar$.MODULE$.path2File((Path)e._2()), (String[])((String[])MODULE$.EXTENSIONS().toArray(ClassTag$.MODULE$.apply(String.class))), (boolean)true));
    }

    public static final /* synthetic */ boolean $anonfun$archiveContainsJars$1(ZipEntry x$1) {
        return x$1.getName().endsWith(".jar");
    }

    public static final /* synthetic */ boolean $anonfun$extractPlugin$1(File f) {
        return f.isFile() && f.getName().endsWith(".jar");
    }

    public static final /* synthetic */ void $anonfun$validatePluginSource$3(Object nonLocalReturnKey1$1, BufferedSource source) {
        String contents = source.getLines().mkString("\n");
        if (MODULE$.EXCLUSION_LIST().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)contents.contains(x$1)))) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    private Jdk17Compatibility$() {
    }
}

