/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.DataHolder;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamCiConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.List;

@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class RemoteXStreamCiConverter
extends XStreamCiConverter {
    protected ConfigurationItemConverter createConverter(DataHolder context) {
        return new RemoteCiConverter(context);
    }

    private static class RemoteCiConverter
    extends ConfigurationItemConverter {
        private DataHolder context;

        public RemoteCiConverter(DataHolder context) {
            this.context = context;
            this.setReadValidationMessages(true);
        }

        public Type type(String typeName) {
            String booterConfigKey = (String)this.context.get((Object)"BOOTER_CONFIG");
            DeployitCommunicator communicator = RemoteBooter.getCommunicator(booterConfigKey);
            return communicator.getType(typeName);
        }

        protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            propertyDescriptor.set(configurationItem, (Object)reader.getCiReference());
        }

        protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            List references = reader.getCiReferences();
            propertyDescriptor.set(configurationItem, (Object)references);
        }

        protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, CiReader reader) {
            List strings = reader.getStringValues();
            propertyDescriptor.set(configurationItem, (Object)strings);
        }
    }
}

