/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.configuration.git;

import com.xebialabs.deployit.plugin.stitch.configuration.StitchJGitConfig$;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.springframework.util.ReflectionUtils;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.util.Using;

public final class OpenSSHConfigBootstrapper$ {
    public static final OpenSSHConfigBootstrapper$ MODULE$ = new OpenSSHConfigBootstrapper$();

    public void bootstrap(String configPath) {
        Path tempFolder = Files.createTempDirectory("stitch", new FileAttribute[0]);
        Path tempConfig = Files.createTempFile(tempFolder, "ssh", "config", new FileAttribute[0]);
        Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            OpenSSHConfigBootstrapper$.$anonfun$bootstrap$1(configPath, tempConfig, use);
            return BoxedUnit.UNIT;
        });
        Field configField = ReflectionUtils.findField(JschConfigSessionFactory.class, (String)"config");
        OpenSshConfig configInstance = (OpenSshConfig)ReflectionUtils.accessibleConstructor(OpenSshConfig.class, (Class[])new Class[]{File.class, File.class}).newInstance(tempFolder.toFile(), tempConfig.toFile());
        ReflectionUtils.makeAccessible((Field)configField);
        ReflectionUtils.setField((Field)configField, (Object)SshSessionFactory.getInstance(), (Object)configInstance);
    }

    public Path writeTempConfig(String sshConfigPath, String knownHostsPath) {
        Path tempFolder = Files.createTempDirectory("stitch", new FileAttribute[0]);
        Path sshFolder = Files.createDirectory(tempFolder.resolve(".ssh"), new FileAttribute[0]);
        Path sshConfig = Files.createFile(sshFolder.resolve("config"), new FileAttribute[0]);
        Path knownHosts = Files.createFile(sshFolder.resolve("known_hosts"), new FileAttribute[0]);
        Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            OpenSSHConfigBootstrapper$.$anonfun$writeTempConfig$1(sshConfigPath, knownHostsPath, sshConfig, knownHosts, use);
            return BoxedUnit.UNIT;
        });
        return tempFolder;
    }

    public Path writeTempConfigWithDefaults() {
        return this.writeTempConfig(StitchJGitConfig$.MODULE$.DefaultOpenSshConfigPath(), StitchJGitConfig$.MODULE$.DefaultOpenSShKnownHostPath());
    }

    public void deleteTempConfig(Path path) {
        FileUtils.deleteQuietly((File)path.toFile());
    }

    public static final /* synthetic */ void $anonfun$bootstrap$1(String configPath$1, Path tempConfig$1, Using.Manager use) {
        InputStream sourceSSHConfig = (InputStream)use.apply((Object)MODULE$.getClass().getResourceAsStream(configPath$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        FileWriter destSSHConfig = (FileWriter)use.apply((Object)new FileWriter(tempConfig$1.toFile()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        IOUtils.copy((InputStream)sourceSSHConfig, (Writer)destSSHConfig, (Charset)Charset.defaultCharset());
    }

    public static final /* synthetic */ void $anonfun$writeTempConfig$1(String sshConfigPath$1, String knownHostsPath$1, Path sshConfig$1, Path knownHosts$1, Using.Manager use) {
        InputStream sourceSshConfig = (InputStream)use.apply((Object)MODULE$.getClass().getResourceAsStream(sshConfigPath$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        InputStream sourceKnownHost = (InputStream)use.apply((Object)MODULE$.getClass().getResourceAsStream(knownHostsPath$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        FileWriter destSshConfig = (FileWriter)use.apply((Object)new FileWriter(sshConfig$1.toFile()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        FileWriter destKnownHost = (FileWriter)use.apply((Object)new FileWriter(knownHosts$1.toFile()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        IOUtils.copy((InputStream)sourceSshConfig, (Writer)destSshConfig, (Charset)Charset.defaultCharset());
        IOUtils.copy((InputStream)sourceKnownHost, (Writer)destKnownHost, (Charset)Charset.defaultCharset());
    }

    private OpenSSHConfigBootstrapper$() {
    }
}

