/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.query.sqm.sql.internal.AbstractSqlAstQueryNodeProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstQueryPartProcessingStateImpl
extends AbstractSqlAstQueryNodeProcessingStateImpl
implements SqlAstQueryPartProcessingState {
    private final QueryPart queryPart;
    private final boolean deduplicateSelectionItems;
    private FetchParent nestingFetchParent;
    private Map<?, ?> sqlSelectionMap;
    private int nextJdbcPosition = 1;

    public SqlAstQueryPartProcessingStateImpl(QueryPart queryPart, SqlAstProcessingState parent, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess, boolean deduplicateSelectionItems) {
        super(parent, creationState, currentClauseAccess);
        this.queryPart = queryPart;
        this.deduplicateSelectionItems = deduplicateSelectionItems;
    }

    public SqlAstQueryPartProcessingStateImpl(QueryPart queryPart, SqlAstProcessingState parent, SqlAstCreationState creationState, Function<SqlExpressionResolver, SqlExpressionResolver> expressionResolverDecorator, Supplier<Clause> currentClauseAccess, boolean deduplicateSelectionItems) {
        super(parent, creationState, expressionResolverDecorator, currentClauseAccess);
        this.queryPart = queryPart;
        this.deduplicateSelectionItems = deduplicateSelectionItems;
    }

    public FetchParent getNestingFetchParent() {
        return this.nestingFetchParent;
    }

    public void setNestingFetchParent(FetchParent nestedParent) {
        this.nestingFetchParent = nestedParent;
    }

    @Override
    public QueryPart getInflightQueryPart() {
        return this.queryPart;
    }

    @Override
    public FromClause getFromClause() {
        return this.queryPart.getLastQuerySpec().getFromClause();
    }

    @Override
    public void applyPredicate(Predicate predicate) {
        this.queryPart.getLastQuerySpec().applyPredicate(predicate);
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaType<?> javaType, FetchParent fetchParent, TypeConfiguration typeConfiguration) {
        int jdbcPosition;
        Object existingSelection;
        HashMap<Expression, Object> selectionMap;
        if (this.nestingFetchParent != null) {
            if (!(expression instanceof ColumnReference)) {
                throw new IllegalArgumentException("Illegal expression passed for nested fetching: " + expression);
            }
            String selectableName = ((ColumnReference)expression).getSelectableName();
            return expression.createSqlSelection(-1, this.nestingFetchParent.getReferencedMappingType().getSelectableIndex(selectableName), javaType, true, typeConfiguration);
        }
        if (this.deduplicateSelectionItems) {
            if (this.sqlSelectionMap == null) {
                this.sqlSelectionMap = new HashMap();
            }
            selectionMap = this.sqlSelectionMap;
        } else if (fetchParent != null) {
            Map<?, ?> fetchParentSqlSelectionMap;
            FetchParent root = fetchParent.getRoot();
            if (this.sqlSelectionMap == null) {
                fetchParentSqlSelectionMap = new HashMap();
                this.sqlSelectionMap = fetchParentSqlSelectionMap;
                selectionMap = new HashMap<Expression, Object>();
                fetchParentSqlSelectionMap.put(root, selectionMap);
            } else {
                fetchParentSqlSelectionMap = this.sqlSelectionMap;
                HashMap<Expression, Object> map = (HashMap<Expression, Object>)fetchParentSqlSelectionMap.get(root);
                if (map == null) {
                    selectionMap = new HashMap();
                    fetchParentSqlSelectionMap.put(root, selectionMap);
                } else {
                    selectionMap = map;
                }
            }
        } else {
            selectionMap = null;
        }
        if (selectionMap != null) {
            existingSelection = selectionMap.get(expression);
            if (existingSelection != null) {
                if (existingSelection instanceof SqlSelection) {
                    SqlSelection sqlSelection = (SqlSelection)existingSelection;
                    if (sqlSelection.getExpressionType() == expression.getExpressionType()) {
                        return sqlSelection;
                    }
                    jdbcPosition = sqlSelection.getJdbcResultSetIndex();
                } else {
                    SqlSelection[] selections;
                    for (SqlSelection sqlSelection : selections = (SqlSelection[])existingSelection) {
                        if (sqlSelection.getExpressionType() != expression.getExpressionType()) continue;
                        return sqlSelection;
                    }
                    jdbcPosition = selections[0].getJdbcResultSetIndex();
                }
            } else {
                jdbcPosition = this.nextJdbcPosition++;
            }
        } else {
            jdbcPosition = this.nextJdbcPosition++;
            existingSelection = null;
        }
        boolean virtual = existingSelection != null;
        SelectClause selectClause = ((QuerySpec)this.queryPart).getSelectClause();
        int valuesArrayPosition = selectClause.getSqlSelections().size();
        SqlSelection sqlSelection = this.isTopLevel() ? expression.createDomainResultSqlSelection(jdbcPosition, valuesArrayPosition, javaType, virtual, typeConfiguration) : expression.createSqlSelection(jdbcPosition, valuesArrayPosition, javaType, virtual, typeConfiguration);
        selectClause.addSqlSelection(sqlSelection);
        if (selectionMap != null) {
            if (virtual) {
                SqlSelection[] selections;
                if (existingSelection instanceof SqlSelection) {
                    selections = new SqlSelection[2];
                    selections[0] = (SqlSelection)existingSelection;
                } else {
                    SqlSelection[] existingSelections = (SqlSelection[])existingSelection;
                    selections = new SqlSelection[existingSelections.length + 1];
                    System.arraycopy(existingSelections, 0, selections, 0, existingSelections.length);
                }
                selections[selections.length - 1] = sqlSelection;
                selectionMap.put(expression, selections);
            } else {
                selectionMap.put(expression, sqlSelection);
            }
        }
        return sqlSelection;
    }
}

