/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.ObsoleteApi;
import com.google.api.gax.batching.AutoValue_BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@AutoValue
public abstract class BatchingSettings {
    @Nullable
    public abstract Long getElementCountThreshold();

    @Nullable
    public abstract Long getRequestByteThreshold();

    @Nullable
    @ObsoleteApi(value="Use getDelayThresholdDuration() instead")
    public Duration getDelayThreshold() {
        return TimeConversionUtils.toThreetenDuration(this.getDelayThresholdDuration());
    }

    @Nullable
    public abstract java.time.Duration getDelayThresholdDuration();

    public abstract Boolean getIsEnabled();

    public abstract FlowControlSettings getFlowControlSettings();

    public static Builder newBuilder() {
        return new AutoValue_BatchingSettings.Builder().setIsEnabled(true).setElementCountThreshold(1L).setRequestByteThreshold(1L).setDelayThresholdDuration(java.time.Duration.ofMillis(1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setElementCountThreshold(Long var1);

        public abstract Builder setRequestByteThreshold(Long var1);

        @ObsoleteApi(value="Use setDelayThresholdDuration(java.time.Duration) instead")
        public final Builder setDelayThreshold(Duration delayThreshold) {
            return this.setDelayThresholdDuration(TimeConversionUtils.toJavaTimeDuration(delayThreshold));
        }

        public abstract Builder setDelayThresholdDuration(java.time.Duration var1);

        public abstract Builder setIsEnabled(Boolean var1);

        public abstract Builder setFlowControlSettings(FlowControlSettings var1);

        abstract BatchingSettings autoBuild();

        public BatchingSettings build() {
            BatchingSettings settings = this.autoBuild();
            Preconditions.checkArgument((settings.getElementCountThreshold() == null || settings.getElementCountThreshold() > 0L ? 1 : 0) != 0, (Object)"elementCountThreshold must be either unset or positive");
            Preconditions.checkArgument((settings.getRequestByteThreshold() == null || settings.getRequestByteThreshold() > 0L ? 1 : 0) != 0, (Object)"requestByteThreshold must be either unset or positive");
            Preconditions.checkArgument((settings.getDelayThresholdDuration() == null || settings.getDelayThresholdDuration().compareTo(java.time.Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"delayThreshold must be either unset or positive");
            return settings;
        }
    }
}

