/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public final class TagWriterImpl
implements TagWriter,
ProtobufTagMarshaller.WriteContext {
    private static final Log log = Log.LogFactory.getLog(TagWriterImpl.class);
    private final SerializationContextImpl serCtx;
    private final Encoder encoder;
    private final TagWriterImpl parent;
    private final int depth;
    private Map<Object, Object> params = null;
    @Deprecated
    private ProtoStreamWriterImpl writer = null;

    private TagWriterImpl(TagWriterImpl parent, Encoder encoder) {
        this.parent = parent;
        this.depth = parent.depth + 1;
        this.serCtx = parent.serCtx;
        this.encoder = encoder;
    }

    private TagWriterImpl(SerializationContextImpl serCtx, Encoder encoder) {
        this.parent = null;
        this.depth = 0;
        this.serCtx = serCtx;
        this.encoder = encoder;
    }

    public static TagWriterImpl newNestedInstance(ProtobufTagMarshaller.WriteContext parent, OutputStream output) {
        return new TagWriterImpl((TagWriterImpl)parent, (Encoder)new OutputStreamNoBufferEncoder(output));
    }

    public static TagWriterImpl newNestedInstance(ProtobufTagMarshaller.WriteContext parent, byte[] buf) {
        return new TagWriterImpl((TagWriterImpl)parent, (Encoder)new ByteArrayEncoder(buf, 0, buf.length));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, OutputStream output) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, (Encoder)new OutputStreamEncoder(output, 4096));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, OutputStream output, int bufferSize) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, (Encoder)new OutputStreamEncoder(output, bufferSize));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, byte[] buf) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, (Encoder)new ByteArrayEncoder(buf, 0, buf.length));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, byte[] buf, int offset, int length) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, (Encoder)new ByteArrayEncoder(buf, offset, length));
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx, ByteBuffer byteBuffer) {
        Encoder encoder = byteBuffer.hasArray() ? new HeapByteBufferEncoder(byteBuffer) : new ByteBufferEncoder(byteBuffer);
        return new TagWriterImpl((SerializationContextImpl)serCtx, encoder);
    }

    public static TagWriterImpl newInstance(ImmutableSerializationContext serCtx) {
        return new TagWriterImpl((SerializationContextImpl)serCtx, (Encoder)new NoOpEncoder());
    }

    public static TagWriterImpl newInstanceNoBuffer(ImmutableSerializationContext ctx, OutputStream out) {
        return new TagWriterImpl((SerializationContextImpl)ctx, (Encoder)new OutputStreamNoBufferEncoder(out));
    }

    public int getWrittenBytes() {
        return ((NoOpEncoder)this.encoder).getWrittenBytes();
    }

    @Override
    public void flush() throws IOException {
        this.encoder.flush();
    }

    @Override
    public void writeTag(int number, int wireType) throws IOException {
        this.encoder.writeVarint32(WireType.makeTag(number, wireType));
    }

    @Override
    public void writeTag(int number, WireType wireType) throws IOException {
        this.encoder.writeVarint32(WireType.makeTag(number, wireType));
    }

    @Override
    public void writeVarint32(int value) throws IOException {
        this.encoder.writeVarint32(value);
    }

    @Override
    public void writeVarint64(long value) throws IOException {
        this.encoder.writeVarint64(value);
    }

    @Override
    public void writeString(int number, String value) throws IOException {
        byte[] utf8buffer = value.getBytes(StandardCharsets.UTF_8);
        this.encoder.writeLengthDelimitedField(number, utf8buffer.length);
        this.encoder.writeBytes(utf8buffer, 0, utf8buffer.length);
    }

    @Override
    public void writeInt32(int number, int value) throws IOException {
        if (value >= 0) {
            this.encoder.writeUInt32Field(number, value);
        } else {
            this.encoder.writeUInt64Field(number, value);
        }
    }

    @Override
    public void writeUInt32(int number, int value) throws IOException {
        this.encoder.writeUInt32Field(number, value);
    }

    @Override
    public void writeSInt32(int number, int value) throws IOException {
        this.encoder.writeUInt32Field(number, value << 1 ^ value >> 31);
    }

    @Override
    public void writeFixed32(int number, int value) throws IOException {
        this.encoder.writeFixed32Field(number, value);
    }

    @Override
    public void writeSFixed32(int number, int value) throws IOException {
        this.writeFixed32(number, value);
    }

    @Override
    public void writeInt64(int number, long value) throws IOException {
        this.encoder.writeUInt64Field(number, value);
    }

    @Override
    public void writeUInt64(int number, long value) throws IOException {
        this.encoder.writeUInt64Field(number, value);
    }

    @Override
    public void writeSInt64(int number, long value) throws IOException {
        this.encoder.writeUInt64Field(number, value << 1 ^ value >> 63);
    }

    @Override
    public void writeFixed64(int number, long value) throws IOException {
        this.encoder.writeFixed64Field(number, value);
    }

    @Override
    public void writeSFixed64(int number, long value) throws IOException {
        this.writeFixed64(number, value);
    }

    @Override
    public void writeEnum(int number, int value) throws IOException {
        this.writeInt32(number, value);
    }

    @Override
    public void writeBool(int number, boolean value) throws IOException {
        this.encoder.writeBoolField(number, value);
    }

    @Override
    public void writeDouble(int number, double value) throws IOException {
        this.encoder.writeFixed64Field(number, Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeFloat(int number, float value) throws IOException {
        this.encoder.writeFixed32Field(number, Float.floatToRawIntBits(value));
    }

    @Override
    public void writeBytes(int number, ByteBuffer value) throws IOException {
        this.encoder.writeLengthDelimitedField(number, value.remaining());
        this.encoder.writeBytes(value);
    }

    @Override
    public void writeBytes(int number, byte[] value) throws IOException {
        this.writeBytes(number, value, 0, value.length);
    }

    @Override
    public void writeBytes(int number, byte[] value, int offset, int length) throws IOException {
        this.encoder.writeLengthDelimitedField(number, length);
        this.encoder.writeBytes(value, offset, length);
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.encoder.writeBytes(value, offset, length);
    }

    @Override
    public SerializationContextImpl getSerializationContext() {
        return this.serCtx;
    }

    @Override
    public Object getParam(Object key) {
        if (this.parent != null) {
            return this.parent.getParam(key);
        }
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    @Override
    public void setParam(Object key, Object value) {
        if (this.parent != null) {
            this.parent.setParam(key, value);
        } else {
            if (this.params == null) {
                this.params = new HashMap<Object, Object>();
            }
            this.params.put(key, value);
        }
    }

    @Override
    public TagWriter getWriter() {
        return this;
    }

    @Override
    public int depth() {
        return this.depth;
    }

    public ProtoStreamWriterImpl getProtoStreamWriter() {
        if (this.parent != null) {
            return this.parent.getProtoStreamWriter();
        }
        if (this.writer == null) {
            this.writer = new ProtoStreamWriterImpl(this.serCtx);
        }
        return this.writer;
    }

    private static abstract class Encoder {
        private Encoder() {
        }

        void flush() throws IOException {
        }

        void writeUInt32Field(int fieldNumber, int value) throws IOException {
            this.writeVarint32(WireType.makeTag(fieldNumber, 0));
            this.writeVarint32(value);
        }

        void writeUInt64Field(int fieldNumber, long value) throws IOException {
            this.writeVarint32(WireType.makeTag(fieldNumber, 0));
            this.writeVarint64(value);
        }

        void writeFixed32Field(int fieldNumber, int value) throws IOException {
            this.writeVarint32(WireType.makeTag(fieldNumber, 5));
            this.writeFixed32(value);
        }

        void writeFixed64Field(int fieldNumber, long value) throws IOException {
            this.writeVarint32(WireType.makeTag(fieldNumber, 1));
            this.writeFixed64(value);
        }

        void writeBoolField(int fieldNumber, boolean value) throws IOException {
            this.writeVarint32(WireType.makeTag(fieldNumber, 0));
            this.writeByte((byte)(value ? 1 : 0));
        }

        void writeLengthDelimitedField(int fieldNumber, int length) throws IOException {
            this.writeVarint32(WireType.makeTag(fieldNumber, 2));
            this.writeVarint32(length);
        }

        abstract void writeVarint32(int var1) throws IOException;

        abstract void writeVarint64(long var1) throws IOException;

        abstract void writeFixed32(int var1) throws IOException;

        abstract void writeFixed64(long var1) throws IOException;

        abstract void writeByte(byte var1) throws IOException;

        abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

        abstract void writeBytes(ByteBuffer var1) throws IOException;
    }

    private static class OutputStreamNoBufferEncoder
    extends Encoder {
        private final OutputStream out;

        private OutputStreamNoBufferEncoder(OutputStream out) {
            this.out = out;
        }

        @Override
        void writeVarint32(int value) throws IOException {
            while (true) {
                if ((value & 0xFFFFFF80) == 0) break;
                this.out.write((byte)(value & 0x7F | 0x80));
                value >>>= 7;
            }
            this.out.write((byte)value);
        }

        @Override
        void writeVarint64(long value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.out.write((byte)value);
                        break;
                    }
                    this.out.write((byte)((int)value & 0x7F | 0x80));
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeFixed32(int value) throws IOException {
            this.out.write((byte)(value & 0xFF));
            this.out.write((byte)(value >> 8 & 0xFF));
            this.out.write((byte)(value >> 16 & 0xFF));
            this.out.write((byte)(value >> 24 & 0xFF));
        }

        @Override
        void writeFixed64(long value) throws IOException {
            this.out.write((byte)(value & 0xFFL));
            this.out.write((byte)(value >> 8 & 0xFFL));
            this.out.write((byte)(value >> 16 & 0xFFL));
            this.out.write((byte)(value >> 24 & 0xFFL));
            this.out.write((byte)((int)(value >> 32) & 0xFF));
            this.out.write((byte)((int)(value >> 40) & 0xFF));
            this.out.write((byte)((int)(value >> 48) & 0xFF));
            this.out.write((byte)((int)(value >> 56) & 0xFF));
        }

        @Override
        void writeByte(byte value) throws IOException {
            this.out.write(value);
        }

        @Override
        void writeBytes(byte[] value, int offset, int length) throws IOException {
            this.out.write(value, offset, length);
        }

        @Override
        void writeBytes(ByteBuffer value) throws IOException {
            if (value.hasArray()) {
                this.out.write(value.array(), value.arrayOffset(), value.remaining());
            } else {
                byte[] buffer = new byte[value.remaining()];
                value.get(buffer, value.position(), value.remaining());
                this.out.write(buffer);
            }
        }

        @Override
        void flush() throws IOException {
            super.flush();
            this.out.flush();
        }
    }

    private static class ByteArrayEncoder
    extends Encoder {
        private final byte[] array;
        protected final int offset;
        protected final int limit;
        protected int pos;

        private ByteArrayEncoder(byte[] array, int offset, int length) {
            if (array == null) {
                throw new IllegalArgumentException("array cannot be null");
            }
            if (offset < 0) {
                throw new IllegalArgumentException("offset cannot be negative");
            }
            if (length < 0) {
                throw new IllegalArgumentException("length cannot be negative");
            }
            if (offset >= array.length) {
                throw new IllegalArgumentException("start position is outside array bounds");
            }
            if (offset + length > array.length) {
                throw new IllegalArgumentException("end position is outside array bounds");
            }
            this.array = array;
            this.offset = offset;
            this.limit = offset + length;
            this.pos = offset;
        }

        protected final int remainingSpace() {
            return this.limit - this.pos;
        }

        protected final void flushToStream(OutputStream out, int requiredSpace) throws IOException {
            if (requiredSpace > this.limit - this.pos) {
                out.write(this.array, 0, this.pos);
                this.pos = 0;
            }
        }

        protected final void flushToStream(OutputStream out) throws IOException {
            if (this.pos > 0) {
                out.write(this.array, 0, this.pos);
                this.pos = 0;
            }
        }

        protected final void fillFromBuffer(ByteBuffer byteBuffer) {
            int free = this.array.length - this.pos;
            int length = byteBuffer.remaining();
            if (free >= length) {
                byteBuffer.get(this.array, this.pos, length);
                this.pos += length;
            } else {
                byteBuffer.get(this.array, this.pos, free);
                this.pos = this.array.length;
            }
        }

        @Override
        final void writeByte(byte value) throws IOException {
            try {
                this.array[this.pos++] = value;
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        final void writeBytes(byte[] value, int offset, int length) throws IOException {
            try {
                System.arraycopy(value, offset, this.array, this.pos, length);
                this.pos += length;
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        final void writeBytes(ByteBuffer value) throws IOException {
            int length = value.remaining();
            if (value.hasArray()) {
                this.writeBytes(value.array(), value.arrayOffset() + value.position(), length);
                value.position(value.position() + length);
            } else {
                try {
                    value.get(this.array, this.pos, length);
                    this.pos += length;
                }
                catch (IndexOutOfBoundsException e) {
                    throw log.outOfWriteBufferSpace(e);
                }
            }
        }

        @Override
        final void writeVarint32(int value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        this.array[this.pos++] = (byte)value;
                        break;
                    }
                    this.array[this.pos++] = (byte)(value & 0x7F | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        final void writeVarint64(long value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.array[this.pos++] = (byte)value;
                        break;
                    }
                    this.array[this.pos++] = (byte)((int)value & 0x7F | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        final void writeFixed32(int value) throws IOException {
            try {
                this.array[this.pos++] = (byte)(value & 0xFF);
                this.array[this.pos++] = (byte)(value >> 8 & 0xFF);
                this.array[this.pos++] = (byte)(value >> 16 & 0xFF);
                this.array[this.pos++] = (byte)(value >> 24 & 0xFF);
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        final void writeFixed64(long value) throws IOException {
            try {
                this.array[this.pos++] = (byte)(value & 0xFFL);
                this.array[this.pos++] = (byte)(value >> 8 & 0xFFL);
                this.array[this.pos++] = (byte)(value >> 16 & 0xFFL);
                this.array[this.pos++] = (byte)(value >> 24 & 0xFFL);
                this.array[this.pos++] = (byte)((int)(value >> 32) & 0xFF);
                this.array[this.pos++] = (byte)((int)(value >> 40) & 0xFF);
                this.array[this.pos++] = (byte)((int)(value >> 48) & 0xFF);
                this.array[this.pos++] = (byte)((int)(value >> 56) & 0xFF);
            }
            catch (IndexOutOfBoundsException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }
    }

    private static final class OutputStreamEncoder
    extends Encoder {
        private final ByteArrayEncoder buffer;
        private final OutputStream out;

        OutputStreamEncoder(OutputStream out, int bufferSize) {
            bufferSize = Math.max(bufferSize, 20);
            this.buffer = new ByteArrayEncoder(new byte[bufferSize], 0, bufferSize);
            this.out = out;
        }

        @Override
        void writeUInt32Field(int fieldNumber, int value) throws IOException {
            this.buffer.flushToStream(this.out, 20);
            this.buffer.writeUInt32Field(fieldNumber, value);
        }

        @Override
        void writeUInt64Field(int fieldNumber, long value) throws IOException {
            this.buffer.flushToStream(this.out, 20);
            this.buffer.writeUInt64Field(fieldNumber, value);
        }

        @Override
        void writeFixed32Field(int fieldNumber, int value) throws IOException {
            this.buffer.flushToStream(this.out, 14);
            this.buffer.writeFixed32Field(fieldNumber, value);
        }

        @Override
        void writeFixed64Field(int fieldNumber, long value) throws IOException {
            this.buffer.flushToStream(this.out, 18);
            this.buffer.writeFixed64Field(fieldNumber, value);
        }

        @Override
        void writeBoolField(int fieldNumber, boolean value) throws IOException {
            this.buffer.flushToStream(this.out, 11);
            this.buffer.writeBoolField(fieldNumber, value);
        }

        @Override
        void writeLengthDelimitedField(int fieldNumber, int length) throws IOException {
            this.buffer.flushToStream(this.out, 20);
            this.buffer.writeLengthDelimitedField(fieldNumber, length);
        }

        @Override
        void writeVarint32(int value) throws IOException {
            this.buffer.flushToStream(this.out, 10);
            this.buffer.writeVarint32(value);
        }

        @Override
        void writeVarint64(long value) throws IOException {
            this.buffer.flushToStream(this.out, 10);
            this.buffer.writeVarint64(value);
        }

        @Override
        void writeFixed32(int value) throws IOException {
            this.buffer.flushToStream(this.out, 4);
            this.buffer.writeFixed32(value);
        }

        @Override
        void writeFixed64(long value) throws IOException {
            this.buffer.flushToStream(this.out, 8);
            this.buffer.writeFixed64(value);
        }

        @Override
        void writeByte(byte value) throws IOException {
            this.buffer.flushToStream(this.out, 1);
            this.buffer.writeByte(value);
        }

        @Override
        void writeBytes(byte[] value, int offset, int length) throws IOException {
            if (this.buffer.remainingSpace() >= length) {
                this.buffer.writeBytes(value, offset, length);
            } else {
                this.buffer.flushToStream(this.out);
                this.out.write(value, offset, length);
            }
        }

        @Override
        void writeBytes(ByteBuffer value) throws IOException {
            if (value.hasArray()) {
                this.buffer.flushToStream(this.out);
                this.out.write(value.array(), value.arrayOffset(), value.remaining());
                return;
            }
            while (value.hasRemaining()) {
                if (this.buffer.remainingSpace() == 0) {
                    this.buffer.flushToStream(this.out);
                }
                this.buffer.fillFromBuffer(value);
            }
        }

        @Override
        void flush() throws IOException {
            this.buffer.flushToStream(this.out);
        }
    }

    private static final class HeapByteBufferEncoder
    extends ByteArrayEncoder {
        private final ByteBuffer buffer;
        private final int startPos;

        private HeapByteBufferEncoder(ByteBuffer buffer) {
            super(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            this.buffer = buffer;
            this.startPos = buffer.position();
        }

        @Override
        void flush() {
            this.buffer.position(this.startPos + this.pos - this.offset);
        }
    }

    private static final class ByteBufferEncoder
    extends Encoder {
        private final ByteBuffer buffer;
        private final boolean reverse;

        private ByteBufferEncoder(ByteBuffer buffer) {
            this.buffer = buffer;
            this.reverse = buffer.order() == ByteOrder.BIG_ENDIAN;
        }

        @Override
        void writeByte(byte value) throws IOException {
            try {
                this.buffer.put(value);
            }
            catch (BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeBytes(byte[] value, int offset, int length) throws IOException {
            try {
                this.buffer.put(value, offset, length);
            }
            catch (IndexOutOfBoundsException | BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeBytes(ByteBuffer value) throws IOException {
            try {
                this.buffer.put(value);
            }
            catch (BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeVarint32(int value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        this.buffer.put((byte)value);
                        break;
                    }
                    this.buffer.put((byte)(value & 0x7F | 0x80));
                    value >>>= 7;
                }
            }
            catch (BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeVarint64(long value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer.put((byte)value);
                        break;
                    }
                    this.buffer.put((byte)((int)value & 0x7F | 0x80));
                    value >>>= 7;
                }
            }
            catch (BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeFixed32(int value) throws IOException {
            if (this.reverse) {
                value = Integer.reverseBytes(value);
            }
            try {
                this.buffer.putInt(value);
            }
            catch (BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }

        @Override
        void writeFixed64(long value) throws IOException {
            if (this.reverse) {
                value = Long.reverseBytes(value);
            }
            try {
                this.buffer.putLong(value);
            }
            catch (BufferOverflowException e) {
                throw log.outOfWriteBufferSpace(e);
            }
        }
    }

    private static final class NoOpEncoder
    extends Encoder {
        private int count = 0;

        private NoOpEncoder() {
        }

        int getWrittenBytes() {
            return this.count;
        }

        void reset() {
            this.count = 0;
        }

        @Override
        void writeByte(byte value) {
            ++this.count;
        }

        @Override
        void writeBytes(byte[] value, int offset, int length) {
            this.count += length;
        }

        @Override
        void writeBytes(ByteBuffer value) {
            this.count += value.remaining();
        }

        @Override
        void writeVarint32(int value) {
            while (true) {
                ++this.count;
                if ((value & 0xFFFFFF80) == 0) break;
                value >>>= 7;
            }
        }

        @Override
        void writeVarint64(long value) {
            while (true) {
                ++this.count;
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) break;
                value >>>= 7;
            }
        }

        @Override
        void writeFixed32(int value) {
            this.count += 4;
        }

        @Override
        void writeFixed64(long value) {
            this.count += 8;
        }
    }
}

