/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.ClassifyingBlockTracker;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessor;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserPhase;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.DocumentBlockParser;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ParagraphParser;
import com.vladsch.flexmark.parser.core.ReferencePreProcessorFactory;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.parser.internal.BlockContinueImpl;
import com.vladsch.flexmark.parser.internal.BlockStartImpl;
import com.vladsch.flexmark.parser.internal.CommonmarkInlineParser;
import com.vladsch.flexmark.parser.internal.MatchedBlockParserImpl;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.BlankLineContainer;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.KeepTrailingBlankLineContainer;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.ItemFactoryMap;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.dependency.DependencyResolver;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DocumentParser
implements ParserState {
    public static final InlineParserFactory INLINE_PARSER_FACTORY = CommonmarkInlineParser::new;
    private static final HashMap<CustomBlockParserFactory, DataKey<Boolean>> CORE_FACTORIES_DATA_KEYS = new HashMap();
    private static final HashMap<DataKey<Boolean>, ParagraphPreProcessorFactory> CORE_PARAGRAPH_PRE_PROCESSORS;
    private BasedSequence line;
    private BasedSequence lineWithEOL;
    private int lineNumber = 0;
    private int lineStart = 0;
    private int lineEOLIndex = 0;
    private int lineEndIndex = 0;
    private int index = 0;
    private int column = 0;
    private boolean columnIsInTab;
    private int nextNonSpace = 0;
    private int nextNonSpaceColumn = 0;
    private int indent = 0;
    private boolean blank;
    private boolean isBlankLine;
    private final List<BlockParserFactory> blockParserFactories;
    private final List<List<ParagraphPreProcessorFactory>> paragraphPreProcessorDependencies;
    private final List<List<BlockPreProcessorFactory>> blockPreProcessorDependencies;
    private final InlineParser inlineParser;
    private final DocumentBlockParser documentBlockParser;
    private final boolean blankLinesInAst;
    private final boolean trackDocumentLines;
    private final List<BasedSequence> lineSegments = new ArrayList<BasedSequence>();
    private final List<BlockParser> activeBlockParsers = new ArrayList<BlockParser>();
    private final ClassifyingBlockTracker blockTracker = new ClassifyingBlockTracker();
    private final Map<Node, Boolean> lastLineBlank = new HashMap<Node, Boolean>();
    private final DataHolder options;
    private ParserPhase currentPhase;
    private final Parsing myParsing;

    @Override
    public List<BasedSequence> getLineSegments() {
        return this.lineSegments;
    }

    @Override
    public void blockParserAdded(BlockParser blockParser) {
        this.blockTracker.blockParserAdded(blockParser);
    }

    @Override
    public void blockParserRemoved(BlockParser blockParser) {
        this.blockTracker.blockParserRemoved(blockParser);
    }

    public void blockAdded(@NotNull Block node) {
        this.blockTracker.blockAdded(node);
    }

    public void blockAddedWithChildren(@NotNull Block node) {
        this.blockTracker.blockAddedWithChildren(node);
    }

    public void blockAddedWithDescendants(@NotNull Block node) {
        this.blockTracker.blockAddedWithDescendants(node);
    }

    public void blockRemoved(@NotNull Block node) {
        this.blockTracker.blockRemoved(node);
    }

    public void blockRemovedWithChildren(@NotNull Block node) {
        this.blockTracker.blockRemovedWithChildren(node);
    }

    public void blockRemovedWithDescendants(@NotNull Block node) {
        this.blockTracker.blockRemovedWithDescendants(node);
    }

    @Override
    public ParserPhase getParserPhase() {
        return this.currentPhase;
    }

    public DocumentParser(DataHolder options, List<CustomBlockParserFactory> customBlockParserFactories, List<List<ParagraphPreProcessorFactory>> paragraphPreProcessorDependencies, List<List<BlockPreProcessorFactory>> blockPreProcessorDependencies, InlineParser inlineParser) {
        this.options = options;
        this.myParsing = inlineParser.getParsing();
        ArrayList<BlockParserFactory> blockParserFactories = new ArrayList<BlockParserFactory>(customBlockParserFactories.size());
        for (CustomBlockParserFactory factory : customBlockParserFactories) {
            blockParserFactories.add(factory.apply(options));
        }
        this.blockParserFactories = blockParserFactories;
        this.paragraphPreProcessorDependencies = paragraphPreProcessorDependencies;
        this.blockPreProcessorDependencies = blockPreProcessorDependencies;
        this.inlineParser = inlineParser;
        this.documentBlockParser = new DocumentBlockParser();
        this.activateBlockParser(this.documentBlockParser);
        this.currentPhase = ParserPhase.STARTING;
        this.blankLinesInAst = (Boolean)Parser.BLANK_LINES_IN_AST.get(options);
        this.trackDocumentLines = (Boolean)Parser.TRACK_DOCUMENT_LINES.get(options);
    }

    @Override
    public Parsing getParsing() {
        return this.myParsing;
    }

    @Override
    public MutableDataHolder getProperties() {
        return this.documentBlockParser.getBlock();
    }

    public static List<CustomBlockParserFactory> calculateBlockParserFactories(DataHolder options, List<CustomBlockParserFactory> customBlockParserFactories) {
        ArrayList<CustomBlockParserFactory> list = new ArrayList<CustomBlockParserFactory>(customBlockParserFactories);
        for (Map.Entry<CustomBlockParserFactory, DataKey<Boolean>> entry : CORE_FACTORIES_DATA_KEYS.entrySet()) {
            if (!((Boolean)entry.getValue().get(options)).booleanValue()) continue;
            list.add(entry.getKey());
        }
        return DependencyResolver.resolveFlatDependencies(list, null, null);
    }

    public static List<List<ParagraphPreProcessorFactory>> calculateParagraphPreProcessors(DataHolder options, List<ParagraphPreProcessorFactory> blockPreProcessors, InlineParserFactory inlineParserFactory) {
        ArrayList<ParagraphPreProcessorFactory> list = new ArrayList<ParagraphPreProcessorFactory>(blockPreProcessors);
        if (inlineParserFactory == INLINE_PARSER_FACTORY) {
            for (DataKey<Boolean> preProcessorDataKey : CORE_PARAGRAPH_PRE_PROCESSORS.keySet()) {
                if (!((Boolean)preProcessorDataKey.get(options)).booleanValue()) continue;
                ParagraphPreProcessorFactory preProcessorFactory = CORE_PARAGRAPH_PRE_PROCESSORS.get(preProcessorDataKey);
                list.add(preProcessorFactory);
            }
        }
        return DependencyResolver.resolveDependencies(list, null, null);
    }

    public static List<List<BlockPreProcessorFactory>> calculateBlockPreProcessors(DataHolder options, List<BlockPreProcessorFactory> blockPreProcessors) {
        return DependencyResolver.resolveDependencies(blockPreProcessors, null, null);
    }

    @Override
    public InlineParser getInlineParser() {
        return this.inlineParser;
    }

    public Document parse(CharSequence source) {
        int lineBreak;
        BasedSequence input = BasedSequence.of((CharSequence)source);
        int lineStart = 0;
        this.lineNumber = 0;
        this.documentBlockParser.initializeDocument(this.options, input);
        this.inlineParser.initializeDocument(this.documentBlockParser.getBlock());
        this.currentPhase = ParserPhase.PARSE_BLOCKS;
        while ((lineBreak = Parsing.findLineBreak((CharSequence)input, lineStart)) != -1) {
            BasedSequence line = input.subSequence(lineStart, lineBreak);
            int lineEOL = lineBreak;
            int lineEnd = lineBreak + 1 < input.length() && input.charAt(lineBreak) == '\r' && input.charAt(lineBreak + 1) == '\n' ? lineBreak + 2 : lineBreak + 1;
            this.lineWithEOL = input.subSequence(lineStart, lineEnd);
            this.lineStart = lineStart;
            this.lineEOLIndex = lineEOL;
            this.lineEndIndex = lineEnd;
            this.incorporateLine(line);
            ++this.lineNumber;
            lineStart = lineEnd;
        }
        if (input.length() > 0 && (lineStart == 0 || lineStart < input.length())) {
            this.lineWithEOL = input.subSequence(lineStart, input.length());
            this.lineStart = lineStart;
            this.lineEndIndex = this.lineEOLIndex = input.length();
            this.incorporateLine(this.lineWithEOL);
            ++this.lineNumber;
        }
        return this.finalizeAndProcess();
    }

    public Document parse(Reader input) throws IOException {
        int charsRead;
        BufferedReader bufferedReader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        StringBuilder file = new StringBuilder();
        char[] buffer = new char[16384];
        while ((charsRead = bufferedReader.read(buffer)) >= 0) {
            file.append(buffer, 0, charsRead);
            if (charsRead >= buffer.length) continue;
            break;
        }
        BasedSequence source = BasedSequence.of((CharSequence)file.toString());
        return this.parse((CharSequence)source);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getLineStart() {
        return this.lineStart;
    }

    @Override
    public int getLineEndIndex() {
        return this.lineEndIndex;
    }

    @Override
    public BasedSequence getLine() {
        return this.line;
    }

    @Override
    public BasedSequence getLineWithEOL() {
        return this.lineWithEOL;
    }

    @Override
    public int getLineEolLength() {
        return this.lineEndIndex - this.lineEOLIndex;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getNextNonSpaceIndex() {
        return this.nextNonSpace;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public boolean isBlankLine() {
        return this.isBlankLine;
    }

    @Override
    public BlockParser getActiveBlockParser() {
        return this.activeBlockParsers.get(this.activeBlockParsers.size() - 1);
    }

    @Override
    public BlockParser getActiveBlockParser(Block node) {
        BlockParser blockParser = this.blockTracker.getKey(node);
        return blockParser == null || blockParser.isClosed() ? null : blockParser;
    }

    @Override
    public List<BlockParser> getActiveBlockParsers() {
        return this.activeBlockParsers;
    }

    private void incorporateLine(BasedSequence ln) {
        BlockParser lastMatchedBlockParser;
        this.line = ln;
        this.index = 0;
        this.column = 0;
        this.columnIsInTab = false;
        if (this.trackDocumentLines) {
            this.lineSegments.add(this.lineWithEOL);
        }
        int matches = 1;
        BlankLine blankLine = null;
        this.findNextNonSpace();
        if (this.blank && this.blankLinesInAst) {
            blankLine = new BlankLine(this.lineWithEOL);
            this.documentBlockParser.getBlock().appendChild((Node)blankLine);
        }
        for (BlockParser blockParser : this.activeBlockParsers.subList(1, this.activeBlockParsers.size())) {
            boolean wasBlank = this.blank;
            this.findNextNonSpace();
            if (this.blank && this.blankLinesInAst) {
                if (blankLine == null) {
                    blankLine = new BlankLine(this.lineWithEOL);
                    this.documentBlockParser.getBlock().appendChild((Node)blankLine);
                }
                if (!wasBlank && blockParser.getBlock() instanceof BlankLineContainer) {
                    blankLine.setClaimedBlankLine(blockParser.getBlock());
                }
            }
            this.isBlankLine = wasBlank;
            BlockContinue result = blockParser.tryContinue(this);
            if (!(result instanceof BlockContinueImpl)) break;
            BlockContinueImpl blockContinue = (BlockContinueImpl)result;
            if (blockContinue.isFinalize()) {
                this.finalize(blockParser);
                return;
            }
            if (blockContinue.getNewIndex() != -1) {
                this.setNewIndex(blockContinue.getNewIndex());
                if (!this.blank && blockParser.getBlock() instanceof BlankLineContainer) {
                    this.findNextNonSpace();
                    if (this.blank) {
                        blankLine = new BlankLine(this.lineWithEOL, blockParser.getBlock());
                        blockParser.getBlock().appendChild((Node)blankLine);
                    }
                }
            } else if (blockContinue.getNewColumn() != -1) {
                this.setNewColumn(blockContinue.getNewColumn());
                if (!this.blank && blockParser.getBlock() instanceof BlankLineContainer) {
                    this.findNextNonSpace();
                    if (this.blank) {
                        blankLine = new BlankLine(this.lineWithEOL, blockParser.getBlock());
                        blockParser.getBlock().appendChild((Node)blankLine);
                    }
                }
            }
            ++matches;
            if (blankLine == null || !this.blankLinesInAst && blankLine.getClaimedBlankLine() != blockParser.getBlock() || !(blockParser.getBlock() instanceof BlankLineContainer)) continue;
            blockParser.getBlock().appendChild((Node)blankLine);
        }
        ArrayList<BlockParser> unmatchedBlockParsers = new ArrayList<BlockParser>(this.activeBlockParsers.subList(matches, this.activeBlockParsers.size()));
        BlockParser blockParser = lastMatchedBlockParser = this.activeBlockParsers.get(matches - 1);
        boolean allClosed = unmatchedBlockParsers.isEmpty();
        if (this.blank && this.isLastLineBlank((Node)blockParser.getBlock())) {
            ArrayList<BlockParser> matchedBlockParsers = new ArrayList<BlockParser>(this.activeBlockParsers.subList(0, matches));
            this.breakOutOfLists(matchedBlockParsers);
        }
        boolean tryBlockStarts = blockParser.isInterruptible() || blockParser.isContainer();
        BlockParser lastPrefixClaimer = null;
        while (tryBlockStarts) {
            boolean wasBlank = this.blank;
            this.findNextNonSpace();
            if (this.blank && !wasBlank) {
                lastPrefixClaimer = blockParser;
            }
            if (this.blank || this.indent < this.myParsing.CODE_BLOCK_INDENT && Parsing.isLetter((CharSequence)this.line, this.nextNonSpace)) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            BlockStartImpl blockStart = this.findBlockStart(blockParser);
            if (blockStart == null) {
                if (blockParser.isRawText() && blockParser.isInterruptible()) break;
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            if (!allClosed) {
                this.finalizeBlocks(unmatchedBlockParsers);
                allClosed = true;
            }
            if (blockStart.getNewIndex() != -1) {
                this.setNewIndex(blockStart.getNewIndex());
            } else if (blockStart.getNewColumn() != -1) {
                this.setNewColumn(blockStart.getNewColumn());
            }
            if (blockStart.isReplaceActiveBlockParser()) {
                this.removeActiveBlockParser();
            }
            for (BlockParser newBlockParser : blockStart.getBlockParsers()) {
                blockParser = this.addChild(newBlockParser);
                tryBlockStarts = newBlockParser.isContainer();
            }
        }
        if (!allClosed && !this.blank && this.getActiveBlockParser().isParagraphParser()) {
            this.addLine();
        } else {
            if (!allClosed) {
                this.finalizeBlocks(unmatchedBlockParsers);
            }
            this.propagateLastLineBlank(blockParser, lastMatchedBlockParser);
            if (this.blank && blockParser.getBlock() instanceof KeepTrailingBlankLineContainer) {
                if (blankLine != null) {
                    blockParser.getBlock().appendChild((Node)blankLine);
                } else if (blockParser.isContainer() && lastPrefixClaimer == blockParser) {
                    blankLine = new BlankLine(this.lineWithEOL, blockParser.getBlock());
                    blockParser.getBlock().appendChild((Node)blankLine);
                }
            }
            if (!blockParser.isContainer()) {
                this.addLine();
            } else if (!this.blank) {
                this.addChild(new ParagraphParser());
                this.addLine();
            }
        }
    }

    private void findNextNonSpace() {
        int i = this.index;
        int cols = this.column;
        this.blank = true;
        block4: while (i < this.line.length()) {
            char c = this.line.charAt(i);
            switch (c) {
                case ' ': {
                    ++i;
                    ++cols;
                    continue block4;
                }
                case '\t': {
                    ++i;
                    cols += 4 - cols % 4;
                    continue block4;
                }
            }
            this.blank = false;
            break;
        }
        this.nextNonSpace = i;
        this.nextNonSpaceColumn = cols;
        this.indent = this.nextNonSpaceColumn - this.column;
    }

    private void setNewIndex(int newIndex) {
        if (newIndex >= this.nextNonSpace) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        while (this.index < newIndex && this.index != this.line.length()) {
            this.advance();
        }
        this.columnIsInTab = false;
    }

    private void setNewColumn(int newColumn) {
        if (newColumn >= this.nextNonSpaceColumn) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        while (this.column < newColumn && this.index != this.line.length()) {
            this.advance();
        }
        if (this.column > newColumn) {
            --this.index;
            this.column = newColumn;
            this.columnIsInTab = true;
        } else {
            this.columnIsInTab = false;
        }
    }

    private void advance() {
        char c = this.line.charAt(this.index);
        if (c == '\t') {
            ++this.index;
            this.column += Parsing.columnsToNextTabStop(this.column);
        } else {
            ++this.index;
            ++this.column;
        }
    }

    private void addLine() {
        BasedSequence content = (BasedSequence)this.lineWithEOL.subSequence(this.index);
        if (this.columnIsInTab) {
            BasedSequence rest = (BasedSequence)content.subSequence(1);
            int spaces = Parsing.columnsToNextTabStop(this.column);
            StringBuilder sb = new StringBuilder(spaces + rest.length());
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
            content = PrefixedSubSequence.prefixOf((CharSequence)sb.toString(), (BasedSequence)rest);
        }
        this.getActiveBlockParser().addLine(this, content);
    }

    private BlockStartImpl findBlockStart(BlockParser blockParser) {
        MatchedBlockParserImpl matchedBlockParser = new MatchedBlockParserImpl(blockParser);
        for (BlockParserFactory blockParserFactory : this.blockParserFactories) {
            BlockStart result;
            if (!blockParser.canInterruptBy(blockParserFactory) || !((result = blockParserFactory.tryStart(this, matchedBlockParser)) instanceof BlockStartImpl)) continue;
            return (BlockStartImpl)result;
        }
        return null;
    }

    private void finalize(BlockParser blockParser) {
        Node next;
        Node lastChild;
        Block block;
        if (this.getActiveBlockParser() == blockParser) {
            this.deactivateBlockParser();
        }
        if ((block = blockParser.getBlock()).getParent() != null && (lastChild = block.getLastChild()) instanceof BlankLine && ((BlankLine)lastChild).getClaimedBlankLine() != block) {
            lastChild = lastChild.getFirstInChain();
            block.insertChainAfter(lastChild);
            block.setCharsFromContentOnly();
        }
        blockParser.closeBlock(this);
        blockParser.finalizeClosedBlock();
        while ((next = block.getNext()) instanceof BlankLine && next.getEndOffset() <= block.getEndOffset()) {
            next.unlink();
        }
    }

    private void processInlines() {
        for (BlockParser blockParser : this.blockTracker.allBlockParsers()) {
            blockParser.parseInlines(this.inlineParser);
        }
    }

    @Override
    public boolean endsWithBlankLine(Node block) {
        while (block != null) {
            if (this.isLastLineBlank(block)) {
                return true;
            }
            block = block.getLastBlankLineChild();
        }
        return false;
    }

    private void breakOutOfLists(List<BlockParser> blockParsers) {
        int lastList = -1;
        for (int i = blockParsers.size() - 1; i >= 0; --i) {
            BlockParser blockParser = blockParsers.get(i);
            if (!blockParser.breakOutOnDoubleBlankLine()) continue;
            lastList = i;
        }
        if (lastList != -1) {
            this.finalizeBlocks(blockParsers.subList(lastList, blockParsers.size()));
        }
    }

    private <T extends BlockParser> T addChild(T blockParser) {
        while (!this.getActiveBlockParser().canContain(this, blockParser, blockParser.getBlock())) {
            this.finalize(this.getActiveBlockParser());
        }
        this.getActiveBlockParser().getBlock().appendChild((Node)blockParser.getBlock());
        this.activateBlockParser(blockParser);
        return blockParser;
    }

    private void activateBlockParser(BlockParser blockParser) {
        this.activeBlockParsers.add(blockParser);
        if (!this.blockTracker.containsKey(blockParser)) {
            this.blockParserAdded(blockParser);
        }
    }

    private void deactivateBlockParser() {
        this.activeBlockParsers.remove(this.activeBlockParsers.size() - 1);
    }

    private void removeActiveBlockParser() {
        BlockParser old = this.getActiveBlockParser();
        this.deactivateBlockParser();
        this.blockParserRemoved(old);
        old.getBlock().unlink();
    }

    private void propagateLastLineBlank(BlockParser blockParser, BlockParser lastMatchedBlockParser) {
        Node lastChild;
        if (this.blank && (lastChild = blockParser.getBlock().getLastChild()) != null) {
            this.setLastLineBlank(lastChild, true);
        }
        boolean lastLineBlank = this.blank && blockParser.isPropagatingLastBlankLine(lastMatchedBlockParser);
        for (Block node = blockParser.getBlock(); node != null; node = node.getParent()) {
            this.setLastLineBlank((Node)node, lastLineBlank);
        }
    }

    private void setLastLineBlank(Node node, boolean value) {
        this.lastLineBlank.put(node, value);
    }

    @Override
    public boolean isLastLineBlank(Node node) {
        Boolean value = this.lastLineBlank.get(node);
        return value != null && value != false;
    }

    private boolean finalizeBlocks(List<BlockParser> blockParsers) {
        for (int i = blockParsers.size() - 1; i >= 0; --i) {
            BlockParser blockParser = blockParsers.get(i);
            this.finalize(blockParser);
        }
        return true;
    }

    private void preProcessParagraph(Paragraph block, List<ParagraphPreProcessorFactory> stage, ParagraphPreProcessorCache processorMap) {
        boolean hadChanges;
        do {
            hadChanges = false;
            for (ParagraphPreProcessorFactory factory : stage) {
                int i;
                ParagraphPreProcessor processor = (ParagraphPreProcessor)processorMap.getItem(factory);
                int pos = processor.preProcessBlock(block, this);
                if (pos <= 0) continue;
                hadChanges = true;
                BasedSequence blockChars = block.getChars();
                BasedSequence contentChars = (BasedSequence)blockChars.subSequence(pos + blockChars.countLeading(CharPredicate.WHITESPACE, pos, blockChars.length()));
                if (contentChars.isBlank()) {
                    block.unlink();
                    this.blockRemoved(block);
                    return;
                }
                int iMax = block.getLineCount();
                for (i = 0; i < iMax && block.getLineChars(i).getEndOffset() <= contentChars.getStartOffset(); ++i) {
                }
                if (i >= iMax) {
                    block.unlink();
                    this.blockRemoved(block);
                    return;
                }
                if (block.getLineChars(i).getEndOffset() == contentChars.getStartOffset()) {
                    block.setContent(block, i, iMax);
                    continue;
                }
                ArrayList lines = new ArrayList(iMax - i);
                lines.addAll(block.getContentLines().subList(i, iMax));
                int start = contentChars.getStartOffset() - ((BasedSequence)lines.get(0)).getStartOffset();
                if (start > 0 && start < ((BasedSequence)lines.get(0)).length()) {
                    lines.set(0, ((BasedSequence)lines.get(0)).subSequence(start));
                }
                int[] indents = new int[iMax - i];
                System.arraycopy(block.getLineIndents(), i, indents, 0, indents.length);
                block.setContentLines(lines);
                block.setLineIndents(indents);
                block.setChars(contentChars);
            }
        } while (hadChanges && stage.size() >= 2);
    }

    private void preProcessParagraphs() {
        if (this.blockTracker.getNodeClassifier().containsCategory(Paragraph.class)) {
            ParagraphPreProcessorCache processorMap = new ParagraphPreProcessorCache(this);
            for (List<ParagraphPreProcessorFactory> factoryStage : this.paragraphPreProcessorDependencies) {
                for (Paragraph paragraph : this.blockTracker.getNodeClassifier().getCategoryItems(Paragraph.class, (Object[])new Class[]{Paragraph.class})) {
                    this.preProcessParagraph(paragraph, factoryStage, processorMap);
                }
            }
        }
    }

    private void preProcessBlocks() {
        HashSet<Class<? extends Block>> blockTypes = new HashSet<Class<? extends Block>>();
        for (List<BlockPreProcessorFactory> dependents : this.blockPreProcessorDependencies) {
            for (BlockPreProcessorFactory factory : dependents) {
                blockTypes.addAll(factory.getBlockTypes());
            }
        }
        BitSet preProcessBitSet = this.blockTracker.getNodeClassifier().categoriesBitSet(blockTypes);
        if (!preProcessBitSet.isEmpty()) {
            for (List<BlockPreProcessorFactory> dependents : this.blockPreProcessorDependencies) {
                for (BlockPreProcessorFactory factory : dependents) {
                    ReversibleIterable blockList = this.blockTracker.getNodeClassifier().getCategoryItems(Block.class, factory.getBlockTypes());
                    BlockPreProcessor blockPreProcessor = factory.apply(this);
                    for (Block block : blockList) {
                        blockPreProcessor.preProcess(this, block);
                    }
                }
            }
        }
    }

    private Document finalizeAndProcess() {
        this.finalizeBlocks(this.activeBlockParsers);
        this.currentPhase = ParserPhase.PRE_PROCESS_PARAGRAPHS;
        this.preProcessParagraphs();
        this.currentPhase = ParserPhase.PRE_PROCESS_BLOCKS;
        this.preProcessBlocks();
        this.currentPhase = ParserPhase.PARSE_INLINES;
        this.processInlines();
        this.currentPhase = ParserPhase.DONE;
        Document document = this.documentBlockParser.getBlock();
        this.inlineParser.finalizeDocument(document);
        return document;
    }

    static {
        CORE_FACTORIES_DATA_KEYS.put(new BlockQuoteParser.Factory(), Parser.BLOCK_QUOTE_PARSER);
        CORE_FACTORIES_DATA_KEYS.put(new HeadingParser.Factory(), Parser.HEADING_PARSER);
        CORE_FACTORIES_DATA_KEYS.put(new FencedCodeBlockParser.Factory(), Parser.FENCED_CODE_BLOCK_PARSER);
        CORE_FACTORIES_DATA_KEYS.put(new HtmlBlockParser.Factory(), Parser.HTML_BLOCK_PARSER);
        CORE_FACTORIES_DATA_KEYS.put(new ThematicBreakParser.Factory(), Parser.THEMATIC_BREAK_PARSER);
        CORE_FACTORIES_DATA_KEYS.put(new ListBlockParser.Factory(), Parser.LIST_BLOCK_PARSER);
        CORE_FACTORIES_DATA_KEYS.put(new IndentedCodeBlockParser.Factory(), Parser.INDENTED_CODE_BLOCK_PARSER);
        CORE_PARAGRAPH_PRE_PROCESSORS = new HashMap();
        CORE_PARAGRAPH_PRE_PROCESSORS.put(Parser.REFERENCE_PARAGRAPH_PRE_PROCESSOR, new ReferencePreProcessorFactory());
    }

    private static class ParagraphPreProcessorCache
    extends ItemFactoryMap<ParagraphPreProcessor, ParserState> {
        ParagraphPreProcessorCache(ParserState param) {
            super((Object)param);
        }
    }
}

