/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JekyllTagNodeRenderer
implements NodeRenderer {
    private final boolean enabledRendering;
    private final Map<String, String> includeContent;

    public JekyllTagNodeRenderer(DataHolder options) {
        this.enabledRendering = (Boolean)JekyllTagExtension.ENABLE_RENDERING.get(options);
        this.includeContent = (Map)JekyllTagExtension.INCLUDED_HTML.get(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(JekyllTag.class, this::render));
        set.add(new NodeRenderingHandler(JekyllTagBlock.class, this::render));
        return set;
    }

    private void render(JekyllTag node, NodeRendererContext context, HtmlWriter html) {
        String content;
        if (this.enabledRendering) {
            html.text((CharSequence)node.getChars());
        } else if (node.getTag().equals("include") && this.includeContent != null && !node.getParameters().isEmpty() && (content = this.includeContent.get(node.getParameters().toString())) != null && !content.isEmpty()) {
            html.rawPre((CharSequence)content);
        }
    }

    private void render(JekyllTagBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new JekyllTagNodeRenderer(options);
        }
    }
}

