/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsInputOptions;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.InheritableThreadLocalStack;
import de.schlichtherle.truezip.util.Resource;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.Closeable;
import javax.annotation.concurrent.ThreadSafe;

@CleanupObligation
@ThreadSafe
public final class TConfig
extends Resource<RuntimeException>
implements Closeable {
    public static final BitField<FsInputOption> DEFAULT_INPUT_PREFERENCES = FsInputOptions.NONE;
    private static final BitField<FsInputOption> INPUT_PREFERENCES_COMPLEMENT_MASK = FsInputOptions.INPUT_PREFERENCES_MASK.not();
    public static final BitField<FsOutputOption> DEFAULT_OUTPUT_PREFERENCES = BitField.of((Enum)FsOutputOption.CREATE_PARENTS);
    private static final BitField<FsOutputOption> OUTPUT_PREFERENCES_COMPLEMENT_MASK = FsOutputOptions.OUTPUT_PREFERENCES_MASK.not();
    private static final InheritableThreadLocalStack<TConfig> configs = new InheritableThreadLocalStack();
    private static final TConfig GLOBAL = new TConfig();
    private FsManager manager;
    private TArchiveDetector detector;
    private BitField<FsInputOption> inputPreferences;
    private BitField<FsOutputOption> outputPreferences;

    public static TConfig get() {
        return (TConfig)configs.peekOrElse((Object)GLOBAL);
    }

    @CreatesObligation
    public static TConfig push() {
        return (TConfig)configs.push((Object)new TConfig(TConfig.get()));
    }

    @DischargesObligation
    public static void pop() {
        configs.popIf((Object)TConfig.get());
    }

    private TConfig() {
        this.manager = FsManagerLocator.SINGLETON.get();
        this.detector = TArchiveDetector.ALL;
        this.inputPreferences = DEFAULT_INPUT_PREFERENCES;
        this.outputPreferences = DEFAULT_OUTPUT_PREFERENCES;
    }

    private TConfig(TConfig template) {
        this.manager = template.getFsManager();
        this.detector = template.getArchiveDetector();
        this.inputPreferences = template.getInputPreferences();
        this.outputPreferences = template.getOutputPreferences();
    }

    @Deprecated
    public FsManager getFsManager() {
        return this.manager;
    }

    void setFsManager(FsManager manager) {
        if (null == manager) {
            throw new NullPointerException();
        }
        this.manager = manager;
    }

    public boolean isLenient() {
        return this.outputPreferences.get((Enum)FsOutputOption.CREATE_PARENTS);
    }

    public void setLenient(boolean lenient) {
        this.outputPreferences = this.outputPreferences.set((Enum)FsOutputOption.CREATE_PARENTS, lenient);
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public void setArchiveDetector(TArchiveDetector detector) {
        if (null == detector) {
            throw new NullPointerException();
        }
        this.detector = detector;
    }

    public BitField<FsInputOption> getInputPreferences() {
        return this.inputPreferences;
    }

    public void setInputPreferences(BitField<FsInputOption> preferences) {
        BitField illegal = preferences.and(INPUT_PREFERENCES_COMPLEMENT_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(illegal + " (illegal input preference(s))");
        }
        this.inputPreferences = preferences;
    }

    public BitField<FsOutputOption> getOutputPreferences() {
        return this.outputPreferences;
    }

    public void setOutputPreferences(BitField<FsOutputOption> preferences) {
        BitField illegal = preferences.and(OUTPUT_PREFERENCES_COMPLEMENT_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(illegal + " (illegal output preference(s))");
        }
        if (preferences.get((Enum)FsOutputOption.STORE) && preferences.get((Enum)FsOutputOption.COMPRESS)) {
            throw new IllegalArgumentException(preferences + " (either STORE or COMPRESS may be set, but not both)");
        }
        this.outputPreferences = preferences;
    }

    protected void onClose() {
        configs.popIf((Object)this);
    }
}

